---
name: KakaoTalk Agent
version: 1.2.7
description: "카카오톡 채널을 AI 에이전트로 만드는 스킬. Vercel Serverless 배포 지원. (옵션: 로컬 컴퓨터와 연결하여 파일/메모리 접근 가능)"
author: Yeomyeonggeori Inc. <iam@dawn.kim>
license: MIT
metadata:
  openclaw:
    env:
      - name: GEMINI_API_KEY
        description: "[Basic 모드] Gemini API 키"
        required: false
      - name: SUPABASE_URL
        description: "[Relay 모드] Supabase 프로젝트 URL"
        required: false
      - name: SUPABASE_SERVICE_KEY
        description: "[Relay 모드] Supabase Service Role Key"
        required: false
    requires:
      bins: ["vercel", "python3"]
---

# 🟡 카카오톡 AI 에이전트 (KakaoTalk Agent)

카카오톡 채널을 통해 **나만의 AI 비서**와 대화하세요.  
Vercel을 이용해 서버 걱정 없이 **무료로, 영구적으로** 운영할 수 있습니다.

두 가지 모드를 지원합니다.

| 모드 | 난이도 | 특징 | 추천 대상 |
|------|--------|------|-----------|
| **🅰️ Basic** | ⭐ | Vercel만 있으면 끝. 빠르고 간단함. | 단순 챗봇, Q&A 봇 |
| **🅱️ Relay** | ⭐⭐⭐ | 내 컴퓨터(OpenClaw)와 연결. **기억력(Memory)** 있음. | 개인 비서, 업무 자동화 |

---

## 🚀 공통 준비물

1. **카카오 비즈니스 계정**: [business.kakao.com](https://business.kakao.com) (채널 개설)
2. **카카오 i 오픈빌더**: [i.kakao.com](https://i.kakao.com) (봇 생성)
3. **Vercel 계정**: [vercel.com](https://vercel.com) (배포용)

---

## 🅰️ Option A: Basic 모드 (5분 컷)

AI가 단순한 대답만 하면 된다면 이 방법을 쓰세요.

### 1. 배포하기
터미널에서 아래 명령어를 실행하세요. (Gemini API 키 필요)

```bash
# 1. 스킬 폴더로 이동
cd skills/kakaotalk

# 2. Vercel 배포 (환경변수 설정)
# GEMINI_API_KEY는 본인 키로 변경하세요.
vercel deploy --prod --env GEMINI_API_KEY=AIzaSy...
```

배포가 끝나면 `https://...vercel.app` 주소가 나옵니다.  
**스킬 URL**: `https://[당신의주소].vercel.app/kakao`

### 2. 오픈빌더 연결
1. **스킬 등록**: 오픈빌더 > 스킬 > 추가 > URL 입력
2. **폴백 블록**: 시나리오 > 폴백 블록 > 봇 응답 > **스킬데이터 사용** 선택
3. **배포**: 우측 상단 [배포] 버튼 클릭

끝! 이제 카톡 채널에서 대화해보세요.

---

## 🅱️ Option B: Relay 모드 (진짜 비서)

카카오톡으로 **"내 컴퓨터에 있는 파일 읽어줘"** 하거나 **"아까 그 얘기 계속해"** 라고 하려면 이 방법을 쓰세요.  
Vercel이 우체통 역할을 하고, **당신의 컴퓨터가 직접 대답**합니다.

### 1. Supabase 준비 (우체통)
1. [Supabase](https://supabase.com) 프로젝트 생성.
2. **SQL Editor**에서 아래 쿼리 실행:
   ```sql
   create table kakaotalk_queue (
     id bigint generated by default as identity primary key,
     user_id text not null, utterance text not null, callback_url text,
     status text default 'pending', response text, created_at timestamptz default now()
   );
   ```

### 2. Vercel 배포 (우체통지기)
Gemini 키 대신 **Supabase 키**를 넣어서 배포합니다.

```bash
# SUPABASE_URL, SERVICE_KEY는 본인 프로젝트 설정 > API 메뉴에서 확인
vercel deploy --prod \
  --env SUPABASE_URL=https://... \
  --env SUPABASE_SERVICE_KEY=eyJ...
```

### 3. 오픈빌더 설정 (AI 챗봇)
1. **설정 > AI 챗봇으로 전환** (필수! 콜백 기능을 위해 필요)
2. 스킬 URL 등록 및 배포 (Basic 모드와 동일)

### 4. 로컬 왓처 실행 (본체)
내 컴퓨터에서 아래 스크립트를 실행해두면, 카톡 메시지를 처리합니다.

```bash
# ~/.openclaw/.env 파일에 SUPABASE_URL, SERVICE_KEY 저장 후:
python3 skills/kakaotalk/scripts/watcher.py
```

이제 컴퓨터가 켜져 있는 동안, 카톡 봇은 **당신과 똑같은 지능**을 갖게 됩니다.

---

## 🔧 고급 설정 (페르소나 변경)

봇의 말투나 역할을 바꾸고 싶다면, 배포할 때 환경변수를 추가하세요.

```bash
vercel deploy --prod \
  --env KAKAOTALK_SYSTEM_PROMPT="너는 친절한 고양이 로봇이야. 말 끝마다 '냥'을 붙여."
```

---

## 파일 구조

```
skills/kakaotalk/
├── api/
│   └── index.py      # Vercel 서버 (Basic/Relay 모드 자동 전환)
├── scripts/
│   └── watcher.py    # [Relay 모드용] 로컬 처리기
├── vercel.json       # Vercel 설정
└── SKILL.md          # 설명서
```
