---
name: kagi
description: Use the Kagi API (Search API + FastGPT) for web research when you want higher-quality results than Brave/Google, or when Brave Search is rate-limited. Triggers: “search with Kagi”, “Kagi search”, “use FastGPT”, “Kagi FastGPT”, “Kagi summarize”, or when you want programmatic web search via Kagi’s API token.
---

# Kagi (API)

Use the bundled Python scripts to call Kagi’s API from the OpenClaw host.

## Quick start

1) Create a token in https://kagi.com/settings/api
2) Export it for your shell/session:

```bash
export KAGI_API_TOKEN='…'
```

3) Run a search:

```bash
python3 scripts/kagi_search.py "haaps glass" --limit 10 --json
```

4) Or ask FastGPT (LLM + web search):

```bash
python3 scripts/kagi_fastgpt.py "Summarize the latest Haaps glass mentions" --json
```

## Tasks

### 1) Web search (Kagi Search API)

Use when you need a normal ranked list of results (URLs/titles/snippets).

Command:

```bash
python3 scripts/kagi_search.py "<query>" [--limit N] [--json]
```

Notes:
- Defaults to printing a readable digest; use `--json` for raw API output.
- The script automatically sets `Authorization: Bot <token>`.

### 2) Answer/summarize with citations (FastGPT)

Use when you want a short answer grounded in web results, including reference URLs.

Command:

```bash
python3 scripts/kagi_fastgpt.py "<question>" [--cache true|false] [--json]
```

### 3) Using Kagi as a drop-in for web_search

If Brave Search is rate-limited (429) or you want better results:
- Use `scripts/kagi_search.py` to fetch results
- Then use the main agent model to synthesize / summarize based on the returned URLs/snippets

## Files

- API reference snippets: `references/kagi-api.md`
- Python client + CLIs: `scripts/kagi_client.py`, `scripts/kagi_search.py`, `scripts/kagi_fastgpt.py`
