# Competition Landscape Report

Generates a comprehensive summary of recent Kaggle competition activity using a
hybrid approach: Python API for structured metadata + Playwright MCP tools for
rendered SPA content (problem statements, evaluation details, writeups).

## Workflow

When this module is invoked, the agent follows these 6 steps:

### Step 1: Verify Credentials

Run a quick credential check to ensure Kaggle API access works:

```bash
python3 skills/kaggle/modules/comp-report/scripts/utils.py
```

This verifies kaggle.json exists and the API authenticates successfully. If it
fails, prompt the user to configure credentials.

### Step 2: Gather Competition List

Run the competition listing script to query across all categories:

```bash
python3 skills/kaggle/modules/comp-report/scripts/list_competitions.py --lookback-days 30 --output json
```

This queries the Kaggle Python API across categories (featured, research,
playground, gettingStarted, recruitment, masters, + all) and outputs JSON with
each competition's slug, title, description, category, evaluation metric, reward,
team count, deadline, tags, and status (active/completed).

**Hackathon classification:** Hackathon competitions (tagged "hackathon") are
always classified as **active** even if their submission deadline has passed,
because they have no leaderboard — winners are announced on a Winners tab that
appears only after judging completes, often weeks or months later. Treat a
hackathon as "completed" only when you can confirm the Winners tab exists by
navigating to `/competitions/{slug}/winners` in Step 4.

Parse the JSON output to get the competition list.

### Step 3: Get Structured Details Per Competition

For each competition from Step 2, run:

```bash
python3 skills/kaggle/modules/comp-report/scripts/competition_details.py --slug SLUG
```

This retrieves file listings, top leaderboard entries (for completed), and top
kernels by votes. It also identifies potential solution writeup kernels by
pattern-matching titles.

### Step 4: Scrape Rich Content via Playwright MCP

This is the critical step. For each competition, use Playwright MCP tools:

1. **Problem statement**: `browser_navigate` to
   `https://www.kaggle.com/competitions/{slug}/overview` then `browser_snapshot`
   to extract the full problem description.

2. **Evaluation metric**: `browser_navigate` to
   `https://www.kaggle.com/competitions/{slug}/overview/evaluation` then
   `browser_snapshot` to extract metric details.

3. **Winner writeups** (completed competitions only): `browser_navigate` to
   `https://www.kaggle.com/competitions/{slug}/leaderboard` then use
   `browser_run_code` to extract all writeup links from the "Solution" column.

   **Hackathon competitions** do not have a Leaderboard tab. Instead they have:
   - A **Writeups** tab (`/competitions/{slug}/writeups`) showing all submitted
     entries — available during and after the competition.
   - A **Winners** tab (`/competitions/{slug}/winners`) that appears only after
     judges announce results.

4. **Top-scoring notebooks** (completed competitions only): `browser_navigate`
   to `https://www.kaggle.com/competitions/{slug}/code?sortBy=scoreAscending`
   then `browser_snapshot` to extract the top 5 notebook entries.

**Rate limiting**: Wait 3-5 seconds between page navigations to avoid throttling.

### Step 4b: Read Top Writeups

For each completed competition with writeups found in Step 4, navigate to the
top 3-5 writeup pages and extract the full solution description. Focus on: model
architecture, key techniques, training strategies, feature engineering, loss
functions, ensembling approaches, compute requirements, and any novel insights.

### Step 5: Compose the Report

Assemble a markdown report organized as follows:

- **Summary**: Competition counts by type, total prize pool, date range covered
- **Recently Launched** (grouped by type): Problem statement, dataset files,
  evaluation metric, tags, deadline, prize
- **Recently Completed** (grouped by type): Problem statement, dataset overview,
  metric, winner + top 5 leaderboard, winning approach summary from writeups,
  links to top solution notebooks, and a "Methods & Insights" blockquote

### Step 6: Present

Output the report inline.

## Scripts

- `scripts/utils.py` — Shared utilities (credential check, API init, rate limiting)
- `scripts/list_competitions.py` — Fetches competitions from all categories via Python API
- `scripts/competition_details.py` — Gets files, leaderboard, top kernels per competition

## References

- [competition-categories.md](references/competition-categories.md) — Competition types and API category mapping

## Prerequisites

- Kaggle credentials configured (KAGGLE_USERNAME + KAGGLE_KEY in ~/.kaggle/kaggle.json)
- `pip install kaggle requests`
- Playwright MCP tools available in your agent (Claude Code, Cursor, etc.)
