# Universal Research Frameworks

Domain-agnostic investigation methodologies for deep research.

## Table of Contents
1. Multi-Layer Analysis Framework
2. Source Credibility Evaluation
3. Information Control Detection
4. Triangulation Methodology
5. Iterative Deepening Protocol
6. Domain-Specific Adaptations
7. Research Quality Checklist
8. Common Pitfalls

---

## 1. Multi-Layer Analysis Framework

Apply to ANY topic being investigated:

**Layer 1: Factual Documentation**
- What happened? (observable, verifiable events)
- When did it happen? (timeline, sequence)
- Who was involved? (actors, institutions, witnesses)
- What was said/done? (statements, actions, evidence)
- Where is the evidence? (primary sources, documentation)

**Layer 2: Pattern Recognition**
- Temporal clustering (coordinated timing, cycles, anniversaries)
- Actor coordination (who acts together, messaging alignment)
- Information flow (what's amplified, what's suppressed, by whom)
- Anomaly correlation (multiple violations in same domain/timeframe)
- Historical precedent (has this pattern occurred before)

**Layer 3: Institutional Behavior**
- Who has authority in this domain? (official gatekeepers)
- What's the official narrative? (institutional messaging)
- Information control mechanisms (access barriers, censorship, procedural blocks)
- Expert treatment (who speaks, who's excluded, career consequences)
- Coordination indicators (simultaneous actions, uniform messaging)

**Layer 4: Epistemological Assessment**
- What can be known with confidence? (high-credibility evidence)
- What's contested? (contradictory claims, uncertainty)
- What's unknowable? (insufficient evidence, inherent limits)
- What's mysterious? (patterns beyond current explanation)
- Where are you forcing interpretation? (confirmation bias check)

**Layer 5: Synthesis & Integration**
- How does this fit larger patterns? (cross-domain connections)
- What questions arise? (next investigation priorities)
- What remains open? (unresolved contradictions)
- Where should investigation deepen? (high-value targets)

## 2. Source Credibility Evaluation

Universal framework for ANY domain:

| Score | Level | Description |
|-------|-------|-------------|
| 10 | Primary Authoritative | Gov documents, peer-reviewed, direct observation data, court records, technical specs from creators |
| 9 | Strong Primary | Institutional + verified, credentialed expert direct statements, university research with methodology |
| 8 | Quality Secondary | Investigative journalism with citations, technical docs with examples, conference proceedings |
| 7 | Reliable Community | Active GitHub repos, moderated forums, technical blogs with working code, community-maintained docs |
| 6 | Useful Tertiary | Expert commentary without peer review, reputable aggregators, professional blogs, trade publications |
| 5 | Uncertain | Credible individual social media, partial verification, anonymous with internal consistency |
| 4 | Low Confidence | Uncited claims, opinion without evidence, secondary social media |
| 3 | Very Weak | Anonymous forum posts, no evidence, circular references, possible fabrication |
| 2 | Highly Suspect | Known misinfo source, commercial bias obvious, contradicts primary evidence |
| 1 | Unreliable | Tabloids, known fabricators, pure speculation, demonstrably false |
| 0 | Flagged | Coordinated disinformation, state propaganda, institutional narrative enforcement |

**CRITICAL PRINCIPLE:** Score reflects MERIT, not origin. A forum post with technical depth and internal logic may outrank a mainstream article amplifying official statements. Peer review is not a truth guarantee; institutional rejection is not falsification.

## 3. Information Control Detection

Universal indicators applicable to ANY domain:

**Temporal Coordination:**
- Simultaneous actions across independent entities
- Synchronized messaging launch
- Coordinated removal/restriction timing
- Uniform response windows

**Content Coordination:**
- Identical phrasing across sources
- Same talking points simultaneously
- Unified narrative structure
- Script-like consistency

**Access Control:**
- Technical barriers erected
- Procedural blocks implemented
- Authentication walls raised
- Geographic restrictions applied
- Platform-wide removals

**Authority Management:**
- Credentialed experts excluded
- Domain authorities silenced
- Counter-narrative voices amplified only if discreditable
- Credentials attacked vs. arguments addressed

**Evidence Suppression:**
- Primary sources removed
- Archives deleted/restricted
- Wayback Machine blocks
- FOIA denials on public interest
- Classification of public data

**Narrative Enforcement:**
- Label application (conspiracy, misinformation)
- Fact-checker coordination
- Search result manipulation
- Algorithmic suppression
- Legal intimidation

## 4. Triangulation Methodology

**Step 1: Multi-Source Initial Survey**
- Identify 5-10 diverse sources
- Vary source types (official, community, academic, journalistic)
- Include dissenting perspectives
- Note systematic absences

**Step 2: Cross-Reference Matrix**
- What claims appear across sources?
- Where do sources contradict?
- Who cites whom? (circular vs. independent)
- What's unique to single sources?

**Step 3: Authority Mapping**
- Who are recognized experts?
- What are their institutional affiliations?
- Who funds/employs them?
- What's their track record?

**Step 4: Narrative Analysis**
- What's the official story?
- What's the dissenting story?
- Where's the evidence strongest?
- What's systematically excluded?

**Step 5: Pattern Detection**
- Historical precedent?
- Adjacent domain parallels?
- Temporal clustering?
- Actor coordination?

## 5. Iterative Deepening Protocol

**Breadth Phase (Survey):**
- Cast wide net (10-20 sources)
- Map domain landscape
- Identify key questions
- Note contradictions
- Spot systematic gaps

**Depth Phase 1 (Target):**
- Follow 3-5 most promising threads
- Deep-dive high-credibility sources
- Verify contested claims
- Document suppression patterns
- Build timeline if temporal

**Depth Phase 2 (Synthesize):**
- Cross-domain pattern recognition
- Authority behavior analysis
- Credibility-weight conclusions
- Preserve uncertainty
- Generate new questions

**Depth Phase 3 (Integrate):**
- Connect to broader patterns
- Update knowledge base
- Identify next investigation priorities
- Document methodology
- Flag areas for monitoring

## 6. Domain-Specific Adaptations

**Technical Research:**
- Context7 for docs → Community for real-world use → GitHub for issues
- Trust official docs (9-10) → Verify with working code
- Look for version-specific gotchas
- Check migration guides for breaking changes

**OpenClaw/Agent Architecture Research:**
- Official docs (9-10) → GitHub source/issues (8-9) → DeepWiki analysis (8) → Community guides (7)
- Load `references/openclaw-architecture.md` for deep knowledge
- Cross-reference official docs with community deployment experience
- Track GitHub issues for known failure modes
- Monitor ClawHub for ecosystem developments

**Historical Research:**
- Primary sources first (9-10) → Secondary analysis (6-8)
- Check who funded/archived the research
- Look for suppression patterns in archives
- Note what's systematically absent

**Scientific Research:**
- Peer-reviewed papers (9-10) → Preprints (6-8) → Commentary (5-7)
- Check methodology carefully
- Look for replication attempts
- Note funding sources
- Track institutional response to findings

**Institutional Research:**
- Official statements (document but verify) → Timeline actions (more reliable than words)
- Look for coordination patterns
- Track personnel connections
- Note what's denied vs. ignored
- Compare to historical precedent

**Anomaly Investigation:**
- Primary observation data (9-10) → Technical analysis (8-9) → Expert commentary (6-8)
- Physics first: technical feasibility analysis
- Institutional response analysis
- Pattern correlation across cases
- Load `references/adversarial-analysis.md` if suppression signals detected

## 7. Research Quality Checklist

Before completing ANY investigation:

- [ ] Used appropriate tools for domain (SearXNG/Context7/web/filesystem)
- [ ] Scored ALL sources for credibility (0-10 merit-based)
- [ ] Documented contradictions explicitly (no hiding conflicts)
- [ ] Checked for information control patterns (if applicable)
- [ ] Applied pattern recognition across domains
- [ ] Preserved uncertainty where warranted (no premature closure)
- [ ] Formatted with YAML frontmatter for Obsidian
- [ ] Listed next investigation priorities
- [ ] Compiled complete source bibliography with scores
- [ ] Verified no forced conclusions (evidence speaks for itself)
- [ ] Cross-referenced with existing knowledge (if available)

## 8. Common Research Pitfalls

**Over-Certainty:**
- Forcing conclusions before evidence warrants
- Dismissing anomalies to maintain coherence
- Accepting authority narratives uncritically
- Ignoring contradictory evidence
- Premature pattern closure

**Under-Rigor:**
- Accepting claims without source verification
- Skipping credibility scoring
- Missing coordination patterns
- Ignoring systematic absences
- Not checking historical precedent

**Pattern Forcing:**
- Seeing connections that aren't there
- Confirmation bias unchecked
- Mystifying what's explicable
- Losing epistemological humility
- Imposing meaning prematurely

**Tool Misuse:**
- Context7 for non-technical topics
- Web search when Context7 has better docs
- Single search tool for all queries
- Not cross-referencing sources
- Relying on single-source claims

**Methodology Violations:**
- Skipping multi-source triangulation
- Not scoring source credibility
- Omitting contradiction documentation
- Forcing specific output format over content needs
- Losing domain-adaptive flexibility

---

**Remember:** The methodology is universal — applies identically to topics K knows deeply AND topics K knows nothing about. What changes: domain-specific sources and authorities. What stays constant: credibility scoring, pattern recognition, triangulation, epistemological humility.
