# How to Add GitHub Topics (Visual Guide)

## Step-by-Step

### 1. Go to Your Repo
Visit: https://github.com/jzOcb/agent-guardrails

### 2. Click the Settings Gear
Look for the "About" section on the right side → Click the ⚙️ gear icon

### 3. Add Topics
In the "Topics" field, type each of these and press Enter:

**Essential (Add these first):**
```
claude-code-skill
clawdbot-skill
ai-guardrails
enforcement
```

**Recommended:**
```
git-hooks
deployment-verification
mechanical-enforcement
ai-agents
devtools
code-quality
```

**Optional (for more discoverability):**
```
python
bash
automation
ci-cd
pre-commit-hooks
```

### 4. Save
Click "Save changes"

## What This Does

✅ **Claude Code users can find your skill:**
- Search: "claude code skill enforcement"
- Browse: https://github.com/topics/claude-code-skill
- Recommended when searching for guardrails/quality tools

✅ **Skill appears in relevant categories:**
- AI agents tools
- Code quality
- DevOps automation

✅ **Better GitHub SEO:**
- Shows up in searches
- Recommended to similar repos
- Featured in topic pages

## Verification

After adding topics, check:
1. Visit https://github.com/topics/claude-code-skill
2. Your repo should appear in the list
3. Click on it to verify it's showing properly

## Troubleshooting

**Topics not showing?**
- Make sure repo is public (not private)
- Wait 1-2 minutes for GitHub to index
- Refresh the page

**Can't find the gear icon?**
- Make sure you're logged in
- Make sure you have write access to the repo
- Try on desktop browser (mobile may not show)

**Topics not saving?**
- Check you have repo admin access
- Try adding one at a time
- Refresh and try again

---

**Done? Your skill is now discoverable by both Claude Code and Clawdbot users! 🎉**
