# Common Services - Cancellation Guide

Quick reference for cancellation URLs, dark patterns, and tips.

## Streaming & Entertainment

| Service | Cancel URL | Notes |
|---------|-----------|-------|
| Netflix | netflix.com/cancelplan | Easy, immediate |
| Spotify | spotify.com/account | Look for "Change plan" |
| YouTube Premium | youtube.com/paid_memberships | Under subscriptions |
| YouTube TV | tv.youtube.com/settings | Must pause first or cancel |
| Hulu | account.hulu.com | Look for "Cancel" |
| Disney+ | disneyplus.com/account | Under subscription |
| HBO Max | account.hbomax.com | Depends on billing source |
| Apple TV+ | appleid.apple.com | Under subscriptions |
| Amazon Prime | amazon.com/primecentral | They push retention offers |
| Paramount+ | paramountplus.com/account | Easy |
| Peacock | peacocktv.com/account | Under plan details |

## AI & Developer Tools

| Service | Cancel URL | Notes |
|---------|-----------|-------|
| ChatGPT Plus | chat.openai.com/settings | Under subscription |
| Claude Pro | claude.ai/settings | Under subscription |
| Midjourney | midjourney.com/account | Under Manage Sub |
| GitHub Copilot | github.com/settings/copilot | Under subscription |
| Replit | replit.com/account | Under subscription |
| Cursor | cursor.sh/settings | Under subscription |
| ElevenLabs | elevenlabs.io/subscription | Under your profile |
| Railway | railway.app/account/billing | Check usage first |
| Vercel | vercel.com/account | Team vs personal |

## Productivity

| Service | Cancel URL | Notes |
|---------|-----------|-------|
| Notion | notion.so/my-account | Under Plans |
| Superhuman | superhuman.com/settings | Email required |
| Dropbox | dropbox.com/account/plan | Retention offers |
| 1Password | 1password.com/account | Check family vs individual |
| Todoist | todoist.com/app/settings/subscription | Easy |
| Evernote | evernote.com/account | Dark patterns |

## Social & Communication

| Service | Cancel URL | Notes |
|---------|-----------|-------|
| X Premium | twitter.com/settings/subscriptions | Under monetization |
| Discord Nitro | discord.com/settings/subscriptions | Easy |
| LinkedIn Premium | linkedin.com/premium/cancel | Heavy retention |
| Slack | slack.com/account/settings | Workspace admin only |

## News & Media

| Service | Cancel URL | Notes |
|---------|-----------|-------|
| NYTimes | nytimes.com/subscription | Call required for some plans |
| WSJ | wsj.com/account | Call may be required |
| Washington Post | washingtonpost.com/my-account | Under subscription |
| The Athletic | theathletic.com/account | Under membership |
| Substack | substack.com/account/settings | Per-publication |

## Fitness (Dark Pattern Warning)

| Service | How to Cancel | Warning |
|---------|--------------|---------|
| **Equinox** | In-person or certified mail | 45-day notice, contract trap |
| **24 Hour Fitness** | Call 1-800-432-6348 | Retention scripts, be firm |
| **Planet Fitness** | In-person at home club | Can't cancel online |
| **LA Fitness** | In-person or certified mail | 30-day notice |
| **Anytime Fitness** | Varies by franchise | Check your contract |
| **ClassPass** | classpass.com/account | Credits expire |
| **Peloton** | onepeloton.com/membership | App vs equipment |

## Dark Pattern Services

These make cancellation intentionally difficult:

### Phone-Only Cancellation
- **SiriusXM**: 1-866-635-2349 (heavy retention)
- **NYTimes** (some plans): 1-800-591-9233
- **Gym memberships**: See fitness section above

### Certified Mail Required
- **Equinox**: Certified mail to home club
- **LA Fitness**: Certified mail with 30-day notice

### Hidden Cancel Buttons
- **Amazon Prime**: 4+ clicks deep, multiple "are you sure" screens
- **Adobe Creative Cloud**: Chat required for annual plans

### Retention Offer Pressure
- **SiriusXM**: Will offer 50%+ discounts
- **Cable/Internet**: Retention department has better deals
- **LinkedIn Premium**: Multiple guilt screens

## Tips for Difficult Cancellations

### Gym Contracts
1. **Check end date** - May be approaching natural end
2. **Move clause** - Cancellable if moving 25+ miles away
3. **Medical exemption** - Doctor's note for injury
4. **Transfer option** - Some contracts allow member transfer
5. **Credit card** - Dispute if they won't cancel

### Retention Scripts
Say: "I've already made my decision. Please process the cancellation."
Repeat as needed. Don't engage with offers.

### Documentation
- Screenshot confirmation pages
- Save cancellation emails
- Note date/time of calls
- Get confirmation numbers

### Credit Card Backup
If a service won't cancel:
1. Request cancellation in writing (email)
2. Screenshot the request
3. If they keep charging, dispute with credit card as "cancelled service"
