# 初中数学研学案技能包

## 概述
基于人教版2024新版教材的初中数学全套研学案技能包，包含七年级、八年级、九年级所有章节的知识训练学案、教学课件、同步练习和复习资料。

## 功能特性
1. **完整的教学体系**：覆盖初中数学全部教学内容
2. **分层教学设计**：基础+培优，满足不同层次学生需求
3. **配套资源丰富**：学案+答案+课件+教案+练习全套
4. **中考备考支持**：九年级中考专题复习资料
5. **自动化工具**：快速生成教学计划和复习资料

## 包含内容

### 七年级
- **第4章**：一元一次方程（5个课时）
- **第5章**：图形的初步
- **有理数**：基础概念和运算
- **整式的加减**：代数基础

### 八年级  
- **第13章**：三角形（13.1-13.3）
- **第14章**：全等三角形
- **第15章**：轴对称
- **第16章**：整式的乘法与因式分解
- **第17章**：分式

### 九年级
- **二次函数**：图像、性质、应用
- **旋转**：图形变换
- **圆**：性质、定理、计算
- **一元二次方程**：解法、应用
- **中考专题复习**：全套备考资料

## 使用方法

### 1. 快速查找教学资源
```
查找 七年级 一元一次方程 教学资源
查找 八年级 三角形 知识训练学案
查找 九年级 二次函数 中考复习
```

### 2. 生成教学计划
```
生成 七年级 第4章 教学计划
生成 八年级 第13-15章 复习计划
生成 九年级 中考复习时间表
```

### 3. 制作练习题
```
生成 一元一次方程 练习题（10题）
生成 三角形证明 培优题（5题）
生成 二次函数 中考真题（3题）
```

### 4. 分析教学进度
```
分析 七年级 教学进度
分析 八年级 知识点掌握情况
分析 九年级 中考备考进度
```

## 文件结构
```
初中数学研学案技能包/
├── SKILL.md                    # 技能说明文档
├── package.json                # 技能包配置
├── skills/
│   ├── 教学资源查找.js         # 资源查找功能
│   ├── 教学计划生成.js         # 计划生成功能
│   ├── 练习题制作.js           # 题目生成功能
│   └── 教学进度分析.js         # 进度分析功能
├── resources/
│   ├── 七年级/                 # 七年级教学资源索引
│   ├── 八年级/                 # 八年级教学资源索引  
│   └── 九年级/                 # 九年级教学资源索引
├── templates/
│   ├── 教学计划模板.md         # 教学计划模板
│   ├── 学案模板.md             # 知识训练学案模板
│   └── 复习计划模板.md         # 复习计划模板
└── scripts/
    ├── 资源索引生成.js         # 自动生成资源索引
    └── 模板填充.js             # 模板自动填充
```

## 安装要求
- OpenClaw 环境
- 基本的文件读写权限
- 建议配合文档处理技能使用

## 更新日志
- v1.0.0 (2026-02-25): 初始版本发布，包含初中数学全套研学案

## 作者
阿锋的教学资源整理

## 许可证
教育用途免费使用，禁止商业用途