# 初中数学研学案技能包

基于人教版2024新版教材的初中数学全套研学案技能包，为数学教师提供完整的教学资源支持。

## 🚀 快速开始

### 安装方法
1. **通过ClawdHub安装**（推荐）
   ```bash
   # 安装clawdhub CLI
   npm install -g clawdhub
   
   # 搜索技能包
   clawdhub search "初中数学"
   
   # 安装技能包
   clawdhub install junior-high-math-research-plans
   ```

2. **手动安装**
   - 下载技能包ZIP文件
   - 解压到OpenClaw的skills目录
   - 重启OpenClaw服务

### 基本使用
```javascript
// 查找教学资源
const { find } = require('./skills/教学资源查找');
const result = find('八年级', '三角形', '概念');
console.log(result);

// 生成教学计划
const { generateChapter } = require('./skills/教学计划生成');
const plan = generateChapter('八年级', '第13章 三角形');
console.log(plan);
```

## 📚 功能详解

### 1. 教学资源查找
根据年级、章节、关键词快速定位教学资源。

**示例**:
```javascript
// 查找八年级三角形相关资源
const resources = find('八年级', '三角形');

// 查找包含"全等"关键词的资源
const resources2 = find('八年级', '', '全等');

// 获取七年级所有章节
const chapters = listChapters('七年级');
```

### 2. 教学计划生成
自动生成各种类型的教学计划。

**可用计划类型**:
- **单课时计划**: `generateLesson('八年级', '第13章 三角形', '13.1 三角形的概念')`
- **章节计划**: `generateChapter('八年级', '第13章 三角形')`
- **学期计划**: `generateSemester('八年级', '上')`

### 3. 模板系统
提供可自定义的教学模板。

**可用模板**:
- `templates/教学计划模板.md` - 完整的教学计划模板
- `templates/学案模板.md` - 知识训练学案模板

**使用模板**:
```javascript
const template = require('./scripts/模板填充');
const filled = template.fill('教学计划模板.md', {
  年级: '八年级',
  章节: '第13章 三角形',
  教师: '张老师'
});
```

## 🏫 资源内容

### 七年级
- **第4章**: 一元一次方程（5个课时）
- **第5章**: 图形的初步
- **有理数**: 基础概念和运算
- **整式的加减**: 代数基础
- **期末复习**: 综合复习资料

### 八年级
- **第13章**: 三角形（13.1-13.3）
- **第14章**: 全等三角形
- **第15章**: 轴对称
- **第16章**: 整式的乘法与因式分解
- **第17章**: 分式
- **期中期末**: 考试复习资料

### 九年级
- **二次函数**: 图像、性质、应用
- **旋转**: 图形变换
- **圆**: 性质、定理、计算
- **概率**: 概率计算
- **一元二次方程**: 解法、应用
- **中考复习**: 全套备考资料

## 🛠 开发指南

### 项目结构
```
初中数学研学案技能包/
├── SKILL.md                    # 技能说明文档
├── package.json                # 技能包配置
├── README.md                   # 使用说明
├── skills/                     # 核心功能
│   ├── 教学资源查找.js         # 资源查找功能
│   └── 教学计划生成.js         # 计划生成功能
├── resources/                  # 资源索引
│   ├── 七年级资源索引.md
│   ├── 八年级资源索引.md
│   └── 九年级资源索引.md
├── templates/                  # 模板文件
│   ├── 教学计划模板.md
│   └── 学案模板.md
└── scripts/                    # 工具脚本
    ├── 发布准备.js             # 发布检查工具
    └── 模板填充.js             # 模板处理工具
```

### 扩展功能
1. **添加新资源**
   - 在`resources/`目录下创建新的资源索引
   - 更新`教学资源查找.js`中的索引加载逻辑

2. **添加新模板**
   - 在`templates/`目录下创建新模板
   - 使用`{{变量名}}`语法定义模板变量

3. **添加新功能**
   - 在`skills/`目录下创建新的功能模块
   - 在`package.json`中更新入口配置

### 测试方法
```bash
# 运行发布检查
node scripts/发布准备.js all

# 测试资源查找
node -e "const {find} = require('./skills/教学资源查找'); console.log(find('八年级', '三角形'))"

# 测试计划生成
node -e "const {generateChapter} = require('./skills/教学计划生成'); console.log(generateChapter('八年级', '第13章 三角形'))"
```

## 📦 发布指南

### 发布前检查
```bash
# 运行完整检查
node scripts/发布准备.js release
```

### 发布步骤
1. 确保所有检查通过
2. 压缩技能包文件夹为ZIP文件
3. 登录ClawdHub网站（https://clawhub.com）
4. 点击"发布技能"，上传ZIP文件
5. 填写技能信息，提交审核
6. 等待审核通过

### 版本管理
- 使用语义化版本号（如v1.0.0）
- 每次更新更新`package.json`中的版本号
- 在`CHANGELOG.md`中记录更新内容

## 🤝 贡献指南

### 报告问题
1. 在GitHub Issues中创建新问题
2. 描述问题的详细情况
3. 提供复现步骤
4. 附上相关截图或日志

### 提交改进
1. Fork项目仓库
2. 创建功能分支
3. 提交代码更改
4. 创建Pull Request
5. 等待代码审查

### 代码规范
- 使用中文注释和文档
- 遵循JavaScript标准风格
- 添加必要的错误处理
- 编写单元测试（如果适用）

## 📄 许可证

本技能包遵循**教育用途免费**许可证：
- 允许教育机构和个人教师免费使用
- 允许修改和分发用于教学目的
- 禁止商业用途和盈利性分发
- 保留作者署名权

## 📞 支持与联系

### 问题反馈
- GitHub Issues: [项目地址]/issues
- 邮箱: [联系邮箱]
- 微信: [微信号]

### 更新通知
- 关注ClawdHub上的技能包更新
- 订阅项目更新通知
- 加入OpenClaw教师交流群

### 培训支持
- 提供技能包使用培训
- 教学资源整合指导
- 个性化定制服务

## 🙏 致谢

感谢以下贡献者：
- **阿锋** - 项目发起者和主要开发者
- **OpenClaw社区** - 提供技术平台支持
- **一线数学教师** - 提供教学实践反馈

特别感谢所有使用本技能包的教师和教育工作者，你们的反馈是我们改进的动力！

---
**最后更新**: 2026年2月25日  
**当前版本**: v1.0.0  
**维护状态**: 积极维护  

*让数学教学更轻松，让学习更有趣！*