# Jungian Symbol Dictionary

A reference for common symbols in dreams and active imagination, with Jungian
interpretive frameworks. Remember: these are starting points for exploration,
not authoritative meanings. The dreamer's associations always take precedence.

---

## How to Use This Dictionary

```
SYMBOL INTERPRETATION PROTOCOL
════════════════════════════════════════════════════════════════════════════════

    STEP 1: DREAMER'S ASSOCIATIONS FIRST
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  What does this symbol mean to YOU?                                    │
    │  What memories, feelings, or thoughts arise?                           │
    │  These personal associations are PRIMARY.                              │
    └─────────────────────────────────────────────────────────────────────────┘

    STEP 2: CONTEXT IN THE DREAM
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  What is the symbol doing?                                             │
    │  How does the dreamer relate to it?                                    │
    │  What emotions accompany it?                                           │
    └─────────────────────────────────────────────────────────────────────────┘

    STEP 3: CULTURAL/ARCHETYPAL AMPLIFICATION
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  Only AFTER personal associations: consult collective meanings.        │
    │  This dictionary provides archetypal starting points.                  │
    │  Use to enrich, not replace, the dreamer's experience.                 │
    └─────────────────────────────────────────────────────────────────────────┘

    STEP 4: COMPENSATION QUESTION
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  How might this symbol balance the dreamer's conscious attitude?       │
    │  What is the psyche trying to communicate?                             │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

## Water Symbols

```
WATER: THE UNCONSCIOUS
════════════════════════════════════════════════════════════════════════════════

    Water in dreams almost universally represents unconscious contents—
    the emotional, instinctual life below the surface of awareness.

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  OCEAN                       │  Collective unconscious                  │
    │                              │  Vastness of psyche                      │
    │                              │  Source of all life                      │
    │                              │  Can be overwhelming (drowning risk)     │
    │                              │  CW refs: CW 9i, archetypes              │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  LAKE                        │  Personal unconscious                    │
    │                              │  Bounded, accessible depths              │
    │                              │  Place of reflection (mirror)            │
    │                              │  What dwells in YOUR depths?             │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  RIVER                       │  Flow of life/time                       │
    │                              │  Heraclitus: can't step twice            │
    │                              │  Direction of psychic energy             │
    │                              │  Crossing = major transition             │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  POOL/POND                   │  Contained unconscious content           │
    │                              │  Something specific to explore           │
    │                              │  Still = reflection possible             │
    │                              │  Murky = unclear content                 │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  RAIN                        │  Fertilizing unconscious contents        │
    │                              │  Blessings from above/within             │
    │                              │  Tears, grief, cleansing                 │
    │                              │  Storm = emotional turmoil               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FLOOD                       │  Unconscious overwhelming ego            │
    │                              │  Dissolution of old structures           │
    │                              │  Forced transformation                   │
    │                              │  Biblical: cleansing + new beginning     │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DROWNING                    │  Ego being overwhelmed                   │
    │                              │  Regression to unconsciousness           │
    │                              │  Can be transformative (baptism)         │
    │                              │  Or dangerous (psychic dissolution)      │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SWIMMING                    │  Moving through unconscious              │
    │                              │  Ego maintaining awareness               │
    │                              │  Comfortable = good relationship w/ unc. │
    │                              │  Struggling = difficulty with emotions   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DIVING                      │  Intentional descent                     │
    │                              │  Active exploration of depths            │
    │                              │  Seeking something below                 │
    │                              │  Hero's nekyia (underworld journey)      │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CLEAR WATER                 │  Conscious clarity about unconscious     │
    │                              │  Material ready to be seen               │
    │                              │  Transparency, truth                     │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DARK/MURKY WATER            │  Unknown unconscious content             │
    │                              │  Shadow material                         │
    │                              │  Not yet ready for consciousness         │
    │                              │  Potentially dangerous                   │
    └──────────────────────────────┴──────────────────────────────────────────┘

    WATER CREATURES:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  FISH                        │  Unconscious contents moving             │
    │                              │  Something "coming up"                   │
    │                              │  Christ symbol (Ichthys)                 │
    │                              │  Self emerging from depths               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  WHALE                       │  Containing vessel (Jonah)               │
    │                              │  Being swallowed by unconscious          │
    │                              │  Nigredo phase of transformation         │
    │                              │  The devouring mother                    │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SERPENT/EEL                 │  Instinctual wisdom                      │
    │                              │  Kundalini energy                        │
    │                              │  Transformation (shedding skin)          │
    │                              │  Can be healing or threatening           │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SHARK                       │  Dangerous unconscious content           │
    │                              │  Predatory complex                       │
    │                              │  Something pursuing you                  │
    │                              │  Shadow aggression                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  OCTOPUS                     │  Many-tentacled complex                  │
    │                              │  Mother complex (devouring)              │
    │                              │  Something with many "arms" into life    │
    │                              │  Feeling entangled                       │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Animal Symbols

```
ANIMALS: INSTINCTS AND NATURE
════════════════════════════════════════════════════════════════════════════════

    Animals typically represent instinctual energies, the body, or aspects
    of our animal nature that are more or less integrated with consciousness.

    DOMESTIC ANIMALS:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DOG                         │  Loyalty, devotion, instinct             │
    │                              │  "Man's best friend" = integrated self   │
    │                              │  Can be shadow (wild dogs = untamed)     │
    │                              │  Faithful guide to unconscious           │
    │                              │  CW refs: CW 5 (transformation)          │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CAT                         │  Independence, mystery                   │
    │                              │  Feminine instinct                       │
    │                              │  Intuition, self-sufficiency             │
    │                              │  Egyptian: sacred, lunar                 │
    │                              │  Witchcraft associations (shadow fem.)   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  HORSE                       │  Instinctual energy                      │
    │                              │  Libido, drive                           │
    │                              │  Can carry you or run away               │
    │                              │  Pegasus: spiritual transcendence        │
    │                              │  CW refs: CW 5 (hero's horse)            │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  COW                         │  Nourishment, mother                     │
    │                              │  Sacred (Hindu tradition)                │
    │                              │  Fertility, abundance                    │
    │                              │  Patience, grounding                     │
    └──────────────────────────────┴──────────────────────────────────────────┘

    WILD ANIMALS:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  LION                        │  Power, royalty                          │
    │                              │  Solar symbol                            │
    │                              │  Dominant instinct                       │
    │                              │  Can be threat or ally                   │
    │                              │  Alchemical: "red lion" = sulphur        │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BEAR                        │  Primal power                            │
    │                              │  The devouring mother                    │
    │                              │  Hibernation = introspection             │
    │                              │  Resurrection (emerges in spring)        │
    │                              │  Protective ferocity                     │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  WOLF                        │  Shadow, the predator within             │
    │                              │  Pack mentality, belonging               │
    │                              │  Instinct vs. civilization               │
    │                              │  Devouring (fairy tales)                 │
    │                              │  Teacher, pathfinder (native)            │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SNAKE                       │  Transformation (shedding skin)          │
    │                              │  Kundalini, life force                   │
    │                              │  Healing (Asclepius staff)               │
    │                              │  Temptation (Eden)                       │
    │                              │  Chthonic wisdom                         │
    │                              │  CW refs: CW 5, CW 9i extensively        │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SPIDER                      │  Weaving fate                            │
    │                              │  The devouring mother                    │
    │                              │  Creativity (web-making)                 │
    │                              │  Patience, trap-setting                  │
    │                              │  Shadow feminine                         │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  EAGLE                       │  Spirit, transcendence                   │
    │                              │  Far-seeing (perspective)                │
    │                              │  Solar, masculine                        │
    │                              │  Connection to divine                    │
    │                              │  Prometheus' tormentor                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  OWL                         │  Wisdom (Athena's companion)             │
    │                              │  Night vision = seeing in dark           │
    │                              │  Death omen (some cultures)              │
    │                              │  Feminine wisdom                         │
    │                              │  The unconscious that sees              │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  RAVEN/CROW                  │  Death and transformation                │
    │                              │  Messenger between worlds                │
    │                              │  Trickster energy                        │
    │                              │  Alchemical nigredo (blackening)         │
    │                              │  Odin's companions (thought/memory)      │
    └──────────────────────────────┴──────────────────────────────────────────┘

    MYTHOLOGICAL CREATURES:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  DRAGON                      │  Guardian of treasure/Self               │
    │                              │  Must be confronted by hero              │
    │                              │  Primal chaos, untamed libido            │
    │                              │  Alchemical: prima materia               │
    │                              │  CW refs: CW 5 (hero myth)               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  PHOENIX                     │  Death and rebirth                       │
    │                              │  Transformation through fire             │
    │                              │  Rising from ashes                       │
    │                              │  Alchemical rubedo (reddening)           │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Architecture Symbols

```
BUILDINGS: STRUCTURE OF THE PSYCHE
════════════════════════════════════════════════════════════════════════════════

    Buildings typically represent the structure of the psyche itself.
    Different parts of buildings correspond to different aspects of self.

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  HOUSE                       │  The SELF, entire psyche                 │
    │                              │  "In my father's house are many rooms"   │
    │                              │  Your own house = your own psyche        │
    │                              │  Childhood home = origins, early self    │
    │                              │  CW refs: CW 12 (alchemy)                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BASEMENT/CELLAR             │  Personal unconscious                    │
    │                              │  What's "below" awareness                │
    │                              │  Stored/repressed material               │
    │                              │  Unknown basement = unknown self         │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  ATTIC                       │  Higher consciousness                    │
    │                              │  Old memories, ancestral                 │
    │                              │  Spiritual aspirations                   │
    │                              │  What's "above" daily life               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  ROOMS                       │  Different aspects of personality        │
    │                              │  Unknown rooms = undiscovered self       │
    │                              │  Many rooms = complex psyche             │
    │                              │  Locked rooms = defended contents        │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DOOR                        │  Transition, threshold                   │
    │                              │  Access to new content                   │
    │                              │  Locked = defended                       │
    │                              │  Open = ready to explore                 │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  WINDOW                      │  Perspective, viewpoint                  │
    │                              │  Seeing in/out of psyche                 │
    │                              │  Consciousness looking at world          │
    │                              │  Light entering (insight)                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  STAIRS                      │  Movement between levels                 │
    │                              │  Ascending = toward consciousness        │
    │                              │  Descending = toward unconscious         │
    │                              │  Spiral = individuation                  │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  TEMPLE/CHURCH               │  The Self, sacred center                 │
    │                              │  Temenos, protected space                │
    │                              │  Connection to transcendent              │
    │                              │  The god-image within                    │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  TOWER                       │  Isolation, imprisonment                 │
    │                              │  Rapunzel: anima trapped                 │
    │                              │  Spiritual aspiration                    │
    │                              │  Babel: inflation, hubris                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CASTLE                      │  The defended Self                       │
    │                              │  Treasure within (Grail)                 │
    │                              │  Persona fortifications                  │
    │                              │  Must be stormed or entered              │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  RUIN                        │  Old structures falling apart            │
    │                              │  Persona dissolution                     │
    │                              │  What no longer serves                   │
    │                              │  History, ancestral material             │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Human Figures

```
PEOPLE IN DREAMS: ASPECTS OF SELF
════════════════════════════════════════════════════════════════════════════════

    Remember the SUBJECTIVE LEVEL: most figures represent parts of the dreamer.
    Only explore objective meanings after exhausting subjective interpretation.

    SAME-SEX FIGURES:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SHADOW FIGURE               │  The shadow (rejected self)              │
    │  (same sex, dark, inferior)  │  What you don't want to be               │
    │                              │  Following = complex pursuing            │
    │                              │  Threatening = shadow wants attention    │
    │                              │  CW refs: CW 9i extensively              │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  KNOWN SAME-SEX PERSON       │  That person's qualities in YOU          │
    │                              │  What they represent to dreamer          │
    │                              │  Projection carrier                      │
    │                              │  Ask: "What is X like?"                 │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  UNKNOWN SAME-SEX PERSON     │  Unknown aspect of self                  │
    │                              │  Shadow, often                           │
    │                              │  Undeveloped potential                   │
    │                              │  Archetypal figure (if numinous)         │
    └──────────────────────────────┴──────────────────────────────────────────┘

    OPPOSITE-SEX FIGURES:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  ANIMA/ANIMUS FIGURE         │  Contrasexual archetype                  │
    │  (unknown, compelling)       │  The "inner other"                       │
    │                              │  Soul-image                              │
    │                              │  Guide to unconscious                    │
    │                              │  CW refs: CW 7, CW 9i, CW 9ii            │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  ROMANTIC PARTNER IN DREAM   │  Relationship dynamics                   │
    │                              │  Projection carrier                      │
    │                              │  Inner masculine/feminine                │
    │                              │  Could be objective AND subjective       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  EX-PARTNER                  │  Unresolved material                     │
    │                              │  What that relationship represented      │
    │                              │  Anima/animus in that form               │
    │                              │  Nostalgia or warning                    │
    └──────────────────────────────┴──────────────────────────────────────────┘

    AUTHORITY FIGURES:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FATHER                      │  Father complex material                 │
    │                              │  Inner father (critical or supportive)   │
    │                              │  Authority, logos, structure             │
    │                              │  Spirit (Wise Old Man developing)        │
    │                              │  CW refs: CW 9i (father archetype)       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  MOTHER                      │  Mother complex material                 │
    │                              │  Inner mother (nurturing or devouring)   │
    │                              │  Matter, nature, body                    │
    │                              │  Great Mother archetype                  │
    │                              │  CW refs: CW 9i (mother archetype)       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  WISE OLD MAN/WOMAN          │  Mana personality                        │
    │                              │  Spiritual authority                     │
    │                              │  Guide, mentor                           │
    │                              │  Can inflate if identified with          │
    │                              │  CW refs: CW 9i (mana personalities)     │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  KING/QUEEN                  │  The Self (ruling center)                │
    │                              │  Dominant consciousness                  │
    │                              │  Divine authority                        │
    │                              │  Old king = needs renewal                │
    │                              │  CW refs: CW 14 (coniunctio)             │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CHILD                       │  New development                         │
    │                              │  Puer/Puella (eternal youth)             │
    │                              │  Divine child (Self emerging)            │
    │                              │  Wounded child (inner healing needed)    │
    │                              │  CW refs: CW 9i (child archetype)        │
    └──────────────────────────────┴──────────────────────────────────────────┘

    COLLECTIVE FIGURES:
    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CROWD/MOB                   │  Collective unconscious                  │
    │                              │  Many complexes activated                │
    │                              │  Loss of individuality                   │
    │                              │  Pressure to conform                     │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  STRANGER                    │  Unknown aspect of self                  │
    │                              │  Shadow or new potential                 │
    │                              │  The "other" within                      │
    │                              │  Invitation to explore                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  PURSUER/ATTACKER            │  Shadow complex                          │
    │                              │  What you're running from                │
    │                              │  Turn and face = integration begins      │
    │                              │  Wants your attention, not destruction   │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Actions and Events

```
DREAM ACTIONS: WHAT THE PSYCHE IS DOING
════════════════════════════════════════════════════════════════════════════════

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  ACTION                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FALLING                     │  Loss of ego control                     │
    │                              │  Letting go (can be positive)            │
    │                              │  Deflation after inflation               │
    │                              │  "Falling" into unconscious              │
    │                              │  Note: where you land matters            │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FLYING                      │  Inflation, rising above                 │
    │                              │  Spiritual aspiration                    │
    │                              │  Escape from earthly concerns            │
    │                              │  Can indicate too much "in the head"     │
    │                              │  Note: are you in control?               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BEING CHASED                │  Shadow pursuing                         │
    │                              │  Complex activated                       │
    │                              │  Running from part of self               │
    │                              │  Turn and face = begin integration       │
    │                              │  What are you avoiding?                  │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BEING NAKED                 │  Vulnerability exposed                   │
    │                              │  Persona stripped                        │
    │                              │  Shame, but also authenticity            │
    │                              │  Deflation (often compensatory)          │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  TAKING A TEST/EXAM          │  Self-evaluation                         │
    │                              │  Feeling unprepared                      │
    │                              │  Life is "testing" you                   │
    │                              │  Performance anxiety                     │
    │                              │  Note: did you pass or fail?             │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  TEETH FALLING OUT           │  Loss of power/potency                   │
    │                              │  Aging, mortality                        │
    │                              │  Communication difficulties              │
    │                              │  Biting/aggression issues                │
    │                              │  Vanity, appearance concerns             │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DYING/DEATH                 │  Transformation, not literal death       │
    │                              │  End of old way of being                 │
    │                              │  Ego death (initiation)                  │
    │                              │  Making room for new life                │
    │                              │  CW refs: CW 5 (hero's death/rebirth)    │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  KILLING/BEING KILLED        │  Destroying/having destroyed             │
    │                              │  An aspect of self                       │
    │                              │  Integration through "death"             │
    │                              │  Note: who kills whom, and how?          │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SEXUAL ACTIVITY             │  Union of opposites                      │
    │                              │  Coniunctio (alchemical marriage)        │
    │                              │  Integration of masculine/feminine       │
    │                              │  Sometimes literal sexuality too         │
    │                              │  CW refs: CW 14, CW 16                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CROSSING A THRESHOLD        │  Transition, initiation                  │
    │                              │  Entering new phase                      │
    │                              │  Liminal space                           │
    │                              │  Can't go back                           │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SEARCHING/FINDING           │  Quest for Self                          │
    │                              │  Lost object = lost aspect               │
    │                              │  Finding = integration possible          │
    │                              │  Note: what is sought/found?             │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Objects and Items

```
OBJECTS: TOOLS AND SYMBOLS
════════════════════════════════════════════════════════════════════════════════

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  OBJECT                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  MIRROR                      │  Self-reflection                         │
    │                              │  How you see yourself                    │
    │                              │  Vanity or insight                       │
    │                              │  What's reflected? (shadow?)             │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  KEY                         │  Access, solution                        │
    │                              │  What opens locked doors                 │
    │                              │  Power to enter                          │
    │                              │  Insight, understanding                  │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SWORD                       │  Discrimination, cutting through         │
    │                              │  Logos, intellect                        │
    │                              │  Aggression (positive or negative)       │
    │                              │  Hero's weapon                           │
    │                              │  CW refs: CW 5 (hero myth)               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CUP/CHALICE                 │  Receptivity, feminine                   │
    │                              │  Holy Grail (Self)                       │
    │                              │  Containing vessel                       │
    │                              │  Communion, sharing                      │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  RING                        │  Wholeness, commitment                   │
    │                              │  Marriage (inner or outer)               │
    │                              │  Eternal, no beginning/end               │
    │                              │  Self symbol (mandala)                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  GOLD/TREASURE               │  The Self, highest value                 │
    │                              │  "Gold in the shadow"                    │
    │                              │  Alchemical goal                         │
    │                              │  What's hidden and precious              │
    │                              │  CW refs: CW 12 (alchemy)                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  STONE                       │  The Self (philosopher's stone)          │
    │                              │  Permanence, foundation                  │
    │                              │  Alchemical lapis                        │
    │                              │  Also: coldness, rigidity                │
    │                              │  CW refs: CW 12 (alchemy)                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CLOCK/TIME                  │  Mortality, finitude                     │
    │                              │  Urgency, deadline                       │
    │                              │  "Time is running out"                   │
    │                              │  Life stage considerations               │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BOOK                        │  Knowledge, wisdom                       │
    │                              │  The unconscious as "book of life"       │
    │                              │  What's written (fate?)                  │
    │                              │  Reading = learning about self           │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CAR/VEHICLE                 │  How you move through life               │
    │                              │  Who's driving? (ego or complex)         │
    │                              │  Control, direction                      │
    │                              │  Body (vehicle for soul)                 │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  CLOTHING                    │  Persona, how you present                │
    │                              │  Wrong clothes = wrong persona           │
    │                              │  Naked = persona stripped                │
    │                              │  New clothes = new identity              │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Natural Phenomena

```
NATURE: FORCES AND LANDSCAPES
════════════════════════════════════════════════════════════════════════════════

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  SYMBOL                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SUN                         │  Consciousness, awareness                │
    │                              │  Masculine principle                     │
    │                              │  Life force, clarity                     │
    │                              │  Can be too bright (inflation)           │
    │                              │  CW refs: CW 5 (hero = sun)              │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  MOON                        │  Unconscious, reflection                 │
    │                              │  Feminine principle                      │
    │                              │  Cycles, change                          │
    │                              │  Lunacy (possession by moon)             │
    │                              │  CW refs: CW 14 (luna)                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  STARS                       │  Guidance, destiny                       │
    │                              │  The Self (distant but present)          │
    │                              │  Spiritual aspiration                    │
    │                              │  "Reach for the stars"                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FIRE                        │  Transformation                          │
    │                              │  Passion, anger, energy                  │
    │                              │  Purification, destruction               │
    │                              │  Alchemical: calcination                 │
    │                              │  CW refs: CW 12 (alchemy)                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  MOUNTAIN                    │  Spiritual aspiration                    │
    │                              │  Obstacle, challenge                     │
    │                              │  Place of revelation (Moses, Jesus)      │
    │                              │  Stability, permanence                   │
    │                              │  Climbing = individuation                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FOREST                      │  The unconscious                         │
    │                              │  Getting lost (midlife crisis)           │
    │                              │  Natural, wild self                      │
    │                              │  Dante: "dark wood" of midlife           │
    │                              │  Fairy tale setting                      │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  GARDEN                      │  Paradise, wholeness                     │
    │                              │  Cultivated nature (civilization)        │
    │                              │  Eden (lost innocence)                   │
    │                              │  Temenos, sacred space                   │
    │                              │  The Self's landscape                    │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  DESERT                      │  Barrenness, spiritual dryness           │
    │                              │  Purification (40 days/years)            │
    │                              │  Stripped to essentials                  │
    │                              │  Place of testing                        │
    │                              │  Shadow of the fertile                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  STORM                       │  Emotional turmoil                       │
    │                              │  Unconscious breaking through            │
    │                              │  Divine anger (Zeus)                     │
    │                              │  Clearing the air                        │
    │                              │  Catharsis coming                        │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  EARTHQUAKE                  │  Foundation shaking                      │
    │                              │  Everything you stood on questioned      │
    │                              │  Major psychic restructuring             │
    │                              │  Collective shadow erupting              │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Numbers

```
NUMBERS: ARCHETYPAL SIGNIFICANCE
════════════════════════════════════════════════════════════════════════════════

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  NUMBER                      │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  ONE (1)                     │  Unity, the Self                         │
    │                              │  Beginning, source                       │
    │                              │  Isolation or wholeness                  │
    │                              │  God, the One                            │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  TWO (2)                     │  Duality, opposition                     │
    │                              │  Conflict, tension                       │
    │                              │  Relationship, dialogue                  │
    │                              │  Masculine/feminine                      │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  THREE (3)                   │  Dynamism, process                       │
    │                              │  Trinity (thesis-antithesis-synthesis)   │
    │                              │  Incompleteness seeking fourth           │
    │                              │  Spiritual (Father-Son-Spirit)           │
    │                              │  CW refs: CW 11 (trinity)                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FOUR (4)                    │  Wholeness, stability                    │
    │                              │  The quaternity (Self symbol)            │
    │                              │  Four functions                          │
    │                              │  Four directions, elements               │
    │                              │  CW refs: CW 9ii, CW 11 (quaternity)     │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  FIVE (5)                    │  Human (4 + 1 center)                    │
    │                              │  The quintessence                        │
    │                              │  Integration of four + spirit            │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  SEVEN (7)                   │  Completion, cycle                       │
    │                              │  Days of creation                        │
    │                              │  Seven planets, chakras                  │
    │                              │  Stages of transformation                │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  TWELVE (12)                 │  Completeness, totality                  │
    │                              │  Zodiac, disciples, tribes               │
    │                              │  Full cycle of development               │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Colors

```
COLORS: EMOTIONAL AND ALCHEMICAL
════════════════════════════════════════════════════════════════════════════════

    ┌──────────────────────────────┬──────────────────────────────────────────┐
    │  COLOR                       │  POSSIBLE MEANINGS                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BLACK                       │  Nigredo (alchemical blackening)         │
    │                              │  Depression, shadow                      │
    │                              │  Death before rebirth                    │
    │                              │  Prima materia                           │
    │                              │  CW refs: CW 12, CW 14                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  WHITE                       │  Albedo (alchemical whitening)           │
    │                              │  Purification, innocence                 │
    │                              │  Consciousness, clarity                  │
    │                              │  Can be: sterile, cold                   │
    │                              │  CW refs: CW 12, CW 14                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  RED                         │  Rubedo (alchemical reddening)           │
    │                              │  Passion, blood, life                    │
    │                              │  Anger, emotion                          │
    │                              │  Integration of opposites                │
    │                              │  CW refs: CW 12, CW 14                   │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  GOLD                        │  The Self, highest value                 │
    │                              │  Alchemical goal                         │
    │                              │  Sun, consciousness                      │
    │                              │  Divinity, incorruptibility              │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  BLUE                        │  Sky, spirit                             │
    │                              │  Depression ("feeling blue")             │
    │                              │  Mary, heavenly                          │
    │                              │  Thinking function                       │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  GREEN                       │  Nature, growth                          │
    │                              │  Life force                              │
    │                              │  Envy ("green with envy")                │
    │                              │  Alchemical viriditas                    │
    ├──────────────────────────────┼──────────────────────────────────────────┤
    │  YELLOW                      │  Citrinitas (alchemical yellowing)       │
    │                              │  Intellect, cowardice                    │
    │                              │  Sun, light                              │
    │                              │  Between white and red                   │
    └──────────────────────────────┴──────────────────────────────────────────┘
```

---

## Using This Dictionary

```
FINAL NOTES ON SYMBOL INTERPRETATION
════════════════════════════════════════════════════════════════════════════════

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  REMEMBER:                                                              │
    │                                                                         │
    │  1. PERSONAL ASSOCIATIONS FIRST                                        │
    │     What does this mean to YOU?                                        │
    │     These entries are starting points, not definitive meanings.        │
    │                                                                         │
    │  2. CONTEXT MATTERS                                                    │
    │     The same symbol can mean different things in different dreams.     │
    │     What is it doing? How do you feel about it?                        │
    │                                                                         │
    │  3. COMPENSATION                                                       │
    │     Ask: What conscious attitude is this symbol balancing?             │
    │                                                                         │
    │  4. THE DREAM DOESN'T LIE                                              │
    │     If an interpretation doesn't "click," it's probably wrong.         │
    │     The right meaning produces an "aha" moment.                        │
    │                                                                         │
    │  5. DREAMS ARE NOT CODED MESSAGES                                      │
    │     Jung: "I have no theory about dreams. I do not know how            │
    │     dreams arise. I am not at all sure that my way of handling         │
    │     dreams even deserves the name 'method.'"                           │
    │                                                                         │
    │  6. ENGAGE WITH THE SYMBOL                                             │
    │     Don't just interpret—dialogue with it through active imagination.  │
    │     Let it speak for itself.                                           │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

*This dictionary is a tool for exploration, not a codebook. The living symbol always exceeds its interpretation. Approach with humility and curiosity.*
