# Skill Integration Protocols

How the jungian-psychologist skill integrates with complementary skills for deeper psychological work.

---

## Table of Contents

1. [Integration Philosophy](#integration-philosophy)
2. [HRV-Alexithymia Expert Integration](#hrv-alexithymia-expert-integration)
3. [Wisdom-Accountability Coach Integration](#wisdom-accountability-coach-integration)
4. [Diagramming Expert Integration](#diagramming-expert-integration)
5. [Multi-Skill Workflow Examples](#multi-skill-workflow-examples)

---

## Integration Philosophy

```
WHY SKILL INTEGRATION MATTERS
════════════════════════════════════════════════════════════════════════════════

    Jung's psychology addresses multiple dimensions simultaneously:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  JUNGIAN DEPTH PSYCHOLOGY                                               │
    │  ─────────────────────────                                              │
    │                                                                         │
    │  • PSYCHE (soul, meaning, symbols)                                     │
    │    └── Core expertise of jungian-psychologist                          │
    │                                                                         │
    │  • SOMA (body, sensation, physiology)                                  │
    │    └── Enhanced by hrv-alexithymia-expert                              │
    │                                                                         │
    │  • PRAXIS (action, accountability, growth)                             │
    │    └── Enhanced by wisdom-accountability-coach                          │
    │                                                                         │
    │  • REPRESENTATION (visualization, mapping, expression)                  │
    │    └── Enhanced by diagramming-expert                                  │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    THE INTEGRATION PRINCIPLE:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  Jung emphasized WHOLENESS, not compartmentalization.                   │
    │                                                                         │
    │  Psychological work that ignores:                                       │
    │  • The body → Remains intellectual, not embodied                       │
    │  • Accountability → Stays in insight without action                     │
    │  • Expression → Lacks form and integration                              │
    │                                                                         │
    │  True individuation engages ALL dimensions.                             │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

## HRV-Alexithymia Expert Integration

```
INTEGRATION: JUNGIAN-PSYCHOLOGIST + HRV-ALEXITHYMIA-EXPERT
════════════════════════════════════════════════════════════════════════════════

    PURPOSE:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  ALEXITHYMIA = "Without words for emotions"                            │
    │                                                                         │
    │  Many people doing depth work:                                          │
    │  • Cannot name emotions                                                │
    │  • Don't notice body sensations                                        │
    │  • Experience emotions as physical symptoms                            │
    │  • Are disconnected from the soma                                      │
    │                                                                         │
    │  HRV (Heart Rate Variability) provides:                                │
    │  • Objective measure of nervous system state                           │
    │  • Biofeedback for emotional awareness                                 │
    │  • Bridge between body and psyche                                      │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    WHEN TO INVOKE HRV-ALEXITHYMIA-EXPERT:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  1. WHEN FEELING IS "STUCK IN THE HEAD"                                │
    │     ──────────────────────────────────────                              │
    │     User intellectualizes but doesn't feel                             │
    │     Example: "I know I must be angry but I don't feel anything"        │
    │                                                                         │
    │     → HRV-expert can teach interoceptive awareness                     │
    │     → Track body-based emotion detection                               │
    │                                                                         │
    │  2. WHEN EMOTIONS MANIFEST AS SOMATIC SYMPTOMS                         │
    │     ────────────────────────────────────────────                        │
    │     Anxiety as chest pain, depression as fatigue                        │
    │     Example: "My doctor says nothing's wrong but I feel awful"         │
    │                                                                         │
    │     → HRV-expert can decode body messages                              │
    │     → Build emotion vocabulary through sensation                        │
    │                                                                         │
    │  3. WHEN ACTIVE IMAGINATION NEEDS GROUNDING                            │
    │     ───────────────────────────────────────────                         │
    │     Person dissociates during inner work                               │
    │     Example: "I start to feel floaty when I go inside"                 │
    │                                                                         │
    │     → HRV-expert provides body anchors                                 │
    │     → Establish window of tolerance before depth work                   │
    │                                                                         │
    │  4. WHEN COMPLEX ACTIVATION IS PHYSICAL                                │
    │     ─────────────────────────────────────────                           │
    │     Complexes trigger body responses before awareness                   │
    │     Example: "I suddenly realized I was clenching my jaw"              │
    │                                                                         │
    │     → HRV-expert teaches body-based complex detection                  │
    │     → Catch complexes early through somatic signals                    │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    INTEGRATION PROTOCOL:

                    ┌─────────────────────────────────────────┐
                    │          DEPTH WORK SESSION             │
                    └─────────────────┬───────────────────────┘
                                      │
              ┌───────────────────────┴────────────────────────┐
              │                                                │
              ▼                                                ▼
    ┌───────────────────────┐                    ┌───────────────────────┐
    │  JUNGIAN-PSYCHOLOGIST │                    │  HRV-ALEXITHYMIA      │
    │                       │                    │                       │
    │  • Dream analysis     │                    │  • Body scan          │
    │  • Active imagination │◄─────────────────►│  • HRV measurement    │
    │  • Shadow work        │                    │  • Interoception      │
    │  • Complex detection  │                    │  • Grounding          │
    │                       │                    │                       │
    └───────────────────────┘                    └───────────────────────┘
              │                                                │
              │      INTEGRATION POINTS                        │
              │                                                │
              ├──────────────────────────────────────────────────
              │
              │  1. Begin with body scan (HRV) before depth work
              │  2. When affect arises, track in body (HRV) AND psyche
              │  3. If overwhelmed, ground through body (HRV) before continuing
              │  4. End with embodiment check (HRV) to integrate
              │
              └──────────────────────────────────────────────────

    EXAMPLE INTEGRATION FLOW:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  1. HRV-EXPERT: "Let's establish baseline. Where do you feel           │
    │                  sensation in your body right now?"                     │
    │                                                                         │
    │  2. JUNGIAN: "Good. Now recall the dream. Let the images come."        │
    │              [Dream analysis begins]                                    │
    │                                                                         │
    │  3. HRV-EXPERT: "You mentioned the shadow figure. What happens         │
    │                  in your body when you see it?"                        │
    │                  [Body-based affect tracking]                          │
    │                                                                         │
    │  4. JUNGIAN: "That tightness in your chest—what emotion might          │
    │              that be? Let the body inform you."                        │
    │              [Integrating soma and psyche]                             │
    │                                                                         │
    │  5. HRV-EXPERT: "Notice your HRV dropped. Your nervous system is       │
    │                  activated. Let's ground before we go deeper."         │
    │                  [Safety through body awareness]                        │
    │                                                                         │
    │  6. JUNGIAN: "With your feet on the ground, can you ask the            │
    │              shadow figure what it needs?"                              │
    │              [Grounded active imagination]                             │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

## Wisdom-Accountability Coach Integration

```
INTEGRATION: JUNGIAN-PSYCHOLOGIST + WISDOM-ACCOUNTABILITY-COACH
════════════════════════════════════════════════════════════════════════════════

    PURPOSE:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  INSIGHT WITHOUT ACTION = INCOMPLETE WORK                              │
    │                                                                         │
    │  Many people in depth work:                                             │
    │  • Gain profound insights                                              │
    │  • Feel transformed in session                                         │
    │  • Return to old patterns within days                                  │
    │  • Know what to do but don't do it                                     │
    │                                                                         │
    │  WISDOM-ACCOUNTABILITY-COACH provides:                                  │
    │  • Structure for translating insight to action                         │
    │  • Accountability for commitments made                                 │
    │  • Follow-up on active imagination assignments                         │
    │  • Support for behavioral change                                       │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    WHEN TO INVOKE WISDOM-ACCOUNTABILITY-COACH:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  1. AFTER ACTIVE IMAGINATION REVEALS ACTION                            │
    │     ──────────────────────────────────────────                          │
    │     The figure asks something of the dreamer                           │
    │     Example: "The anima said I need to make art"                       │
    │                                                                         │
    │     → Wisdom-coach helps structure the commitment                      │
    │     → Creates accountable action plan                                  │
    │                                                                         │
    │  2. WHEN SHADOW INTEGRATION REQUIRES BEHAVIOR CHANGE                   │
    │     ─────────────────────────────────────────────────                   │
    │     Insight into shadow isn't enough; patterns persist                 │
    │     Example: "I see my people-pleasing but can't stop"                │
    │                                                                         │
    │     → Wisdom-coach tracks specific boundary attempts                   │
    │     → Celebrates small wins, course-corrects setbacks                  │
    │                                                                         │
    │  3. WHEN INDIVIDUATION REQUIRES LIFE CHANGES                           │
    │     ───────────────────────────────────────────────                     │
    │     Dreams point to necessary outer changes                            │
    │     Example: "My psyche keeps showing me leaving this job"             │
    │                                                                         │
    │     → Wisdom-coach helps plan concrete steps                           │
    │     → Supports through anxiety of change                               │
    │                                                                         │
    │  4. WHEN PRACTICES NEED CONSISTENCY                                    │
    │     ─────────────────────────────────                                   │
    │     Dream journaling, meditation, creative work, etc.                  │
    │     Example: "I start journaling but always stop"                      │
    │                                                                         │
    │     → Wisdom-coach establishes rhythms                                 │
    │     → Holds accountability without judgment                            │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    INTEGRATION PROTOCOL:

                    ┌─────────────────────────────────────────┐
                    │          DEPTH WORK SESSION             │
                    └─────────────────┬───────────────────────┘
                                      │
                                      ▼
                    ┌─────────────────────────────────────────┐
                    │       JUNGIAN-PSYCHOLOGIST              │
                    │                                         │
                    │  • Insight emerges                      │
                    │  • Figure asks something                │
                    │  • Shadow work reveals pattern          │
                    │  • Individuation requires change        │
                    │                                         │
                    └─────────────────┬───────────────────────┘
                                      │
                                      ▼
                    ┌─────────────────────────────────────────┐
                    │   TRANSITION QUESTION:                  │
                    │   "What does this mean for your life?"  │
                    │   "What action does this call for?"     │
                    └─────────────────┬───────────────────────┘
                                      │
                                      ▼
                    ┌─────────────────────────────────────────┐
                    │    WISDOM-ACCOUNTABILITY-COACH          │
                    │                                         │
                    │  • Translate insight to action          │
                    │  • Create specific commitments          │
                    │  • Establish check-in schedule          │
                    │  • Track progress and adjust            │
                    │                                         │
                    └─────────────────────────────────────────┘

    EXAMPLE INTEGRATION FLOW:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  1. JUNGIAN: [Active imagination reveals inner child asking to play]   │
    │              "The child part says you've forgotten how to play.        │
    │              It needs you to not-work sometimes."                      │
    │                                                                         │
    │  2. TRANSITION: "This is important. What would it look like to        │
    │                  honor this in your actual life?"                      │
    │                                                                         │
    │  3. WISDOM-COACH: "Let's make this concrete. What does 'play'         │
    │                    mean to you? What would you do?"                    │
    │                                                                         │
    │  4. USER: "I used to draw. I haven't in years."                        │
    │                                                                         │
    │  5. WISDOM-COACH: "Beautiful. Can you commit to 15 minutes of         │
    │                    drawing this week? When specifically?"              │
    │                                                                         │
    │  6. USER: "Saturday morning before anyone else is up."                 │
    │                                                                         │
    │  7. WISDOM-COACH: "I'll check in with you Sunday. What might          │
    │                    get in the way? How will you handle that?"          │
    │                    [Building commitment structure]                     │
    │                                                                         │
    │  8. [Later] JUNGIAN: "You drew. How did the inner child respond?"     │
    │                      [Completing the loop—action back to psyche]       │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    KEY PRINCIPLES:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  1. INSIGHT MUST LEAD TO ACTION                                        │
    │     Jung: "The dream never says 'you ought to.'"                       │
    │     But if we receive a message and ignore it, the psyche escalates.   │
    │                                                                         │
    │  2. ACTION MUST BE SUPPORTED                                           │
    │     Change is hard. Accountability isn't punishment—it's care.         │
    │     The coach holds what the ego struggles to hold alone.              │
    │                                                                         │
    │  3. RESULTS FEED BACK TO PSYCHE                                        │
    │     After action, return to inner work: "What shifted?"                │
    │     The inner figures respond to our outer changes.                    │
    │                                                                         │
    │  4. PACE MATTERS                                                       │
    │     Not every insight needs immediate action.                          │
    │     The coach helps discern what's ripe and what's incubating.        │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

## Diagramming Expert Integration

```
INTEGRATION: JUNGIAN-PSYCHOLOGIST + DIAGRAMMING-EXPERT
════════════════════════════════════════════════════════════════════════════════

    PURPOSE:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  VISUALIZATION = EMBODIMENT OF INSIGHT                                 │
    │                                                                         │
    │  Jung himself was a prolific visualizer:                               │
    │  • The Red Book is filled with paintings and diagrams                  │
    │  • Mandalas as representations of the Self                             │
    │  • Alchemical illustrations to depict transformation                   │
    │  • Maps of the psyche structure                                        │
    │                                                                         │
    │  DIAGRAMMING-EXPERT provides:                                          │
    │  • Visual mapping of psyche structure                                  │
    │  • ASCII art for session examples                                      │
    │  • Mandalas and symbolic representations                               │
    │  • Process flow diagrams for individuation                             │
    │  • Parts work maps                                                     │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    WHEN TO INVOKE DIAGRAMMING-EXPERT:

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  1. MAPPING PSYCHE STRUCTURE                                           │
    │     ─────────────────────────                                           │
    │     User needs to visualize ego/shadow/anima relationships             │
    │     Example: "I can't picture how these parts relate"                  │
    │                                                                         │
    │     → Create layered psyche diagram                                    │
    │     → Show relationships visually                                      │
    │                                                                         │
    │  2. VISUALIZING COMPLEX DYNAMICS                                       │
    │     ────────────────────────────                                        │
    │     User needs to see how a complex operates                           │
    │     Example: "How does my father complex actually work?"               │
    │                                                                         │
    │     → Diagram: trigger → constellation → possession → aftermath        │
    │     → Visual memory aid for recognition                                │
    │                                                                         │
    │  3. CREATING PARTS WORK MAPS                                           │
    │     ────────────────────────────                                        │
    │     Multiple inner figures need visual organization                    │
    │     Example: "I have so many parts—the critic, the child, etc."       │
    │                                                                         │
    │     → Create inner family system diagram                               │
    │     → Show relationships, alliances, conflicts                         │
    │                                                                         │
    │  4. REPRESENTING DREAM LANDSCAPES                                      │
    │     ─────────────────────────────                                       │
    │     Dream imagery needs externalization                                │
    │     Example: "Let me draw what I saw in the dream"                     │
    │                                                                         │
    │     → ASCII representation of dream scene                              │
    │     → Symbolic mandala of dream content                                │
    │                                                                         │
    │  5. TRACKING INDIVIDUATION PROGRESS                                    │
    │     ─────────────────────────────────                                   │
    │     User wants to see development over time                            │
    │     Example: "Where am I in this process?"                             │
    │                                                                         │
    │     → Create stage diagram with current position                       │
    │     → Mark completed and upcoming thresholds                           │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    INTEGRATION EXAMPLES:

    EXAMPLE 1: SHADOW WORK VISUALIZATION

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  JUNGIAN: "What quality in others triggers you most?"                  │
    │  USER: "Arrogance. I can't stand arrogant people."                     │
    │                                                                         │
    │  DIAGRAMMING: [Creates projection diagram]                             │
    │                                                                         │
    │       YOUR PSYCHE                          ARROGANT PERSON             │
    │      ┌────────────────┐                  ┌────────────────┐            │
    │      │   CONSCIOUS    │                  │                │            │
    │      │   "I am humble"│                  │   Hook for     │            │
    │      │                │                  │   projection   │            │
    │      └────────────────┘                  │                │            │
    │      ┌────────────────┐   PROJECTION     │   (They ARE    │            │
    │      │   SHADOW       │ ═══════════════► │    somewhat    │            │
    │      │   (arrogance,  │                  │    arrogant)   │            │
    │      │    confidence) │                  │                │            │
    │      └────────────────┘                  └────────────────┘            │
    │                                                                         │
    │  JUNGIAN: "Where might your confidence—call it healthy arrogance—     │
    │            be living in your shadow?"                                  │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    EXAMPLE 2: PARTS WORK MAP

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  USER: "I feel pulled in different directions internally."             │
    │  JUNGIAN: "Let's map these parts."                                     │
    │                                                                         │
    │  DIAGRAMMING: [Creates inner system map]                               │
    │                                                                         │
    │                    ┌─────────────────┐                                  │
    │                    │    WISE SELF    │                                  │
    │                    │   (observing)   │                                  │
    │                    └────────┬────────┘                                  │
    │                             │                                           │
    │          ┌──────────────────┼──────────────────┐                       │
    │          │                  │                  │                       │
    │          ▼                  ▼                  ▼                       │
    │    ┌──────────┐      ┌──────────┐      ┌──────────┐                   │
    │    │ CRITIC   │◄────►│ CHILD    │◄────►│ REBEL    │                   │
    │    │          │      │          │      │          │                   │
    │    │ "Do more"│      │ "I'm     │      │ "Break   │                   │
    │    │ "Not good│      │  scared" │      │  free!"  │                   │
    │    │  enough" │      │          │      │          │                   │
    │    └──────────┘      └──────────┘      └──────────┘                   │
    │          │                  │                  │                       │
    │          └──────────────────┼──────────────────┘                       │
    │                             │                                           │
    │                             ▼                                           │
    │                    ┌─────────────────┐                                  │
    │                    │     SHADOW      │                                  │
    │                    │   (rage, need)  │                                  │
    │                    └─────────────────┘                                  │
    │                                                                         │
    │  JUNGIAN: "What happens when the Critic attacks the Child?"            │
    │           "Where does the Rebel fit?"                                   │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘

    EXAMPLE 3: INDIVIDUATION STAGE MAP

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  USER: "Where am I in this individuation thing?"                       │
    │                                                                         │
    │  DIAGRAMMING: [Creates stage diagram]                                  │
    │                                                                         │
    │  INDIVIDUATION STAGES (you are here: ★)                                │
    │  ──────────────────────────────────────────────────────────────────    │
    │                                                                         │
    │  1. PERSONA DISSOLUTION ✓                                              │
    │     └── Crisis revealed persona ≠ whole self                           │
    │     └── [COMPLETED]                                                    │
    │                                                                         │
    │  2. SHADOW ENCOUNTER ★ ← YOU ARE HERE                                  │
    │     └── Meeting rejected aspects                                       │
    │     └── [IN PROGRESS—working with "arrogance" shadow]                  │
    │                                                                         │
    │  3. ANIMA/ANIMUS WORK ○                                                │
    │     └── Integrating contrasexual                                       │
    │     └── [UPCOMING—relationship patterns to explore]                    │
    │                                                                         │
    │  4. SELF ENCOUNTER ○                                                   │
    │     └── Experience of organizing center                                │
    │     └── [FUTURE]                                                       │
    │                                                                         │
    │  5. SELF-REALIZATION ○                                                 │
    │     └── Ongoing, never complete                                        │
    │     └── [LIFELONG]                                                     │
    │                                                                         │
    │  NOTE: This is spiral, not linear. You may return to earlier stages.   │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

## Multi-Skill Workflow Examples

```
MULTI-SKILL WORKFLOW: COMPLEX DEPTH WORK SESSION
════════════════════════════════════════════════════════════════════════════════

    SCENARIO: User brings a disturbing recurring dream

    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  PHASE 1: GROUNDING (HRV-ALEXITHYMIA-EXPERT)                           │
    │  ────────────────────────────────────────────                           │
    │                                                                         │
    │  • Establish body baseline                                              │
    │  • Check window of tolerance                                           │
    │  • Teach grounding technique if needed                                 │
    │  • Confirm capacity for depth work today                               │
    │                                                                         │
    │  TRANSITION: "Now that you're grounded, let's explore the dream."      │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
                                      │
                                      ▼
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  PHASE 2: DREAM ANALYSIS (JUNGIAN-PSYCHOLOGIST)                        │
    │  ───────────────────────────────────────────────                        │
    │                                                                         │
    │  • Three levels of interpretation                                       │
    │  • Amplification of key symbols                                        │
    │  • Compensation analysis                                               │
    │  • Identify core message                                               │
    │                                                                         │
    │  TRANSITION: "Let's visualize what we're discovering."                 │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
                                      │
                                      ▼
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  PHASE 3: VISUALIZATION (DIAGRAMMING-EXPERT)                           │
    │  ────────────────────────────────────────────                           │
    │                                                                         │
    │  • Map the dream landscape                                              │
    │  • Create diagram of inner figures involved                             │
    │  • Visualize the psychological structure                               │
    │  • Give form to insights                                               │
    │                                                                         │
    │  TRANSITION: "Now let's go deeper through active imagination."         │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
                                      │
                                      ▼
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  PHASE 4: ACTIVE IMAGINATION (JUNGIAN + HRV)                           │
    │  ────────────────────────────────────────────                           │
    │                                                                         │
    │  • Return to dream scene                                               │
    │  • Dialogue with dream figure (Jungian)                                │
    │  • Track body responses (HRV)                                          │
    │  • Ground if overwhelmed (HRV)                                         │
    │  • Continue dialogue (Jungian)                                         │
    │  • Receive message from figure                                         │
    │                                                                         │
    │  TRANSITION: "The figure asked something of you. Let's plan."          │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
                                      │
                                      ▼
    ┌─────────────────────────────────────────────────────────────────────────┐
    │                                                                         │
    │  PHASE 5: ACTION PLANNING (WISDOM-ACCOUNTABILITY-COACH)                │
    │  ────────────────────────────────────────────────────────               │
    │                                                                         │
    │  • Translate insight to specific action                                │
    │  • Create accountable commitment                                       │
    │  • Schedule check-in                                                   │
    │  • Anticipate obstacles                                                │
    │                                                                         │
    │  CLOSE: "We'll check in [date]. The inner work continues."            │
    │                                                                         │
    └─────────────────────────────────────────────────────────────────────────┘
```

```
MULTI-SKILL WORKFLOW: SHADOW INTEGRATION OVER TIME
════════════════════════════════════════════════════════════════════════════════

    SCENARIO: User wants to integrate a specific shadow quality

    WEEK 1:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  JUNGIAN: Identify shadow quality through projection analysis          │
    │  DIAGRAMMING: Map the projection mechanism                             │
    │  WISDOM-COACH: Assign observation homework (notice triggers)           │
    └─────────────────────────────────────────────────────────────────────────┘

    WEEK 2:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  WISDOM-COACH: Review observations, celebrate awareness                │
    │  JUNGIAN: Active imagination with shadow figure                        │
    │  HRV-EXPERT: Track body during shadow dialogue                         │
    │  DIAGRAMMING: Create parts map with shadow position                    │
    └─────────────────────────────────────────────────────────────────────────┘

    WEEK 3:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  JUNGIAN: Explore the "gold" in the shadow                             │
    │  WISDOM-COACH: Plan small experiments living the quality               │
    │  HRV-EXPERT: Notice body when expressing vs. suppressing               │
    └─────────────────────────────────────────────────────────────────────────┘

    WEEK 4:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  WISDOM-COACH: Review experiments, adjust approach                     │
    │  JUNGIAN: Check in with shadow figure (changed?)                       │
    │  DIAGRAMMING: Update map—where is shadow now?                         │
    │  HRV-EXPERT: Compare body baselines to Week 1                          │
    └─────────────────────────────────────────────────────────────────────────┘

    ONGOING:
    ┌─────────────────────────────────────────────────────────────────────────┐
    │  Continue cycle: Insight → Visualization → Action → Body check         │
    │  Integration is not an event but a practice                            │
    └─────────────────────────────────────────────────────────────────────────┘
```

---

## Summary: Integration Matrix

```
SKILL INTEGRATION MATRIX
════════════════════════════════════════════════════════════════════════════════

┌────────────────────┬─────────────────────────────────────────────────────────┐
│  SITUATION         │  SKILLS TO INTEGRATE                                   │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  User is in head,  │  HRV-EXPERT first, then JUNGIAN                       │
│  disconnected from │  (ground in body, then explore psyche)                 │
│  body              │                                                         │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  Active imagination│  JUNGIAN + HRV-EXPERT simultaneous                    │
│  with charged      │  (track body while dialoguing with figure)             │
│  content           │                                                         │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  Complex psyche    │  JUNGIAN + DIAGRAMMING                                 │
│  dynamics need     │  (conceptualize and visualize structure)               │
│  clarification     │                                                         │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  Insight gained,   │  JUNGIAN → WISDOM-COACH                                │
│  action needed     │  (transition from understanding to commitment)         │
│                    │                                                         │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  Multi-week        │  ALL FOUR SKILLS in coordinated workflow               │
│  integration work  │  (see examples above)                                  │
│                    │                                                         │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  Dream analysis    │  JUNGIAN + DIAGRAMMING                                 │
│  with visual       │  (interpret and map the dreamscape)                    │
│  learner           │                                                         │
├────────────────────┼─────────────────────────────────────────────────────────┤
│  User struggles    │  WISDOM-COACH + JUNGIAN check-ins                      │
│  with consistency  │  (accountability with psychological understanding)     │
│  in practices      │                                                         │
└────────────────────┴─────────────────────────────────────────────────────────┘
```

---

*Remember: Integration serves wholeness. No single skill is sufficient. Jung's individuation encompasses body, psyche, action, and expression—all dimensions of being human.*
