# JTBD Examples - Artem's World

## Example 1: TeddySnaps

### User: Working Parent

**JOB STATEMENT:**
"When I'm at work and feeling disconnected from my toddler, I want to see visual proof they're happy and cared for, so I can focus on work without guilt"

📋 **FUNCTIONAL JOB:**
See photos of my specific child during their day

💜 **EMOTIONAL JOB:**
Feel like a good parent even though I'm physically absent
Release the low-grade anxiety of "are they okay?"
Feel connected despite distance

👥 **SOCIAL JOB:**
Have something to share with partner/grandparents
Prove to myself I made the right childcare choice
Have stories to ask about at pickup

**CURRENT ALTERNATIVES:**
- Text the daycare (disruptive, feels needy)
- Wait until pickup (builds anxiety all day)
- Check random Instagram posts (not MY child)
- Just trust and worry (current default)

**UNDERSERVED ASPECTS:**
- Real-time or near-real-time photos
- MY child specifically, not group shots
- Context (what activity, who they're with)

**FEATURE IMPLICATIONS:**
→ Face recognition is CRITICAL (not group shots)
→ Push notifications satisfy the "proof" need
→ Multiple daily photos beat one batch at end
→ Easy sharing to family extends social job

---

## Example 2: TISA International School

### User: Expat Parent in Netherlands

**JOB STATEMENT:**
"When we've relocated internationally and I'm worried about my child's education continuity, I want a school that combines global standards with local opportunity, so I can feel my child isn't falling behind AND is thriving"

📋 **FUNCTIONAL JOB:**
Provide quality education matching international standards
Teach both English and local language
Develop practical skills, not just academics

💜 **EMOTIONAL JOB:**
Feel I'm giving my child an advantage, not a compromise
Feel confident they'll adapt to any future country
Feel proud of choosing something innovative

👥 **SOCIAL JOB:**
Be seen as a parent who "gets" education
Have a school I'm proud to name
Feel part of a community of like-minded families

**CURRENT ALTERNATIVES:**
- Traditional international school (expensive, academic-only)
- Dutch public school (language barrier, different pedagogy)
- Homeschooling (huge parent time commitment)
- Move back to home country (nuclear option)

**UNDERSERVED ASPECTS:**
- Entrepreneurship + academics combination
- Bilingual from day one (not add-on)
- Practical skills (not just test prep)
- Community of international families

**FEATURE IMPLICATIONS:**
→ Entrepreneurship pillar is differentiator
→ Bilingual structure (not "English school with Dutch class")
→ Parent community building is part of the product
→ Small class sizes enable personalization

---

## Example 3: GolfTab

### User: Golfer (mid-round)

**JOB STATEMENT:**
"When I'm on hole 7 and getting hungry, I want to order food that arrives at the right moment without interrupting my round, so I can keep enjoying golf without hangry frustration"

📋 **FUNCTIONAL JOB:**
Order food that meets me at the right hole
Know when it's arriving
Pay without hassle

💜 **EMOTIONAL JOB:**
Feel like the course "gets" me
Feel smart for using efficient solution
Avoid the frustration of bad timing

👥 **SOCIAL JOB:**
Look organized to playing partners
Not be the one who "forgot to order"
Maybe be the hero who orders for the group

**CURRENT ALTERNATIVES:**
- Flag down beverage cart (unreliable timing)
- Wait until turn (hangry by hole 9)
- Bring snacks in bag (not hot food)
- Skip eating (suffer)

**UNDERSERVED ASPECTS:**
- Timing precision (not "in 20 minutes" but "at hole 10")
- Simplified ordering (don't need full menu mid-swing)
- Group ordering capability

**FEATURE IMPLICATIONS:**
→ Hole-based delivery is core UX, not address
→ Simplified menu (not full restaurant)
→ 5-tap maximum ordering flow
→ Group ordering for foursomes

---

## Example 4: TeddyKids (Daycare)

### User: First-Time Parent

**JOB STATEMENT:**
"When I'm returning to work after parental leave, I want to trust that strangers will care for my baby as well as I would, so I can work without constant fear"

📋 **FUNCTIONAL JOB:**
Safe, quality care during work hours
Developmental activities appropriate for age
Reliable schedule and pickup flexibility

💜 **EMOTIONAL JOB:**
Feel my baby is loved, not just "watched"
Feel I'm not abandoning them
Feel confident in the caregivers

👥 **SOCIAL JOB:**
Tell others I found a "great" daycare
Not feel judged for going back to work
Be part of a parent community

**CURRENT ALTERNATIVES:**
- Grandparents (not always available/capable)
- Nanny (expensive, single point of failure)
- Au pair (language/cultural challenges)
- Delay return to work (career impact)

**JOB PRIORITY:** CRITICAL - this is peak anxiety moment

**UNDERSERVED ASPECTS:**
- Trust building (transparency into the day)
- Communication quality (not just "fine")
- Transition support (first week is hardest)

**FEATURE IMPLICATIONS:**
→ TeddySnaps directly serves emotional job
→ Onboarding experience is product, not admin
→ Staff quality + communication = core value prop
→ Parent community building reduces isolation

---

## Quick JTBD Template

```
PRODUCT: [What you're analyzing]
USER: [Specific user type]

JOB STATEMENT:
"When [situation], I want to [motivation], so I can [outcome]"

📋 FUNCTIONAL JOB:
[What task?]

💜 EMOTIONAL JOB:
[How feel?]

👥 SOCIAL JOB:
[How perceived?]

CURRENT ALTERNATIVES:
• [Option 1]
• [Option 2]

UNDERSERVED ASPECTS:
• [Gap 1]
• [Gap 2]

FEATURE IMPLICATIONS:
→ [What this means for design]
```
