---
name: journal-to-post
description: Convert personal journal entries into shareable social media posts
version: 1.0.0
author: theflohart
tags: [content, writing, social-media, journaling]
---

# Journal to Post

Convert personal reflections, journal entries, or voice notes into shareable social media posts.

## Usage

```
/journal-to-post [journal text or file path]
```

## How It Works

1. **Input:** Provide journal text directly or a file path
2. **Process:** Extract universal insights from personal experience
3. **Output:** 1-3 polished posts ready to share

## Voice Guidelines

### Do

- Direct, confident, no hedging
- First person when sharing experience
- Punchy hooks that challenge assumptions
- Specific details that add credibility (numbers, timeframes)

### Don't

- Include too personal/private details
- Write vague platitudes
- Use "I learned that..." framing (show, don't tell)
- Sound like typical self-help content

## What Gets Extracted

- Universal insights from personal experience
- Counterintuitive observations
- Patterns you've noticed
- Specific data points that anchor the insight

## Transformation Examples

### Example 1

**Journal:**
> "Noticed my energy dropped after that difficult meeting. Took 3 hours of walking before I felt normal again."

**Post:**
> "Your body keeps score of difficult conversations. My energy tanked after one meeting yesterday. Took 3 hours of walking to recover. Most people ignore this and wonder why they're exhausted by Friday."

---

### Example 2

**Journal:**
> "Had a breakthrough in meditation today - realized I've been trying to 'achieve' stillness instead of just noticing what's already there."

**Post:**
> "The meditation trap: trying to achieve stillness. The shift: noticing stillness is already there, underneath the noise. Took me 2 years to stop efforting."

---

### Example 3

**Journal:**
> "Spent 4 hours debugging something that turned out to be a typo. Frustrated but also funny in hindsight."

**Post:**
> "4 hours debugging. The fix? A typo. One character. This is the job. The gap between 'stuck' and 'solved' is often embarrassingly small."

## Output

For each generated post:

1. **Show the post** - Ready to copy/paste
2. **Explain the transformation** - What was extracted, what was removed
3. **Offer variations** - Different angles or platforms (X vs LinkedIn)

## Tips for Better Results

- Include specific numbers and timeframes in your journal
- Note your emotional state, not just events
- Capture the "aha moment" or shift in thinking
- Don't self-censor in the journal - the skill will filter for you
