# JobHunter Master

**The aggressive job hunting skill that goes beyond "Easy Apply".**

Most job seekers spray and pray. This skill hunts.

## Philosophy

Easy Apply = lottery ticket. Real job hunting = sales process.

The funnel:
1. **Research** — Know the company better than their employees
2. **Qualify** — Match your experience to their pain points  
3. **Customize** — Tailor CV & cover letter for THIS job
4. **Find the humans** — HR, hiring manager, team lead, insider
5. **Engage** — Comment, connect, message, email
6. **Follow up** — Persistence without being annoying

## Workflow

### Phase 1: Target Acquisition

```bash
# Find jobs worth pursuing (not just Easy Apply)
# Sources: LinkedIn, company career pages, AngelList, RemoteOK, HN Who's Hiring
```

**Research checklist:**
- [ ] Company size, funding stage, recent news
- [ ] Tech stack (check job post, GitHub, StackShare, blog posts)
- [ ] Company culture (Glassdoor, Blind, LinkedIn posts)
- [ ] Recent hires in similar roles (LinkedIn)
- [ ] Pain points (what are they building? what challenges?)

### Phase 2: Intelligence Gathering

**Find the people:**
1. **Hiring Manager** — Usually mentioned in job post or find via LinkedIn
2. **HR/Recruiter** — Search "[Company] Recruiter" on LinkedIn
3. **Team members** — People with similar titles at the company
4. **Connections** — Any mutual connections? Alumni?

**Find contact info:**
- LinkedIn direct message
- Email patterns: firstname@company.com, f.lastname@company.com
- Tools: Hunter.io, Apollo.io, RocketReach
- Twitter/X presence
- Company blog authors

### Phase 3: Customize Materials

**CV Adjustments:**
- Lead with relevant experience for THIS role
- Mirror their language (use keywords from job post)
- Quantify achievements that match their needs
- Remove irrelevant fluff

**Cover Letter Formula:**
```
Para 1: Why THIS company (show you researched)
Para 2: Why YOU (specific experience matching their needs)
Para 3: What you'll DO (concrete value you'll add)
Para 4: Call to action (meeting request)
```

### Phase 4: Multi-Channel Approach

**LinkedIn:**
1. Connect with HR/hiring manager (personalized note)
2. Comment thoughtfully on their posts
3. Share relevant content they might see
4. InMail if premium available

**Email:**
```
Subject: [Role] Application - [Your Name] | [Unique Value Prop]

Short, punchy, shows you did homework.
Attach CV. Link to portfolio/GitHub.
Clear ask: "Would love 15 minutes to discuss."
```

**Twitter/X:**
- Follow company + key people
- Engage with their content genuinely
- DM if appropriate (after warming up)

### Phase 5: Follow-Up Cadence

```
Day 0: Apply + Connect on LinkedIn
Day 3: Follow-up email if no response
Day 7: LinkedIn message or comment on their content
Day 14: Final follow-up with new angle
```

**Never:**
- Send the same message twice
- Be desperate or needy in tone
- Spam multiple people at same company simultaneously

## Templates

### LinkedIn Connection Request
```
Hi [Name], I just applied for the [Role] position and wanted to connect directly. 
Your work on [specific thing] caught my attention. Would love to learn more about [Company]'s engineering culture.
```

### Cold Email
```
Subject: Quick question about [Role] at [Company]

Hi [Name],

I noticed [Company] is hiring for [Role] and I'm genuinely excited about [specific thing about company - product, mission, tech].

Quick background: I've spent [X years] doing [relevant experience], most recently [specific achievement that matches their needs].

I'd love to learn more about what you're looking for in this role. Do you have 15 minutes this week for a quick call?

Best,
[Name]
[LinkedIn] | [Portfolio/GitHub]
```

### Follow-Up
```
Subject: Re: [Previous Subject]

Hi [Name],

Following up on my application for [Role]. 

Since I last reached out, I [did something relevant - built something, wrote about topic, etc.].

Still very interested in [Company]. Happy to chat whenever convenient.

Best,
[Name]
```

## Execution Commands

### Research Company
```bash
# Web search for company intel
web_search "[Company] engineering blog"
web_search "[Company] tech stack"
web_search "[Company] series [A/B/C] funding"
web_search "site:glassdoor.com [Company] reviews"
```

### Find People
```bash
# LinkedIn search via browser
# Search: "[Company] recruiter" or "[Company] engineering manager"
# Check mutual connections
```

### Email Discovery
```bash
# Common patterns to try:
# firstname@company.com
# firstname.lastname@company.com
# f.lastname@company.com
# firstnamelastname@company.com
```

## Integration with Other Skills

- **browser**: LinkedIn automation, company research
- **bird**: Twitter engagement with company/employees
- **gog**: Email outreach via Gmail
- **nano-pdf**: CV editing and customization

## Success Metrics

Track per application:
- [ ] Company researched
- [ ] CV customized
- [ ] Cover letter written
- [ ] HR/Hiring manager identified
- [ ] Connection request sent
- [ ] Follow-up scheduled

## Files

Store job hunt data in:
- `memory/job-targets.md` — Active targets and status
- `memory/job-templates/` — Customized CVs and cover letters

---

*"The job doesn't go to the best candidate. It goes to the best job hunter."*
