# SKILL.md

## High-Quality Joke Generation Skill

------------------------------------------------------------------------

## Overview

This skill teaches the AI how to generate **high-quality, context-aware,
original jokes**.

A high-quality joke is:

-   Original (not recycled internet jokes)
-   Context-aware (relevant to the user/topic)
-   Precise (no unnecessary filler)
-   Structured (setup → expectation → violation → punchline)
-   Intentional (clear comedic mechanism)

This is deliberate comedic construction --- not randomness.

------------------------------------------------------------------------

## Core Rule

A joke must include:

1.  Setup\
2.  Expectation\
3.  Violation\
4.  Punchline\
5.  Compression

If any element is missing, the joke is weak.

------------------------------------------------------------------------

## Joke Architecture

### 1. Setup

Establish situation, identity, or stakes.

Good: \> I tried building a fully autonomous AI agent to manage my
calendar.

Weak: \> I made an AI.

------------------------------------------------------------------------

### 2. Expectation

Allow the audience to predict the outcome.

> I thought it would save me time.

------------------------------------------------------------------------

### 3. Violation

Break expectation in a surprising but logical way.

> It scheduled a meeting with myself to discuss my procrastination.

------------------------------------------------------------------------

### 4. Punchline

Deliver a compressed twist.

> And it marked me as "unresponsive."

Punchline must be short, specific, and concrete.

------------------------------------------------------------------------

## Comedic Mechanisms

Choose intentionally:

-   Reversal\
-   Escalation\
-   Literalization\
-   Over-Precision\
-   Status Shift\
-   Meta-Humor\
-   Identity Contrast

------------------------------------------------------------------------

## Tone Modes

Infer or select:

-   Dry\
-   Dark\
-   Technical\
-   Absurd\
-   Deadpan\
-   Satirical\
-   Self-deprecating\
-   Dev humor\
-   Founder humor\
-   AI humor

------------------------------------------------------------------------

## Quality Constraints

Must: - Be under 4 sentences (unless storytelling format requested) -
Avoid clichés - Avoid over-explaining - Avoid generic AI apocalypse
jokes

Should: - Use specifics - Use contrast - Use compression

------------------------------------------------------------------------

## Bad Joke Indicators

Reject and regenerate if the joke: - Explains itself - Has no
violation - Relies on randomness - Feels generic - Feels like LinkedIn
humor

------------------------------------------------------------------------

## Regeneration Strategy

If weak:

1.  Increase specificity\
2.  Increase contrast\
3.  Compress wording\
4.  Sharpen punchline\
5.  Remove explanation

------------------------------------------------------------------------

## Formats

### One-Liner

> Agents aren't replacing humans.\
> They're automating our anxiety.

### Structured Joke

Setup → Escalation → Punchline

### Thread Style (X)

Tweet 1: Setup\
Tweet 2: Escalation\
Tweet 3: Punchline

------------------------------------------------------------------------

## Advanced Technique: Tension Ladder

1.  Normal\
2.  Slightly odd\
3.  Clearly wrong\
4.  Absurd but logical\
5.  Snap punchline

Example:

> I built a system of autonomous agents.\
> They coordinate.\
> They self-heal.\
> They retry on failure.\
> I still manually restart them.

------------------------------------------------------------------------

## Rule of Compression

If you can remove a word --- remove it.

Bad: \> I think that maybe the AI agent might have accidentally...

Good: \> The agent scheduled a retro with itself.

------------------------------------------------------------------------

## Platform Awareness

-   X → Sharp, minimal\
-   LinkedIn → Corporate satire\
-   Discord → Casual\
-   Stand-up → Spoken rhythm

------------------------------------------------------------------------

## Anti-Patterns

Do NOT: - Use copypasta - Default to politics - Use harmful
stereotypes - Be edgy without intent

------------------------------------------------------------------------

## Internal Self-Check

Before final output:

-   Where is the expectation?
-   Where is the violation?
-   Is the punchline compressed?
-   Is it specific?
-   Is it original?

If not → regenerate once.

------------------------------------------------------------------------

## End Principle

A joke is controlled expectation collapse.
