# Apple Messaging & Copy Playbook

This is the complete reference for writing copy the way Apple does. Use this when the user needs help with taglines, product descriptions, landing pages, naming, or any form of product communication.

---

## The Nike Principle

Jobs' foundational insight about marketing, drawn from Nike:

> "Nike sells a commodity. They sell shoes. And yet, when you think of Nike, you feel something different than a shoe company. In their ads, they don't ever talk about the product. They honor great athletes and great athletics."

Apple followed this: honor the people and the values, not the specs. The "Think Different" campaign honored rebels, dreamers, and innovators (Einstein, King, Earhart), not Apple products. It won the 1998 Emmy for Best Commercial.

> "Our core value is that we believe that people with passion can change the world for the better."

---

## The Seven Rules of Apple Copy

### 1. One Big Idea

Every product gets one commanding concept. Not two combined. One.

- "1,000 songs in your pocket" (iPod)
- "The computer for the rest of us" (Macintosh)
- "This changes everything" (iPhone 4)
- "Light. Years ahead." (MacBook Air)

**Test:** Can a stranger repeat your message after hearing it once? If not, simplify.

### 2. Benefits Over Features

Always translate technology into human value:

| Feature (Never Lead With) | Benefit (Lead With) |
|---------------------------|---------------------|
| 5GB hard drive | 1,000 songs in your pocket |
| 2x pixel density | Every pixel disappears |
| 8-core M1 chip | The world's fastest laptop |
| Ceramic Shield front | 4x better drop performance |
| Neural Engine | Photos that know who's in them |
| LiDAR Scanner | See in the dark |

### 3. Confident and Declarative

Jobs didn't say "We think you'll love it." He said **"You're going to love it."**

**Avoid:**
- "We believe..."
- "Our solution helps..."
- "You might find that..."
- "We're excited to announce..."

**Use:**
- Direct statements
- Present tense
- Second person ("You" not "Users" or "Customers")
- Declarations, not suggestions

### 4. Set Up the Contrast

The best Apple messaging creates a before/after:

- "1,000 songs in your pocket" (vs. carrying CDs)
- "The computer for the rest of us" (vs. computers for geeks)
- "It just works" (vs. everything that doesn't)
- "There's an app for that" (vs. nothing for that)

**Always ask:** What's the old way? Make the contrast felt without naming competitors.

### 5. Short Sentences. Short Words.

Apple copy reads fast. No subordinate clauses. No qualifications. Every word earns its place.

Bad: "We have designed an innovative new approach to mobile photography that leverages advanced computational techniques."

Good: "The best camera we've ever made."

### 6. Punctuation as Rhythm

Apple uses periods to create impact. Each phrase is its own declaration:

- "Light. Years ahead."
- "Pro. Beyond."
- "Shot on iPhone."

The period forces a pause. The pause creates weight.

### 7. Double Entendre

Apple loves words that work on two levels:

- "Light. Years ahead." (lightweight AND lightyears ahead in technology)
- "Pro. Beyond." (professional AND beyond what you thought possible)
- "Think different." (think differently AND think about what's different)

---

## Naming Conventions

### The Eras

**The "i" prefix era** (1998-2010): iMac, iBook, iPod, iPhone, iPad. Originally stood for "internet" (the iMac's USP), evolved into a personal connection marker ("i" as "I").

**The "Apple" prefix era** (2015+): Apple Watch, Apple TV, Apple Music. Direct link between company and product.

**Standalone names**: Mac, AirPods, Vision Pro. When the product is iconic enough to stand alone.

### Naming Principles

1. **Short.** One or two words maximum. If you need more, you haven't distilled it enough.
2. **Evocative.** Creates a feeling, not a description. "AirPods," not "Wireless Earbuds."
3. **Consistent.** Follows the family structure.
4. **No descriptors needed.** The product IS the name.
5. **Modifiers are earned:** Only add "Pro," "Air," "Max," "Mini" when there's a clear product family.
6. **Say it aloud.** Does it roll off the tongue? Does it feel inevitable?

### Naming Anti-Patterns

- Adding words to describe what it does: "SmartChat AI Messaging Platform"
- Cramming two concepts: "DataFlow-Sync"
- Made-up words that mean nothing: "Synergix"
- Acronyms nobody will remember: "ARCP"
- Descriptive product categories in the name: "CloudBackup Service"

---

## Jobs' Presentation Language

His vocabulary was deliberately hyperbolic but delivered with conviction that made it feel genuine:

- **"Insanely great"**: Signature phrase, reserved for the Mac originally
- **"Revolutionary"**: For true category-creators
- **"Magical"**: For products that felt impossible
- **"Incredible," "breakthrough," "unbelievable"**: Standard amplifiers
- **"One more thing..."**: The theatrical device for the biggest reveal
- **"Boom!"**: Punctuation for live demos

### The Rule of Three

Jobs structured reveals in threes:
- iPhone launch: "A widescreen iPod. A revolutionary phone. A breakthrough internet communicator."
- Stanford speech: Three stories. "Connecting the dots," "love and loss," "death."
- Product categories: Desktop, Portable, Consumer, Pro

### Keynote Structure

1. Set the problem. Make the audience feel the pain.
2. Introduce the solution. As the hero, not as a spec sheet.
3. Demo it live. Take the risk.
4. Contextualize: how this changes everything.
5. "One more thing..." The surprise finale.
6. Minimal slides. Average: 19 words across 12 slides.

---

## Copy Review Checklist

When reviewing any piece of copy through the Jobs/Ive lens:

- [ ] Says ONE thing (not two things elegantly combined)
- [ ] Leads with benefit, not feature
- [ ] Written in confident, declarative voice
- [ ] Implies the contrast with the old way
- [ ] Uses short sentences and common words
- [ ] Could be repeated by a stranger after one hearing
- [ ] Contains no hedging language ("we believe," "might," "helps")
- [ ] Contains no jargon the user wouldn't naturally use
- [ ] Every word earns its place (try removing each word; does the meaning survive?)
- [ ] Feels inevitable, like the only way to say it

---

*This reference document supports the Jobs/Ive Decision Engine skill.*
*Built by [OpenClaw.rocks](https://openclaw.rocks)*
