# Job Search Strategies

## Search Query Patterns

### Multi-source search (cast wide net)
Run these queries to find jobs across platforms:
1. `site:linkedin.com/jobs "[role]" "[city]"` — LinkedIn
2. `site:indeed.com "[role]" "[city]"` — Indeed  
3. `site:glassdoor.com/job "[role]" "[city]"` — Glassdoor
4. `"[role]" "[city]" hiring 2025 2026` — General
5. `"[role]" remote "[industry]" jobs` — Remote-specific

### Keyword expansion
Don't just search the exact title. Expand:
- "CX Manager" → also search "Customer Experience", "CX Specialist", "CX Lead", "Experience Manager"
- "Growth Manager" → also "Growth Marketing", "Growth Lead", "Growth Analyst", "Experimentation"
- "CRO" → also "Conversion Optimization", "Optimization Lead", "A/B Testing", "Experimentation"

### Company-first approach
1. List 20-30 dream companies
2. Check their careers pages directly
3. Set up Google Alerts: `site:company.com/careers "[role keyword]"`
4. Follow them on LinkedIn for job posts

## Evaluation Framework

### Quick Screen (30 seconds)
1. Job title — does it match your level?
2. Company — any red flags? Already applied/excluded?
3. Location — compatible?
4. Posted date — stale listings (>30 days) are risky

### Deep Evaluation (5 minutes)
1. **Skill match** — do you have 60%+ of required skills?
2. **Level match** — not too junior, not too senior?
3. **Growth potential** — will you learn and develop?
4. **Compensation signals** — any salary range posted?
5. **Team/manager** — can you find them on LinkedIn?

### Fit Score Guide
- 🟢 **75-100**: Great fit — apply immediately
- 🟡 **55-74**: Good fit — worth applying, highlight transferable skills
- 🟠 **40-54**: Stretch — only if company/role is exciting
- 🔴 **Below 40**: Skip — save your energy

## Daily Job Search Routine (30-45 min)
1. Check saved searches on LinkedIn/Indeed (5 min)
2. Review new postings from target companies (10 min)
3. Apply to 1-2 strong matches with tailored applications (15-20 min)
4. Send 1-2 networking messages (5 min)
5. Update job tracker (2 min)

## Tracking Best Practices
Track every application with:
- Company, role, date applied, source
- Status: applied → screening → interview → offer/rejected
- Contact person (recruiter/hiring manager)
- Salary range if known
- Notes on fit and interest level
- Follow-up dates

## Networking Events & Job Fairs
- Register early, research companies attending
- Prepare a 30-second elevator pitch
- Bring business cards or have LinkedIn QR ready
- Follow up within 24 hours with a personalized message
- Focus on conversations, not collecting swag
