# Jo4 - URL Shortener & Analytics

🔗 **[jo4.io](https://jo4.io)** - Modern URL shortening with QR codes and detailed analytics.

## Features

- **Short URLs** - Custom aliases, branded links
- **QR Codes** - Auto-generated for every link
- **Analytics** - Clicks, geography, devices, referrers
- **UTM Tracking** - Built-in campaign parameters
- **Password Protection** - Secure sensitive links
- **Expiring Links** - Time-limited access

## Quick Examples

```bash
# Shorten a URL
curl -X POST "https://jo4-api.jo4.io/api/v1/protected/url" \
  -H "X-API-Key: $JO4_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"longUrl": "https://example.com", "title": "My Link"}'

# Get analytics
curl "https://jo4-api.jo4.io/api/v1/protected/url/{slug}/stats" \
  -H "X-API-Key: $JO4_API_KEY"
```

## Links

- **Website**: https://jo4.io
- **API Docs**: https://jo4-api.jo4.io/swagger-ui/index.html
- **Get API Key**: https://jo4.io/api-keys
