---
name: jisu-enterprise
description: 使用极速数据企业工商信息 API，查询企业基本信息、名称搜索结果、变更记录以及股东高管信息。
metadata: { "openclaw": { "emoji": "🏢", "requires": { "bins": ["python3"], "env": ["JISU_API_KEY"] }, "primaryEnv": "JISU_API_KEY" } }
---

# 极速数据企业工商信息（Jisu Enterprise）

基于 [企业工商信息 API](https://www.jisuapi.com/api/enterprise/) 的 OpenClaw 技能，支持：

- **企业工商信息查询**（`/enterprise/query`）
- **企业名称搜索**（`/enterprise/search`）
- **企业变更信息**（`/enterprise/changerecord`）
- **股东高管信息**（`/enterprise/shareholder`）

使用技能前需要申请数据，申请地址：https://www.jisuapi.com/api/enterprise/

## 环境变量配置

```bash
# Linux / macOS
export JISU_API_KEY="your_appkey_here"

# Windows PowerShell
$env:JISU_API_KEY="your_appkey_here"
```

## 脚本路径

脚本文件：`skills/enterprise/enterprise.py`

## 使用方式

### 1. 企业基本信息查询（/enterprise/query）

按公司名称或统一信用代码、注册号、组织机构代码中的任意一个查询：

```bash
# 按公司名称查询
python3 skills/enterprise/enterprise.py '{"company":"杭州极速互联科技有限公司"}'

# 按统一信用代码查询
python3 skills/enterprise/enterprise.py '{"creditno":"913********76527B"}'
```

请求 JSON 字段：

```json
{
  "company": "杭州极速互联科技有限公司",
  "creditno": "",
  "regno": "",
  "orgno": ""
}
```

> 四个字段只需提供其中一个，其余可为空。

### 2. 企业名称搜索（/enterprise/search）

```bash
python3 skills/enterprise/enterprise.py search '{"keyword":"极速互联","page":1,"pagesize":10}'
```

### 3. 企业变更信息（/enterprise/changerecord）

```bash
python3 skills/enterprise/enterprise.py changerecord '{"company":"杭州极速互联科技有限公司"}'
```

### 4. 股东/高管信息（/enterprise/shareholder）

```bash
python3 skills/enterprise/enterprise.py shareholder '{"company":"杭州极速互联科技有限公司"}'
```

## 请求参数

### 企业基本信息查询

| 字段名   | 类型   | 必填 | 说明                                   |
|----------|--------|------|----------------------------------------|
| company  | string | 否   | 工商名称（四个参数只传一个即可）       |
| creditno | string | 否   | 统一信用代码                           |
| regno    | string | 否   | 注册号                                 |
| orgno    | string | 否   | 组织机构代码                           |

> `company` / `creditno` / `regno` / `orgno` 四者至少提供其一。

### 企业名称搜索

| 字段名   | 类型   | 必填 | 说明                               |
|----------|--------|------|------------------------------------|
| keyword  | string | 是   | 关键词                             |
| page     | int    | 否   | 页码                               |
| pagesize | int    | 否   | 每页条数，默认 10，最大 20         |

### 变更信息与股东信息

同基本信息查询：`company` / `creditno` / `regno` / `orgno` 四者至少提供一个。

## 返回结果示例（节选）

### 企业基本信息（/enterprise/query）

```json
{
  "basic": {
    "name": "百度在线网络技术（北京）有限公司",
    "orgno": "717743469",
    "regno": "110000410144104",
    "creditno": "91110108717743469K",
    "legalperson": "崔珊珊",
    "regcapital": "4520",
    "scope": "……",
    "status": "在营",
    "province": "北京市",
    "city": "北京市",
    "regaddress": "北京市海淀区上地十街10号百度大厦三层",
    "regorgan": "北京市海淀区市场监督管理局",
    "regdate": "2000-01-18"
  }
}
```

### 企业名称搜索（/enterprise/search）

```json
{
  "total": 9,
  "keyword": "极速数据",
  "list": [
    {
      "name": "深圳市极速大数据教育网络有限公司",
      "status": "在营",
      "regcapital": 1000,
      "regionid": "广东省深圳市龙华区",
      "nicid": "批发和零售业-批发业-机械设备、五金产品及电子产品批发-计算机、软件及辅助设备批发",
      "type": "有限责任公司",
      "regno": "440300207936163",
      "creditno": "91440300MA5FRRHB95",
      "regaddress": "深圳市龙华区大浪街道同胜社区同富裕工业园18号401",
      "regdate": "2019-09-02",
      "legalperson": "洪荣丰"
    }
  ]
}
```

### 变更信息（/enterprise/changerecord）

```json
{
  "changerecord": [
    {
      "name": "住所变更",
      "beforecontent": "杭州市转塘街道双流***号E*-*-**室",
      "aftercontent": "浙江省杭州市西湖区转塘街道双流***号E*-*-**室",
      "changedate": "2020-09-04"
    }
  ]
}
```

### 股东及高管信息（/enterprise/shareholder）

```json
{
  "shareholder": [
    {
      "name": "李炳生",
      "type": "自然人股东",
      "subcapital": "200",
      "paidcapital": "0",
      "currency": "人民币"
    }
  ],
  "executive": [
    {
      "name": "刘攀登",
      "position": "执行董事兼总经理",
      "islegalperson": 1
    }
  ]
}
```

## 常见错误码

来源于 [官方企业工商文档](https://www.jisuapi.com/api/enterprise/)：

| 代号 | 说明                         |
|------|------------------------------|
| 201  | 公司名称、信用代码和注册号都为空 |
| 202  | 公司不存在（扣次数）         |
| 210  | 没有信息                     |

系统错误码：

| 代号 | 说明                 |
|------|----------------------|
| 101  | APPKEY 为空或不存在  |
| 102  | APPKEY 已过期        |
| 103  | APPKEY 无请求权限    |
| 104  | 请求超过次数限制     |
| 105  | IP 被禁止            |

## 在 OpenClaw 中的推荐用法

1. 用户输入公司名：「查一下 `杭州极速互联科技有限公司` 的工商信息。」  
2. 代理构造 JSON：`{"company":"杭州极速互联科技有限公司"}` 并调用：  
   `python3 skills/enterprise/enterprise.py '{"company":"杭州极速互联科技有限公司"}'`  
3. 从 `basic` 字段中提取注册资本、成立日期、注册地址、法人、经营范围等关键信息，为用户生成摘要；  
4. 若用户进一步关心历史变更或股东结构，可再调用 `changerecord` 和 `shareholder` 子命令补充详细信息。  

