---
name: jira-admin-cloud
description: "Jira Cloud admin playbook. Use for Jira Cloud administration tasks: projects (company-managed/team-managed), permissions, workflows, fields/screens, automation, JSM setup (queues/SLAs/portals), reporting/dashboards, and Confluence integrations. Includes official Atlassian references and best-practice checklists in ES/EN."
---

# Jira Admin Cloud (Phase 1)

## What this skill does
- Practical guide for **Jira Cloud** administration (includes JSM and Confluence).
- Module checklists and official references.
- Respond in **ES/EN** as requested by the user.

## Recommended flow (fast)
1) Identify **project type**: Company-managed vs Team-managed.
2) Define the user goal (permissions / workflow / fields / automation / JSM / reports).
3) Use the **module checklist** in `references/`.
4) If more detail is required, open Atlassian official docs.

## Modules & references
- **Atlassian base** → `references/atlassian-cloud-links.md`
- **Checklists** → `references/checklists.md`
- **JSM** → `references/jsm-links.md`
- **Confluence** → `references/confluence-links.md`
- **Experts** → `references/experts-links.md`

## Key checklists (summary)
- **Permissions**: roles vs permissions, schemes, groups, granularity.
- **Workflows**: statuses, transitions, validators, post-functions, conditions.
- **Fields/Screens**: contexts, screens, required fields, global impact.
- **Automation**: project/global rules, limits, audit.
- **JSM**: request types, SLAs, queues, portal.
- **Reporting**: shared filters, dashboards, gadgets.

## Notes
- Always prioritize **Jira Cloud** (not Data Center).
- Use **official Atlassian sources** for confirmation.
- Keep answers concise and actionable.
