---
name: jinko-flight-search
description: >
  Search flights and discover travel destinations using the Jinko MCP server.
  Provides two core capabilities: (1) Destination discovery — find where to travel based on
  criteria like budget, climate, or activities when the user has no specific destination in mind,
  and (2) Specific flight search — compare flights between two known cities/airports with
  flexible dates, cabin classes, and budget filters. Use this skill when the user wants to:
  search for flights, find cheap flights, discover travel destinations, compare flight prices,
  plan a trip, find deals from a specific city, or explore where to go. Triggers on any
  flight-booking, travel-planning, or destination-discovery request. Requires the Jinko MCP
  server connected at https://mcp.gojinko.com.
---

# Jinko Flight Search

Search flights and discover destinations via the Jinko MCP server (`find_destination` and `find_flight` tools).

## MCP Connection

Connect the Jinko MCP server in Claude's settings or project integrations using this URL:

```
https://mcp.gojinko.com
```

This provides two tools: `Jinko:find_destination` and `Jinko:find_flight`.

## Tool Selection

1. **User knows origin AND destination city** → Use `find_flight`
2. **User wants destination ideas, doesn't know where to go, or specifies criteria (beach, warm, ski, cheap…)** → Use `find_destination`
3. **User asks for the cheapest dates to a single known destination** → Use `find_flight`

## Tool 1: `find_destination` — Discover Where to Go

Use when the user is exploring options and hasn't committed to a single destination city.

### Required Parameters

- `origins` — Array of IATA codes for ALL nearby airports at the user's origin.
- `trip_type` — `"roundtrip"` (default) or `"oneway"` (only when user explicitly says one-way).

### Optional Parameters

| Parameter | Use when |
|---|---|
| `destinations` | User mentions a region, criteria, or list of candidate cities. Generate IATA codes matching the intent. Leave empty for global discovery ("anywhere", "surprise me"). |
| `departure_dates` / `departure_date_ranges` | User specifies dates or periods. All dates MUST be in the future. |
| `return_dates` / `return_date_ranges` | User specifies return windows. |
| `stay_days` / `stay_days_range` | User mentions trip length ("a week", "5-10 days"). |
| `max_price` | User mentions a budget. |
| `direct_only` | User asks for nonstop/direct flights. |
| `cabin_class` | `"economy"`, `"premium_economy"`, `"business"`, or `"first"`. |
| `currency` | ISO 4217 code matching user's locale. |
| `locale` | e.g. `"en-US"`, `"fr-FR"`. |
| `sort_by` | `"lowest"` (default) or `"recommendation"`. |

### Airport Identification — Critical

Always expand a city to ALL its airports:

- New York → `["JFK","LGA","EWR"]`
- London → `["LHR","LGW","STN","LTN","LCY"]`
- Paris → `["CDG","ORY"]`
- Tokyo → `["NRT","HND"]`
- Chicago → `["ORD","MDW"]`
- Los Angeles → `["LAX"]`
- San Francisco / SFO → `["SFO"]`

### Destination Generation — Critical

When users describe criteria, generate matching IATA codes before calling the tool:

- "Beach" → `["MIA","SAN","HNL","CUN","PUJ","SJU","NAS","MBJ"]`
- "Asia" → `["NRT","HND","ICN","PVG","PEK","HKG","SIN","BKK","KUL","MNL"]`
- "European capitals" → `["LHR","CDG","FRA","MAD","FCO","AMS","BRU","VIE","PRG","CPH"]`
- "Ski" → `["DEN","SLC","ZRH","INN","GVA","TRN"]`
- "Warm in winter" → `["MIA","MCO","SAN","PHX","HNL","CUN","PUJ","PTY","LIM","GIG"]`

### When to Re-call

Re-call `find_destination` when the user changes destination criteria, dates, or asks to explore different options — especially when they are already viewing the widget in fullscreen.

### Examples

| User says | origins | destinations | other params |
|---|---|---|---|
| "Where should I travel from NYC next month?" | `["JFK","LGA","EWR"]` | `[]` (global) | `departure_date_ranges` for next month |
| "Cheap flights from SF to Europe under $800" | `["SFO"]` | European airports | `max_price: 800` |
| "Somewhere warm from Chicago, 1 week in Dec" | `["ORD","MDW"]` | warm-weather airports | `stay_days: 7`, Dec date range |
| "Best weekend getaways from Boston" | `["BOS"]` | `[]` (global) | `stay_days_range: {min:2, max:4}` |

## Tool 2: `find_flight` — Search a Specific Route

Use when both origin and destination cities are known.

### Required Parameters

- `origin` — Single IATA airport or city code (e.g. `"JFK"`, `"PAR"`).
- `destination` — Single IATA airport or city code (e.g. `"CDG"`, `"LON"`).
- `trip_type` — `"roundtrip"` (default) or `"oneway"`.

### Optional Parameters

Same date, stay, price, cabin, currency, locale, direct, and sort parameters as `find_destination`.

### Examples

| User says | origin | destination | other params |
|---|---|---|---|
| "Flights from JFK to CDG next month" | `"JFK"` | `"CDG"` | `departure_date_ranges` for next month |
| "LA to Tokyo for a week in December" | `"LAX"` | `"TYO"` | `stay_days: 7`, Dec date range |
| "Business class NYC to London, 5-10 days" | `"NYC"` | `"LON"` | `cabin_class: "business"`, `stay_days_range: {min:5, max:10}` |
| "Cheapest ORD to LHR under $600" | `"ORD"` | `"LHR"` | `max_price: 600` |

## General Rules

- Default to **roundtrip**. Only use `"oneway"` when the user explicitly writes "one way" or "one-way".
- All dates **must be in the future**. Never send a past date.
- Fill as many search parameters as possible from the user's intent to get the best results.
- Use city codes (e.g. `"LON"`, `"NYC"`, `"PAR"`, `"TYO"`) when searching across all airports in a city.
- Provide results in the user's preferred currency and locale when identifiable.
