---
name: jimeng-video
description: 即梦AI视频生成工具（带声音版本），通过火山引擎API自动生成带音频的高质量视频。支持文生视频、图生视频，适用于短视频内容创作。
version: 2.0.0
author: 巴克
---

# jimeng-video Skill v2.0

即梦AI（Dreamina）视频生成工具 - **带声音版本**

## 🎉 v2.0 重大更新

**✅ 支持生成带声音的视频！**

默认使用 `doubao-seedance-1-5-pro-251215` 模型，生成的视频自带音频（环境音/背景音乐/音效），无需后期配音！

---

## 功能特性

- **🎵 文生音视频**：输入文字描述，自动生成带声音的视频
- **🎵 图生音视频**：上传图片，生成带声音的动态视频
- **🎨 多模型支持**：支持多个视频生成模型（带声音/纯视频）
- **⚡ 批量生成**：支持一次性生成多个视频
- **📊 任务管理**：创建任务、查询状态、获取结果

---

## 支持的模型

### 🌟 推荐模型（默认）

| 模型ID | 类型 | 特点 | 音频 |
|:---|:---|:---|:---:|
| **`doubao-seedance-1-5-pro-251215`** | **文生音视频** | **生成视频自带声音**，效果最好 | ✅ **带声音** |

### 其他可用模型

| 模型ID | 类型 | 特点 | 音频 |
|:---|:---|:---|:---:|
| `doubao-seedance-1-0-pro-250528` | 视频生成 | Pro版，质量高 | ❌ 无声 |
| `doubao-seedance-1-0-lite-t2v-250428` | 文生视频 | 轻量版，速度快 | ❌ 无声 |
| `doubao-seedance-2-0-260128` | 视频生成 | 最新版，功能强 | ❌ 无声 |

---

## 快速开始

### 1. 生成带声音的视频（默认）

```bash
# 使用默认模型（带声音）
jimeng-video generate \
  -p "一匹马高高跃起，四个字从左到右书写，水墨风格，文字内容是马年大吉" \
  -o output.mp4

# 生成的视频将包含：画面 + 自动生成的音效/音乐
```

### 2. 指定纯视频模型（无声）

```bash
# 使用旧版模型（无声，如需纯画面）
jimeng-video generate \
  -m doubao-seedance-1-0-lite-t2v-250428 \
  -p "夕阳下的海滩，金色的阳光洒在波浪上" \
  -o beach.mp4
```

### 3. 批量生成

```bash
# 从文件批量生成
jimeng-video batch \
  --file prompts.txt \
  --output-dir ./videos/
```

### 4. 查询任务状态

```bash
# 查询指定任务
jimeng-video status --task-id cgt-20260228005550-95t42
```

---

## API 调用示例

### 生成带声音的视频

```bash
curl -X POST "https://ark.cn-beijing.volces.com/api/v3/contents/generations/tasks" \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer ${API_KEY}" \
  -d '{
    "model": "doubao-seedance-1-5-pro-251215",
    "content": [
      {
        "type": "text",
        "text": "你的提示词内容"
      }
    ]
  }'
```

### 查询结果

```bash
curl -X GET "https://ark.cn-beijing.volces.com/api/v3/contents/generations/tasks/{task_id}" \
  -H "Authorization: Bearer ${API_KEY}"
```

---

## 提示词技巧

### 带声音视频的有效提示词结构

```
[场景描述] + [动作/事件] + [氛围/情绪] + [声音提示]
```

**示例（带声音暗示）：**
- ✅ "热闹的台球厅，球杆击球声，人群的欢呼，专业比赛氛围"
- ✅ "海浪拍打沙滩，海鸥叫声，轻松惬意的夏日午后"
- ✅ "繁忙的城市街道，车声喇叭声，霓虹灯闪烁的夜晚"

**声音相关关键词（帮助模型生成更好音效）：**
- 环境音："嘈杂的人群声"、"雨声"、"风声"
- 动作音："击球声"、"键盘敲击声"、"脚步声"
- 情绪音："欢快的音乐"、"紧张的氛围"、"舒缓的旋律"

---

## 配置说明

### 环境变量

在 `~/.openclaw/.credentials/volcengine-dreamina.env` 中配置：

```bash
VOLCENGINE_ACCESS_KEY_ID=your-access-key-id
VOLCENGINE_SECRET_ACCESS_KEY=your-secret-key
```

### 获取API Key

1. 登录火山引擎控制台：`console.volcengine.com`
2. 进入「访问控制」→「API Key管理」
3. 创建新的API Key
4. 开通即梦AI视频生成服务

---

## 模型对比

| 维度 | 1.5 Pro（带声音） | 1.0 Lite（无声） |
|:---|:---|:---|
| **音频** | ✅ 自动生成 | ❌ 需后期添加 |
| **画质** | 1080p | 720p/1080p |
| **生成速度** | 30-40秒 | 15-25秒 |
| **适用场景** | 短视频成品 | 素材/需后期配音 |
| **价格** | 较高 | 较低 |

**建议：**
- **成品视频** → 使用 1.5 Pro（带声音）
- **素材剪辑** → 使用 1.0 Lite（无声）

---

## 返回结果

### 成功响应（带声音模型）

```json
{
  "id": "cgt-20260228140147-6t2sz",
  "model": "doubao-seedance-1-5-pro-251215",
  "status": "succeeded",
  "content": {
    "video_url": "https://..."
  },
  "generate_audio": true,
  "resolution": "720p",
  "duration": 5,
  "framespersecond": 24
}
```

**关键字段：**
- `generate_audio: true` - 表示包含音频生成
- `video_url` - 视频下载链接（包含音视频）
- `duration` - 视频时长（秒）

---

## 使用场景

- **短视频创作**：直接生成带声音的成品视频
- **广告制作**：快速产出带音效的广告素材
- **内容运营**：自动生成带背景音的短视频
- **创意实验**：AI自动生成完整音视频内容

---

## 注意事项

1. **音频质量**：自动生成的音频是AI合成的环境音/音乐，不是真实录音
2. **生成时间**：带声音版本比无声版本慢约50%（30-40秒 vs 15-25秒）
3. **定制音频**：如需特定音乐，建议用无声版本+后期添加
4. **音量平衡**：自动音频音量适中，如需调整请后期处理

---

## 故障排查

### 模型未开通

**错误：** `ModelNotOpen`
**解决：** 在火山引擎控制台开通即梦AI 1.5 Pro服务

### 生成超时

**现象：** 任务长时间 running
**解决：** 带声音模型生成较慢，请耐心等待（最长2分钟）

### 音频不满意

**解决：** 
- 调整提示词中的声音描述
- 或使用无声模型+后期添加自定义音乐

---

## 更新日志

### v2.0.0 (2026-02-28)
- ✅ 升级默认模型为 `doubao-seedance-1-5-pro-251215`
- ✅ 支持生成带声音的视频
- ✅ 优化提示词文档，增加声音相关技巧
- ✅ 添加模型对比说明

### v1.0.0 (2026-02-27)
- 初始版本
- 支持基础视频生成功能

---

**让视频创作更简单，一步到位生成带声音的成品！** 🎬🎵
