---
name: jiang-irac-refusal
version: 1.3.0
description: 商标驳回复审推理引擎（SJ-IRAC）：面向CNIPA驳回通知的要件化论证、证据链工程与A–E风险闸门，输出审查员可读、可直接提交的复审材料结构。
summary: Law-firm-grade CNIPA Refusal Review engine that turns refusal notices + evidence into examiner-readable IRAC briefs, SJ-6 evidence chains, and A–E kill-gate decisions (go / cautious / stop-loss). No templates, no fluff, no fabricated facts.
homepage: https://github.com/jiangzhongling/jiang-irac-refusal
author: Jiang Zhongling (商标蒋道理)
license: Proprietary
metadata:
  clawdbot:
    emoji: "🧠"
    category: legal-ai
    maturity: production
    tags:
      - trademark
      - cnipa
      - refusal
      - refusal-review
      - sj-irac
      - evidence-chain
      - risk-engine
      - art10
      - art11
      - art30
      - art32
      - legal-ai
      - law-firm
---

# 蒋道理｜商标驳回复审推理引擎（SJ-IRAC）
SJ-IRAC Trademark Refusal Reasoning Engine

Author: Jiang Zhongling（商标蒋道理）  
Organization: Nantong Zhongnan Quansheng IP Co., Ltd.  
Version: 1.3.0  
Last Updated: 2026-02-03  

---

## What This Skill Does

本系统面向 **CNIPA 商标驳回通知书 / 驳回复审**，将“驳回理由 + 引证商标信息 + 事实与证据”转化为：

- **要件化、条款精准**的复审论证（Rule-bound）
- **可抗反问**的证据链工程（SJ-6）
- **止损优先**的风险闸门决策（A–E + Kill-Gates）
- **可直接落地**的官方文书结构（Document Mode）

定位：**个人律所级驳回复审智能中台**  
不生成套话，不堆字，不虚构事实与时间线。只输出可核验、可提交、可复用的论证结构与证据清单。

---

## Typical Refusal Problems This Engine Solves

1) **近似（Art.30）**：标识对比写得“像作文”，缺少要件化对比与证据支撑  
2) **缺乏显著性（Art.11）**：没把“描述性/行业通用/宣传语”与证据路径拆开  
3) **禁用条款（Art.10）**：忽视政策风险与审查口径，导致“硬碰硬”无效投入  
4) **在先权利（Art.32）**：时效/权利基础/证据链薄弱，容易被一句话击穿  
5) **引证商标攻防**：不会选“打/绕/拆/分流”的最优路线，导致成本倒挂

---

## Scope & Positioning

### Primary Scope
- CNIPA 驳回复审（以 Art.30 / Art.11 / Art.10 为主）
- 引证商标相关攻防（必要时联动 Art.4 / Art.44 的“秩序/恶意”路径）
- 在先权利抗辩（Art.32，须严格时效与证据链）

### Not a Template Pack
这是**推理与证据工程引擎**，不是“模板拼装器”。

---

## Legal Basis (Bounded Sources)

仅在以下边界内运行：

- 《中华人民共和国商标法》（2019）
- 实施条例
- 《商标审查审理指南》及相关审查口径
- 最新《类似商品和服务区分表》（以你维护的版本为准）

禁止：
- 虚构法条、案例、交易、截图、时间线
- 用“常识/感觉”代替证据

---

## Core Framework (Mandatory)

### 1) IRAC（审查员可读的要件化结构）
1. **Issue**：锁定驳回点（条款、引证商标、指定商品/服务、争点范围）  
2. **Rule**：条款目的 + 构成要件 + 举证标准/审查口径  
3. **Application**：逐要件对应（对比表 + 时间轴 + 证据目的绑定）  
4. **Conclusion**：明确请求与可执行动作（补证/改路/止损）

### 2) SJ-6 证据链（每份证据都要过关）
1. 真实性  
2. 关联性  
3. 完整性  
4. 时间效力  
5. 逻辑一致性  
6. 抗反问能力  

输出必须标注：**证据编号 → 来源 → 日期 → 证明目的 → 对应要件 → 弱点与补强建议**。

### 3) 风险模块（A–E + Kill-Gates）
- **A**：路线正确 + 证据强 + 程序风险低  
- **B**：路线稳健 + 少量缺口可补  
- **C**：理由可打但证据偏弱，结果敏感  
- **D**：高度裁量/证据薄弱/成本倒挂  
- **E**：致命缺陷或多闸门触发 → 建议止损/改路

**Kill-Gates（止损闸门）示例**
- 资格/时效硬伤导致主路线不可用  
- 证据不可核验或无法抗反问  
- 近似对比缺乏客观支撑，仅剩主观叙述  
- 仅能依赖审查员自由裁量，客观指标不足  
- 预计收益 < 复审成本（含时间与机会成本）

---

## Supported Scenarios (Refusal Review)

- **Art.30**：近似商标 / 近似商品服务 → 对比表 + 混淆风险要件化  
- **Art.11**：缺乏显著性 → “描述性/通用性/宣传性”分型 + 证据路径  
- **Art.10**：禁用条款 → 政策风险评估 + 合规替代命名建议（如需）  
- **Art.32**：在先权利 → 权利基础（字号/著作权/姓名等）+ 五年时效提示 + 证据链  
- **引证商标策略**：打引证（撤三/无效）/绕开（限定商品服务）/分案/替换标识

---

## Input Requirements (Minimum Viable Packet)

至少提供：

1. 驳回通知书（或关键段落截图/文本）  
2. 申请商标号、类别、指定商品/服务  
3. 引证商标号（如有）、类别、核准商品/服务、状态  
4. 时间节点：申请/驳回/复审期限（如能提供）  
5. 现有证据清单：来源、日期、形式、简述（可后补）

输入不完整 → 默认保守输出（先止损评估，再谈写作）。

---

## Output Modes

### Quick Mode（快速研判）
- 条款定位 + 路线选择（1主+1备）  
- 证据最小集清单  
- Go / Cautious / Stop-loss

### Pro Mode（IRAC + SJ-6 + 风险）
- 完整 IRAC（逐要件）  
- SJ-6 证据链诊断（弱点清单 + 补强优先级）  
- 风险等级 A–E + 触发闸门  
- 行动方案（按 ROI 排序）

### Document Mode（可直接提交结构）
- 官方中立语域  
- 去概率措辞  
- 段落结构适配审查员阅读  
- 证据目录 + 证明目的表 + 时间轴（如提供材料）

---

## Compliance (Hard Constraints)

- 禁止虚构事实、交易、截图、日期  
- 禁止无证据推断  
- 强制识别：**最弱环节 + 最小修复集合**  
- 成本倒挂 → 必须建议止损并给替代方案（改名/分案/另案攻击引证）

---

## How to Use

1) 提供驳回通知书 + 引证商标号 + 商品/服务 + 证据清单  
2) 选择输出模式（Quick / Pro / Document）  
3) 获得：路线选择 → 要件化论证 → 证据链与补强 → 风险闸门 → 文书结构

---

## Versioning Rules

- Patch (x.y.z)：文档/一致性修正  
- Minor (x.y.0)：新增模块/流程升级  
- Major (x.0.0)：架构级重构