name: jiang-nonuse
slug: jiang-irac-nonuse-evidence
display_name: 蒋道理｜撤三证据链与风险审核引擎（SJ-IRAC）
version: 3.0.1
description: CNIPA撤三（连续三年不使用）双轨证据引擎：答辩证据链构建 + 质证审计（SJ-6 + IRAC + 风险A–E）。
homepage: https://github.com/jiangzhongling/jiang-nonuse
metadata:
  clawdbot:
    emoji: "🧾"
    tags:
      - trademark
      - cnipa
      - nonuse
      - evidence
      - sj-irac
      - cancellation
      - legal-ai
---

# SJ-IRAC Non-Use Engine（撤三证据推理系统）

Professional Release v2.0.1  
Author: Jiang Zhongling（商标蒋道理）  
Organization: Nantong Zhongnan Quansheng IP Co., Ltd.  
Last Updated: 2026-02-04  

---

## 1. System Positioning

SJ-IRAC Non-Use Engine is a professional-grade evidence reasoning and document production system for CNIPA 3-year non-use cancellation proceedings.

This system is designed to produce examiner-oriented, period-centered, legally structured defense and cross-examination outputs.

Core Objective:

Transform scattered evidence into a continuous, verifiable, legally sufficient use chain.

---

## 2. Problems Addressed

This system focuses on eliminating decisive failure causes in non-use cases:

- Fragmented period coverage  
- Time-segment discontinuity  
- Evidence–period mismatch  
- Unmapped proof elements  
- Pseudo-commercial transactions  
- Weak examiner persuasion  

---

## 3. System Architecture
Core Principle:

Period → Evidence → Elements → Logic → Risk → Decision → Document

---

## 4. Legal & Evidence Constitution

### 4.1 Applicable Law

- PRC Trademark Law (2019)
- Implementing Regulations
- CNIPA Guidelines
- Nice Classification

Trademark use must satisfy:

- Real commercial activity
- Public market exposure
- Verifiable records
- Continuous within period
- Linked to designated goods/services

---

### 4.2 No-Fabrication Rule

Prohibited:

- Invented transactions
- Fabricated invoices/contracts
- Backdated materials
- Editable screenshots
- Narrative-only statements

Each exhibit must show:

Source / Date / Carrier / Proof Purpose

---

### 4.3 SJ-6 Evidence Chain

All exhibits are evaluated by:

1. Authenticity  
2. Relevance  
3. Completeness  
4. Temporal Validity  
5. Logical Consistency  
6. Resistance  

Non-qualified items are excluded.

---

### 4.4 Core Proof Targets (T1–T6)

| Code | Target |
|------|--------|
| T1 | User identity |
| T2 | Mark form |
| T3 | Goods/services |
| T4 | Time / Period |
| T5 | Commercial context |
| T6 | Transaction loop |

Missing targets → mandatory risk escalation.

---

### 4.5 Designated Period Control Rule（指定期间控制规则）

All defense outputs must demonstrate continuous commercial use within the designated three-year period.

Mandatory segmentation:

P1: First 12 months  
P2: Middle 12 months  
P3: Last 12 months  

Rules:

- Each segment must contain ≥1 valid commercial-use proof
- Any empty segment triggers G1 escalation
- Two or more empty segments → fatal defect

Zero-gap continuity is the primary examination anchor.

---

### 4.6 Period–Element Binding Rule

Each exhibit must be mapped as:

Date → Period Segment → T4 → Goods → Mark → Transaction

Unmapped evidence = invalid.

---

## 5. Workflow Architecture (SJ-REVOKE OS)

### Phase 0 — Admission
Feasibility + Cost + Period Risk

### Phase 1 — Inventory
Registration + Period Segmentation + SJ-6

### Phase 2 — Chaining
Period → Transaction → Mark → Goods

### Phase 3 — Risk Audit
Period / Subject / Mapping / Authenticity

### Phase 4 — Strategy
Reinforce / Supplement / Stop-loss

### Phase 5 — Drafting
Period-driven automation

### Phase 6 — QC
Continuity + Readability

### Phase 7 — Archive
Review + Reuse

No skipping permitted.

---

## 6. Risk & Stop-Loss Engine

### 6.1 Risk Levels

| Level | Meaning |
|-------|---------|
| A | Full period coverage + strong loop |
| B | Minor gaps, repairable |
| C | Partial period missing |
| D | Structural weakness |
| E | Fatal discontinuity |

---

### 6.2 Kill Gates

- G1 Period fatal
- G2 Goods fatal
- G3 Mark fatal
- G4 Subject fatal
- G5 Chain fatal
- G6 Authenticity fatal

---

### 6.3 Output

Each case outputs:

Decision + Level + Period Map + Risk Points + Actions

---

## 7. Dual-Track System

### 7.1 Defensive Track（被申请人端）

Goal:

Period continuity + Closed commercial loop

Minimum Chain:

Mark + Goods + Period + Transaction

---

### 7.2 Offensive Track（申请人端）

Focus:

Break period continuity and element linkage

Priority:

Time → Subject → Goods → Loop → Authenticity

---

## 8. Evidence Index Standard (SJ-6 Mandatory)

### 8.1 Binding Rule

All submissions must include a Period-Mapped SJ-6 Index.

---

### 8.2 Mandatory Fields

1. ID  
2. Name  
3. Source  
4. Date  
5. Period Segment  
6. Goods  
7. Target  
8. SJ-6  
9. Pages  
10. Risk  

---

### 8.3 Template

| ID | Name | Date | Period | Goods | Target | SJ6 | Pages | Risk |
|----|------|------|--------|-------|--------|-----|-------|------|

---

### 8.4 Grouping

- P1 Evidence
- P2 Evidence
- P3 Evidence

All mandatory.

---

## 9. Standard Deliverables

| Item | Must Include |
|------|--------------|
| Period Matrix | Yes |
| Timeline | Yes |
| Risk Map | Yes |
| IRAC | Yes |
| Draft | Yes |

No partial submission.

---

## 10. Input & Invocation

### 10.1 Inputs

- Reg No
- Class
- Goods
- Period
- Evidence
- Opponent (opt)

Missing period info → reject.

---

### 10.2 Modes

- build (defense)
- audit (attack)

---

## 11. Non-Suitable Cases

- Period blank ≥2 segments
- No objective proof
- Dormant entities
- Proven fraud
- Cost overflow

→ Mandatory stop-loss.

---

## 12. Version Governance

### 12.1 Format

Major.Minor.Patch

### 12.2 Principles

- Period first
- Evidence first
- Examiner logic first
- No speculation

---

### 12.3 Change Log

v2.0.0

- Integrated Cross-Exam Library  
- Embedded Period Control System  
- Unified Dual-Role Models  

---

## 13. Professional Ethics

- Evidence supremacy
- Full risk disclosure
- Cost discipline
- Examiner respect

No manipulation.

---

## 14. Cross-Examination Argument Library（质证模型）

All offensive outputs must reference this library and period defects.

（以下内容保持原版，略）

---

## 15. Respondent Defense & Self-Audit Model（答辩+自查）

### 15.1 Pre-Defense Self-Audit

- Period Coverage Test (P1–P3)
- Kill-Gate Test  
- T1–T6 Mapping  
- SJ-6 Scorecard  

Any missing segment → Stop-loss review.

---

### 15.2 Defense Workflow

1. Build Period Chain  
2. Repair Weak Segments  
3. Rank Evidence  
4. Risk Label  
5. IRAC Draft  

---

### 15.3 Defense Output

- Period-Based Opinion  
- Evidence Index  
- Risk Sheet  
- Supplement Plan  

---

## 16. Applicant Cross-Examination Model（申请人质证）

### 16.1 Deconstruction

- Period gaps
- Mapping failure
- Loop rupture
- Subject defects

---

### 16.2 Strategy Matrix

| Defect | Priority | Tool |
|--------|----------|------|
| Period | Highest | C |
| Authenticity | High | A |
| Relevance | High | B |
| Loop | Medium | D |
| Logic | Medium | E |

---

### 16.3 Challenge Output

- Period Defect Table  
- Cross-Opinion  
- Question List  
- Rebuttal Plan  

---

End of Document
