# Stress Management and Wellbeing

## Warning Signs to Monitor

### Academic Warning Signs
- Mock scores dropping 3+ tests in a row
- Skipping scheduled study sessions frequently
- Not submitting coaching DPPs
- Avoiding specific subjects entirely

### Mental Health Warning Signs
- Sleep changes (too much or too little)
- Social withdrawal
- Statements like "I'm wasting my life" or "What's the point"
- Comparing excessively with peers
- Physical symptoms: headaches, stomach issues, fatigue

## Agent Response Protocol

### Mild Stress
- Acknowledge the pressure
- Adjust schedule to reduce load
- Suggest short breaks
- Celebrate recent small wins

### Moderate Stress
- Reduce daily targets by 30%
- Enforce rest days
- Connect with peer support
- Review whether expectations are realistic

### Severe Stress
- Pause academic demands
- Encourage talking to parents/counselors
- Provide helpline information
- Do not push performance metrics

## Dropper-Specific Mental Health

### Unique Challenges
- Watching friends go to college
- Family expectations ("ek aur saal de diya")
- Isolation during prep
- Shame from previous "failure"

### Support Strategies
- Acknowledge the difficulty explicitly
- Frame the year as investment, not punishment
- Track progress to show growth (not just absolute scores)
- Connect with other droppers if possible
- Weekly parent updates to reduce interrogation

## Break Protocols

### Micro-breaks (every 90 min)
- 5-10 minutes
- Walk, stretch, water
- NO screens

### Daily breaks
- Minimum 2 hours non-study time
- Physical activity (even 20 min walk)
- One hobby/enjoyment activity

### Weekly rest
- One half-day completely off
- Social interaction
- Outdoor time if possible

### Burnout recovery
- 2-3 days reduced intensity
- Light revision only
- Sleep priority
- No guilt messaging

## Sleep Protocol

| Days to Exam | Minimum Sleep |
|--------------|---------------|
| 30+ days | 7 hours |
| 7-30 days | 7 hours (non-negotiable) |
| 1-7 days | 8 hours |
| Exam day | 7-8 hours, wake 3+ hours before exam |

## Parent Communication

### What Parents Need
- Weekly progress summaries
- Context for score fluctuations
- What NOT to say to the student
- When to be concerned

### Agent Can Generate
- Parent update reports
- Comparison with historical trajectories
- "Questions to avoid" list
- "How to support" suggestions

## Emergency Resources (India)

- **iCall:** 9152987821
- **Vandrevala Foundation:** 1860-2662-345 (24/7)
- **NIMHANS:** 080-46110007
- **Kota-specific support:** Local coaching helplines
