# User Type Adaptations

## User Type Detection

Ask early:
1. Are you currently in 11th, 12th, or taking a drop year?
2. Are you also preparing for board exams?
3. Do you have coaching or self-studying?
4. (If parent) Are you the student or a parent/guardian?

## Fresh Student (11th/12th)

### Characteristics
- Learning concepts for first time
- Balancing school + coaching + self-study
- May underestimate JEE difficulty initially
- Time is the main advantage

### Agent Adaptations
- Full syllabus coverage plans
- School-coaching-self study balance
- Build strong fundamentals before shortcuts
- Monthly milestone targets
- Board integration if in 12th

### Key Metrics
- Chapter completion rate
- Concept clarity (not just problem solving)
- Consistency of study hours

## Dropper (Gap Year)

### Characteristics
- Already seen full syllabus once
- Previous attempt data available
- Higher psychological pressure
- Need surgical improvement, not restart

### Agent Adaptations
- Start with gap analysis of previous year
- Focus 70% time on weak areas
- Track mistake patterns from before
- Stricter daily accountability
- Mental health monitoring priority
- Different resources to avoid "I know this" trap

### Key Metrics
- Improvement over previous scores
- Weak area closure rate
- Consistency (dropout risk is high)

## Dual-Prep (Board + JEE)

### Characteristics
- Managing two different exam styles
- Time constraints especially Feb-April
- Need mode-switching between board and JEE prep
- Practicals/projects eat into time

### Agent Adaptations
- Overlap mapping: which topics serve both
- Phase-based time allocation (JEE-heavy → Board-heavy → JEE again)
- Board-specific quick revision (NCERT exact, diagrams, derivations)
- Practical/project time blocking
- Flexible schedules around board dates

### Key Metrics
- Both JEE mock scores AND board practice scores
- Time balance between preparations
- Overlap efficiency (dual-purpose study sessions)

## Parent/Guardian

### Characteristics
- Want visibility without micromanaging
- Often don't understand JEE specifics
- Worried about mental health + results
- Need actionable insights, not data dumps

### Agent Adaptations
- Weekly summary reports (not daily interrogation)
- Translate scores to rank/college possibilities
- "How to support" guidance
- Alert only when patterns are concerning
- College admission guidance for decision-making

### Key Outputs
- Progress trajectory graphs
- Comparison to historical benchmarks
- "Questions to avoid asking" list
- College prediction based on current trajectory

## Tutor/Coaching Teacher

### Characteristics
- Managing 50-200+ students
- Need batch-level analytics
- Identify at-risk students early
- Administrative burden (DPPs, tests, PTMs)

### Agent Adaptations
- Multi-student dashboard
- Batch-wise weakness identification
- Auto-generated PTM reports
- DPP completion tracking
- Early warning for struggling students
- Performance comparison across batches

### Key Outputs
- Batch average tracking
- Individual student progress cards
- At-risk student list
- PTM talking points per student

## Coaching Variations

### Kota-Style Residential
- Full-time focus, high intensity
- Social isolation risk
- Need external mental health support
- Daily 10+ hour schedules

### Local Coaching + School
- Time split challenge
- Evening/weekend coaching
- School commitments can't be ignored
- Need efficient time use

### Online Coaching
- Flexibility but distraction risk
- Self-discipline critical
- Need active engagement tracking
- Can work from anywhere

### Self-Study
- Maximum flexibility
- Highest discipline required
- Resource selection important
- Need external accountability
- Mock tests crucial for benchmarking
