# Progress Tracking System

## Profile Setup (`~/jee/profile.md`)

```markdown
## Basic Info
- Target: JEE Main + Advanced
- Category: General / OBC-NCL / SC / ST / EWS
- User Type: 12th Student / Dropper / 11th Start
- Coaching: Allen Kota / FIITJEE / Online / Self-study

## Target Scores
- JEE Main Target Percentile: 99+
- JEE Advanced Target Rank: AIR < 5000
- Board Percentage Target: 90%+ (if applicable)

## Exam Dates
- JEE Main Session 1: 2026-01-XX
- JEE Main Session 2: 2026-04-XX
- JEE Advanced: 2026-05-XX
- Board Exams: 2026-02-XX to 2026-03-XX
```

## Chapter-Wise Tracking (`~/jee/subjects/`)

Structure:
```
subjects/
├── physics/
│   ├── mechanics.md
│   ├── electrodynamics.md
│   └── ...
├── chemistry/
│   ├── organic/
│   ├── inorganic/
│   └── physical/
└── mathematics/
    ├── calculus.md
    ├── algebra.md
    └── ...
```

Each chapter file:
```markdown
## Rotational Mechanics
- Status: In Progress / Complete / Revision Needed
- Mastery: 65%
- Last Practiced: 2026-01-10
- Weak Areas: Moment of inertia problems, rolling motion

### Practice Log
| Date | Source | Problems | Correct | Time |
|------|--------|----------|---------|------|
| 01-10 | HC Verma | 25 | 18 | 90m |
| 01-08 | PYQ 2020-24 | 15 | 10 | 45m |
```

## Mock Test Logging (`~/jee/mocks/`)

```markdown
## Mock Test - 2026-01-15

### Scores
- Physics: 72/100
- Chemistry: 65/100
- Mathematics: 58/100
- Total: 195/300
- Percentile Estimate: 96.5

### Time Analysis
- Physics: 55 min (target: 60)
- Chemistry: 70 min (target: 60) ⚠️
- Mathematics: 55 min (target: 60)

### Error Analysis
| Subject | Conceptual | Silly | Time Pressure | Unattempted |
|---------|------------|-------|---------------|-------------|
| Physics | 3 | 2 | 1 | 2 |
| Chemistry | 5 | 1 | 3 | 0 |
| Math | 4 | 3 | 2 | 1 |
```

## Mistake Pattern Tracking (`~/jee/mistakes/`)

```markdown
## Recurring Mistakes

### Sign Errors (Physics)
- Count: 12 this month
- Contexts: Potential energy, work done, lens formula
- Action: Write sign convention on rough sheet before starting

### Unit Conversion (Chemistry)
- Count: 8 this month
- Contexts: molarity ↔ molality, kJ ↔ J
- Action: Circle units in question before calculating

### Formula Confusion (Math)
- Count: 6 this month
- Contexts: Integration by parts direction, determinant expansion
- Action: Create formula revision sheet for last 30 min before exam
```

## Weekly Review Template

```markdown
## Week of 2026-01-08

### Chapters Covered
- [ ] Rotational Mechanics (revision)
- [x] Electrochemistry (new)
- [ ] Probability (partial)

### Mock Performance
- Test 1: 185/300 → 195/300 improvement
- Weak: Organic mechanisms, Probability

### Next Week Focus
1. Complete Probability
2. Organic mechanisms drill (20 problems/day)
3. Full mock Saturday
```
