# IIT/NIT Targeting

## College Hierarchy (Engineering)

### Tier 1: IITs (via JEE Advanced)
- Old IITs: Bombay, Delhi, Madras, Kanpur, Kharagpur
- Newer flagships: Roorkee, Guwahati, Hyderabad
- New IITs: Growing in reputation (BHU, Ropar, Indore, etc.)

### Tier 2: NITs (via JEE Main)
- Top NITs: Trichy, Warangal, Surathkal
- Other NITs: 31 total across India

### Tier 3: IIITs, GFTIs (via JoSAA)
- Premier IIITs: Hyderabad, Bangalore, Delhi
- State-funded institutes

## Rank to College Mapping (General Category, Approx)

### JEE Advanced Ranks (2024 reference)
| Rank Range | College Possibilities |
|------------|----------------------|
| < 500 | IIT Bombay/Delhi CSE |
| 500-1000 | Top 5 IIT CSE/EE |
| 1000-2500 | Old IIT core branches |
| 2500-5000 | Old IIT + Top new IIT |
| 5000-10000 | New IITs most branches |
| 10000-15000 | New IIT + Top NIT (if Main rank good) |

### JEE Main Percentile (2024 reference)
| Percentile | NIT Possibilities |
|------------|-------------------|
| 99.5+ | NIT Trichy/Warangal CSE |
| 99.0-99.5 | Top NIT good branches |
| 98.0-99.0 | Mid-tier NIT top branches |
| 95.0-98.0 | NIT lower branches, good IIITs |
| 90.0-95.0 | Lower NITs, state colleges |

## Category-Wise Adjustment

Cutoffs are significantly different by category. Agent should:
1. Always ask for category
2. Use category-specific historical cutoffs
3. Adjust rank predictions accordingly

Approximate advantage (varies by institute):
- OBC-NCL: Cutoff rank 1.3-1.5x General
- SC: Cutoff rank 2-3x General
- ST: Cutoff rank 3-5x General
- EWS: Similar to General with small buffer

## Branch Value Assessment

### Placement-Oriented Ranking
1. Computer Science (CSE)
2. Electrical/Electronics (EE/ECE)
3. Mathematics & Computing
4. Data Science / AI-ML
5. Mechanical
6. Chemical
7. Civil
8. Others (varies by institute)

### Factors Beyond Placement
- Interest alignment
- Research opportunities
- Campus culture
- City/location
- Alumni network

## JoSAA Choice Filling Strategy

### Principles
1. **Dream choices first** — Even if unlikely, list them
2. **Safe choices must exist** — At least 5-10 choices you're guaranteed
3. **Branch vs College tradeoff** — Decide early: top branch at lower college OR lower branch at top college
4. **Reporting strategy** — Freeze if satisfied; Float for upgrades; Slide for branch upgrade in same institute

### Common Mistakes
- Not filling enough choices (fill 50+ if possible)
- Unrealistic expectations (only listing top IITs)
- Not understanding Freeze/Float/Slide
- Missing document deadlines

## Backup Planning

### If JEE doesn't go as planned:
- BITS Pilani (BITSAT) — Private but excellent
- VIT, SRM, Manipal — Good backup options
- State entrance exams (MHT-CET, KCET, etc.)
- Board percentage for state quota

### Timeline
- BITSAT: May-June
- VIT: April-May
- State exams: April-June
- Counseling: Parallel with JoSAA

## Financial Planning

| College Type | Approximate Total Cost (4 years) |
|--------------|----------------------------------|
| IIT | ₹8-10 lakh |
| NIT | ₹4-6 lakh |
| BITS | ₹20-25 lakh |
| VIT/SRM | ₹12-18 lakh |

Scholarships available at IITs/NITs based on family income.
