# Study Methods and Strategy

## Spaced Repetition Schedule

| First Study | Review 1 | Review 2 | Review 3 | Review 4 |
|-------------|----------|----------|----------|----------|
| Day 0 | Day 1 | Day 3 | Day 7 | Day 21 |

Agent should track last-studied date per chapter and remind for review.

## Problem-Solving Hierarchy

1. **NCERT** — Foundation (especially Chemistry)
2. **HC Verma / Irodov** — Physics depth
3. **Coaching Material** — Structured practice
4. **Previous Year Questions (PYQ)** — Exam pattern familiarity
5. **Mock Tests** — Full simulation

## Time Allocation by Phase

### Early Prep (12+ months out)
- 60% new concepts
- 30% practice problems
- 10% revision

### Mid Prep (6-12 months)
- 30% new concepts
- 50% practice problems
- 20% revision

### Final Sprint (< 3 months)
- 10% new concepts (only gap-filling)
- 40% mock tests
- 50% revision + mistake review

## Daily Schedule Template

```
06:00 - 06:30  Morning routine
06:30 - 09:00  Subject 1 (strongest when fresh)
09:00 - 09:30  Break + breakfast
09:30 - 12:00  Subject 2
12:00 - 13:00  Lunch + rest
13:00 - 15:30  Subject 3
15:30 - 16:00  Break
16:00 - 18:00  Problem practice (mixed)
18:00 - 19:00  Dinner + break
19:00 - 21:00  Revision / Coaching homework
21:00 - 21:30  Day review + next day planning
```

## Mock Test Strategy

### Before Test
- Sleep 7+ hours
- Light revision only (no new concepts)
- Review personal mistake patterns

### During Test
- **First 10 minutes:** Scan all questions, mark easy ones
- **Attempt order:** Easy → Medium → Hard
- **Time checkpoints:** 60 min per subject (adjust if needed)
- **Last 15 minutes:** Revisit marked questions, transfer answers carefully

### After Test
- Same day: Review wrong answers, categorize mistakes
- Next day: Re-attempt wrong questions without looking at solutions
- Track patterns in `~/jee/mistakes/`

## Chapter Prioritization Matrix

| Weightage | Current Mastery | Priority |
|-----------|-----------------|----------|
| High | Low | 🔴 Urgent |
| High | Medium | 🟡 High |
| High | High | 🟢 Maintain |
| Low | Low | 🟡 Medium |
| Low | Medium/High | ⚪ Low |

Agent should calculate priority score: `Weightage × (100 - Mastery)`

## Dropper-Specific Strategy

1. **Gap Analysis First** — Don't restart from scratch; identify specific weak chapters
2. **New Resources** — Use different books/teachers to avoid "I already know this" trap
3. **Strict Accountability** — Daily targets with consequences
4. **Mental Health Monitoring** — Higher burnout risk; enforce breaks

## Board + JEE Dual Prep

### Overlap Optimization
- Physics: 80% overlap (JEE depth covers boards)
- Chemistry: 70% overlap (add NCERT exact text for boards)
- Mathematics: 75% overlap (boards need step-by-step solutions)

### Mode Switching
- 3 weeks before boards: Switch to board-style (theory, diagrams, derivations)
- After boards: Immediate JEE mode (problem-solving speed)

### Non-Negotiables for Boards
- NCERT line-by-line for Chemistry
- All diagrams from Physics chapters
- Sample papers with board marking scheme
