---
name: Java
slug: java
version: 1.0.1
description: Write robust Java avoiding null traps, equality bugs, and concurrency pitfalls.
metadata: {"clawdbot":{"emoji":"☕","requires":{"bins":["java","javac"]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| Topic | File |
|-------|------|
| Nulls, Optional, autoboxing | `nulls.md` |
| Collections and iteration traps | `collections.md` |
| Generics and type erasure | `generics.md` |
| Concurrency and synchronization | `concurrency.md` |
| Classes, inheritance, memory | `classes.md` |
| Streams and CompletableFuture | `streams.md` |
| Testing (JUnit, Mockito) | `testing.md` |
| JVM, GC, modules | `jvm.md` |

## Critical Rules

- `==` compares references, not content — always use `.equals()` for strings
- Override `equals()` must also override `hashCode()` — HashMap/HashSet break otherwise
- `Optional.get()` throws if empty — use `orElse()`, `orElseGet()`, or `ifPresent()`
- Modifying while iterating throws `ConcurrentModificationException` — use Iterator.remove()
- Type erasure: generic type info gone at runtime — can't do `new T()` or `instanceof List<String>`
- `volatile` ensures visibility, not atomicity — `count++` still needs synchronization
- Unboxing null throws NPE — `Integer i = null; int x = i;` crashes
- `Integer == Integer` uses reference for values outside -128 to 127 — use `.equals()`
- Try-with-resources auto-closes — implement `AutoCloseable`, Java 7+
- Inner classes hold reference to outer — use static nested class if not needed
- Streams are single-use — can't reuse after terminal operation
- `thenApply` vs `thenCompose` — compose for chaining CompletableFutures
- Records are implicitly final — can't extend, components are final
- `serialVersionUID` mismatch breaks deserialization — always declare explicitly
