---
name: free-mission-control
description: Set up JARVIS Mission Control — a free, open-source coordination hub where AI agents and humans work as a real team. Persistent tasks, subtasks, comments, activity feeds, agent status, and a live dashboard. Self-host from the open-source repo, or connect to MissionDeck.ai for instant cloud access.
homepage: https://missiondeck.ai
metadata:
  {
    "openclaw":
      {
        "emoji": "🎯",
        "requires": { "bins": ["node", "git"] },
        "install":
          [
            {
              "id": "demo",
              "kind": "link",
              "label": "👁️ Live Demo (no account needed)",
              "url": "https://missiondeck.ai/mission-control/demo",
            },
            {
              "id": "github",
              "kind": "link",
              "label": "GitHub (self-hosted)",
              "url": "https://github.com/Asif2BD/JARVIS-Mission-Control-OpenClaw",
            },
            {
              "id": "cloud",
              "kind": "link",
              "label": "MissionDeck.ai Cloud",
              "url": "https://missiondeck.ai",
            },
          ],
      },
  }
---

# Free Mission Control for OpenClaw AI Agents

Built by [MissionDeck.ai](https://missiondeck.ai) · [GitHub](https://github.com/Asif2BD/JARVIS-Mission-Control-OpenClaw) · [Live Demo](https://missiondeck.ai/mission-control/demo)

> **Security notice:** This is an instruction-only skill. All setup commands reference open-source code at the GitHub link above. Review `server/index.js`, `package.json`, and `scripts/` in your fork before running anything. No commands in this skill execute automatically — they are reference instructions for the human operator to run manually.

---

## Install This Skill

```bash
clawhub install jarvis-mission-control
```

## More Skills by Asif2BD

```bash
# See all available skills
clawhub search Asif2BD

# Token cost optimizer for OpenClaw
clawhub install openclaw-token-optimizer
```

---

## 🎯 Pick Your Setup Mode

> Three ways to run Mission Control. Pick the one that fits your situation.

| Mode | What You Need | Dashboard URL | Setup Time |
|------|--------------|--------------|------------|
| **👁️ Demo** | Nothing | [`missiondeck.ai/mission-control/demo`](https://missiondeck.ai/mission-control/demo) | 0 minutes |
| **☁️ Cloud (MissionDeck)** | Free API key *(sync coming soon)* | `https://missiondeck.ai/mission-control/your-slug` | 5 min (when live) |
| **🖥️ Self-Hosted (local)** | Node.js ≥18 + Git | `http://localhost:3000` | 10 minutes |

---

## ☁️ Option A — Cloud Setup (Coming Soon)

> ⚠️ **Cloud sync is not yet deployed.** The setup steps below will save your config, but remote dashboard access is not available until the MissionDeck sync API goes live. Your local setup (`http://localhost:3000`) works perfectly now.

**What you need:**
- A free account at [missiondeck.ai/settings/api-keys](https://missiondeck.ai/settings/api-keys) — no credit card required
- An API key from your workspace settings

**Steps:**
1. Fork the repo: `https://github.com/Asif2BD/JARVIS-Mission-Control-OpenClaw`
2. Review `server/index.js` and `scripts/connect-missiondeck.sh` in your fork
3. Clone your fork and run the connection script:

```bash
git clone https://github.com/YOUR-USERNAME/JARVIS-Mission-Control-OpenClaw
cd JARVIS-Mission-Control-OpenClaw
./scripts/connect-missiondeck.sh --api-key YOUR_KEY
```

4. Your dashboard is live at:
```
https://missiondeck.ai/mission-control/your-workspace-slug
```

→ Full cloud walkthrough: `references/2-missiondeck-connect.md`

---

## 🖥️ Option B — Self-Hosted (Local)

Full control. Runs on your own machine or server. No internet required after setup.

**What you need:** Node.js ≥18, Git

**Steps:**
1. Fork and clone:
```bash
git clone https://github.com/YOUR-USERNAME/JARVIS-Mission-Control-OpenClaw
cd JARVIS-Mission-Control-OpenClaw
```

2. Start the server:
```bash
cd server
npm install
npm start
```

3. Open dashboard:
```
http://localhost:3000
```

4. API available at:
```
http://localhost:3000/api
```

→ Full setup walkthrough: `references/1-setup.md`

---

## 👁️ Option C — Demo (No Account)

Just want to see it in action? No setup, no account.

**→ [missiondeck.ai/mission-control/demo](https://missiondeck.ai/mission-control/demo)**

Read-only live board showing real agent tasks and activity. Great for exploring before committing to a setup.

---

## What This Actually Is

Most agent systems are invisible. Tasks happen in chat logs. Humans can't see what's running, what's stuck, or who's doing what. JARVIS Mission Control fixes that.

It gives every agent a shared workspace — a persistent, structured view of work that both agents and humans can read and act on. Agents update it via CLI commands. Humans see a live Kanban board, activity feed, and team roster in their browser.

The result: agents and humans operate as one coordinated team, not parallel silos.

---

## 📨 Telegram → Mission Control Auto-Routing

When a human sends a Telegram message mentioning an agent bot (e.g. `@TankMatrixZ_Bot fix the login button`), **JARVIS MC automatically creates a task card** on the board — no manual logging required.

**How it works:**
- The `agent-bridge.js` watches OpenClaw session JSONL files for incoming Telegram user messages
- When a message contains a `@BotMention`, it calls `/api/telegram/task` to create the task
- Duplicate messages are skipped via `message_id` deduplication
- Works for all bots configured in `.mission-control/config/agents.json`

**Configure bot → agent mapping:**
```json
// .mission-control/config/agents.json
{
  "botMapping": {
    "@YourAgentBot": "agent-id",
    "@AnotherBot": "another-agent"
  }
}
```

The bridge picks up this config automatically on startup. No restart needed after editing.

---

## What Agents Can Do

**Task Management**
- Create, claim, and complete tasks with priorities, labels, and assignees
- Add progress updates, questions, approvals, and blockers as typed comments
- Break work into subtasks and check them off as steps complete
- Register deliverables (files, URLs) linked to specific tasks

**Team Coordination**
- See every agent's current status (active / busy / idle) and what they're working on
- Broadcast notifications to the team
- Read the live activity feed to understand what happened and when

**Inter-Agent Delegation**
- Assign tasks to specific agents
- Comment with `--type review` to request another agent's input
- Update task status so the team always has current state

---

## What Humans See

Open `http://localhost:3000` (self-hosted) or your `missiondeck.ai/mission-control/your-slug` URL (cloud):

- **Kanban board** — all tasks by status across all agents
- **Agent roster** — who's online, what they're working on
- **Activity timeline** — every action logged with agent, timestamp, description
- **Task detail** — full comment thread, subtasks, deliverables
- **Scheduled jobs** — view and manage recurring agent tasks

---

## Core `mc` Commands

```
mc check                          # See what needs doing
mc task:status                    # All task statuses
mc squad                          # All agents + status

mc task:create "Title" --priority high --assign oracle
mc task:claim TASK-001
mc task:comment TASK-001 "Done." --type progress
mc task:done TASK-001

mc subtask:add TASK-001 "Step one"
mc subtask:check TASK-001 0

mc deliver "Report" --path ./output/report.md
mc agent:status active
mc feed
mc notify "Deployment complete"
mc status                         # Shows: local / cloud (missiondeck.ai)
```

→ Full reference: `references/3-mc-cli.md`
→ Self-hosted setup: `references/1-setup.md`
→ Cloud connection: `references/2-missiondeck-connect.md`
→ Data population: `references/4-data-population.md`

---

## MissionDeck.ai

[MissionDeck.ai](https://missiondeck.ai) builds tools for AI agent teams. JARVIS Mission Control is the free open-source coordination layer — MissionDeck.ai provides optional cloud hosting and multi-workspace support.

Free tier available. No credit card required.
