---
name: Japanese
description: Write Japanese that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Japanese is technically correct but sounds off. Too polite. Too textbook. Too stiff. Natives write more casually, with particles, contractions, and personality. Match that.

## Formality Default

Default register is too high. Casual Japanese drops formality. Unless explicitly formal: lean casual. です/ます is not always needed. Plain form is normal among peers.

## Politeness Levels

Know when to use what:
- 丁寧語 (です/ます): strangers, work, safe default
- 普通形 (plain): friends, peers, casual internet
- タメ口: close friends, very casual
- Don't mix levels awkwardly within same conversation

## Sentence-Final Particles

Essential for natural Japanese:
- ね: seeking agreement, softening
- よ: asserting, informing
- な/なあ: self-reflection, male casual
- わ: soft assertion (traditionally feminine)
- ぞ/ぜ: strong assertion, masculine casual
- の/んだ: explanatory, seeking/giving context
- Missing these = robotic Japanese

## Contractions

Casual Japanese contracts:
- ている → てる
- ておく → とく
- てしまう → ちゃう/じゃう
- なければ → なきゃ
- では → じゃ
- のだ → んだ
- ら抜き: 食べれる instead of 食べられる (controversial but common)

## Fillers & Flow

Real Japanese has fillers:
- えーと, あのー, そのー
- まあ, なんか, ちょっと
- 一応, 的な, みたいな
- っていうか, つまり

## Expressiveness

Don't pick the safe word:
- いい → 最高, やばい, 神
- 悪い → 最悪, ひどい, クソ
- すごい → めっちゃ, 超, マジ
- 本当 → マジ, ガチ

## Internet/Youth Slang

Modern Japanese uses:
- w/草: laughter (wwww, 草)
- やばい: good or bad depending on context
- 神: amazing, god-tier
- エモい: emotional, aesthetic
- それな: "that's it", agreement
- り/りょ: りょうかい abbreviated

## Common Expressions

Natural expressions:
- 了解/りょ, おk
- マジで?, うそ!, え?
- なるほど, そうなんだ
- 微妙, びみょー
- めんどくさい → めんどい

## Reactions

React naturally:
- えー!, うそ!, マジ?
- すご!, やば!
- ウケる, 笑える
- きも, うざ (negative)
- かわいい!, いいね!

## Kanji vs Kana Balance

Too much kanji = stiff, formal. Casual writing uses more hiragana:
- 有難う → ありがとう
- 下さい → ください
- 出来る → できる
- Match the casual level with kana usage

## Gendered Speech

Be aware but don't overdo stereotypes:
- Masculine: 俺, だぜ, だな
- Feminine: 私/あたし, わ, かしら
- Neutral: 僕, plain forms
- Modern usage is more flexible

## The "Native Test"

Before sending: would a Japanese person screenshot this as "AI-generated"? If yes—too polite, missing particles, too stiff. Casualize.
