#!/usr/bin/env node

/**
 * Janee CLI
 * Secrets management for AI agents
 */

import { Command } from 'commander';
import { initCommand } from './commands/init';
import { addCommand } from './commands/add';
import { removeCommand } from './commands/remove';
import { serveCommand } from './commands/serve';
import { listCommand } from './commands/list';
import { logsCommand } from './commands/logs';
import { sessionsCommand } from './commands/sessions';
import { revokeCommand } from './commands/revoke';

const program = new Command();

program
  .name('janee')
  .description('Secrets management for AI agents')
  .version('0.1.0');

// Commands
program
  .command('init')
  .description('Initialize Janee configuration with example config')
  .action(initCommand);

program
  .command('add [service]')
  .description('Add a service to Janee (interactive if no args)')
  .option('-u, --url <url>', 'Base URL of the service')
  .option('-k, --key <key>', 'API key for the service')
  .action(addCommand);

program
  .command('remove <service>')
  .description('Remove a service from Janee')
  .action(removeCommand);

program
  .command('serve')
  .description('Start Janee MCP server')
  .action(serveCommand);

program
  .command('list')
  .description('List configured services')
  .action(listCommand);

program
  .command('logs')
  .description('View audit logs')
  .option('-f, --follow', 'Follow logs in real-time')
  .option('-n, --lines <count>', 'Number of recent logs to show', '20')
  .option('-s, --service <name>', 'Filter by service')
  .action(logsCommand);

program
  .command('sessions')
  .description('List active sessions')
  .action(sessionsCommand);

program
  .command('revoke <session>')
  .description('Revoke a session immediately')
  .action(revokeCommand);

program.parse();
