import { loadYAMLConfig, hasYAMLConfig } from '../config-yaml';

export async function listCommand(): Promise<void> {
  try {
    if (!hasYAMLConfig()) {
      console.log('No config found. Run `janee init` first.');
      process.exit(1);
    }

    const config = loadYAMLConfig();
    const serviceNames = Object.keys(config.services);
    const capabilityNames = Object.keys(config.capabilities);

    if (serviceNames.length === 0) {
      console.log('No services configured yet.');
      console.log('');
      console.log('Add a service:');
      console.log('  janee add');
      console.log('  or edit ~/.janee/config.yaml');
      return;
    }

    console.log('');
    console.log('Services:');
    for (const name of serviceNames) {
      const service = config.services[name];
      console.log(`  ${name}`);
      console.log(`    URL: ${service.baseUrl}`);
      console.log(`    Auth: ${service.auth.type}`);
    }

    console.log('');
    console.log('Capabilities:');
    if (capabilityNames.length === 0) {
      console.log('  (none configured)');
    } else {
      for (const name of capabilityNames) {
        const cap = config.capabilities[name];
        const rules = cap.rules ? ` [${cap.rules.allow?.length || 0} allow, ${cap.rules.deny?.length || 0} deny]` : '';
        console.log(`  ${name} → ${cap.service} (ttl: ${cap.ttl})${rules}`);
      }
    }
    console.log('');

  } catch (error) {
    if (error instanceof Error) {
      console.error('❌ Error:', error.message);
    } else {
      console.error('❌ Unknown error occurred');
    }
    process.exit(1);
  }
}
