# @true-and-useful/janee-openclaw

OpenClaw plugin for [Janee](https://github.com/rsdouglas/janee) — secure secrets management for AI agents.

## What This Does

This plugin gives your OpenClaw agent secure access to API credentials through Janee's MCP server. Instead of storing API keys directly in your agent config, Janee acts as a gatekeeper:

- 🔐 Keys stay encrypted in `~/.janee/`
- 📝 Every API call is logged with timestamp, service, endpoint, and reason
- 🚦 Future: LLM adjudication for sensitive operations (crypto trades, account changes, etc.)

## Installation

```bash
# Install Janee CLI globally
npm install -g janee

# Initialize Janee
janee init

# Add your API credentials (interactive)
janee add
# Or edit ~/.janee/config.yaml directly

# Install the plugin in OpenClaw
openclaw plugins install @true-and-useful/janee-openclaw
```

## Configuration

Enable the plugin in your agent config:

```json5
{
  agents: {
    list: [{
      id: "main",
      tools: { 
        allow: ["janee"]  // Enables janee_* tools
      }
    }]
  }
}
```

## Usage

The plugin exposes two tools to your agent:

### `janee_list_services`

Lists all configured services:

```typescript
await janee_list_services()
// Returns: ["stripe", "github", "bybit"]
```

### `janee_execute`

Makes API requests through Janee:

```typescript
await janee_execute({
  service: "stripe",
  method: "GET",
  path: "/v1/balance",
  reason: "User asked for account balance"
})

await janee_execute({
  service: "github", 
  method: "POST",
  path: "/repos/owner/repo/issues",
  body: JSON.stringify({ title: "Bug report", body: "..." }),
  reason: "Creating issue per user request"
})
```

## How It Works

```
Agent calls janee_execute
    ↓
OpenClaw Plugin (@true-and-useful/janee-openclaw)
    ↓ spawns & connects via MCP
Janee MCP Server (janee serve)
    ↓ decrypts key & makes HTTP call
Real API (Stripe, GitHub, etc.)
```

The plugin spawns `janee serve` as a subprocess and communicates via stdio (MCP is the only mode now). All requests are logged to `~/.janee/logs/YYYY-MM-DD.jsonl`.

## Monitoring

Watch requests in real-time:

```bash
janee logs -f
```

Review past requests:

```bash
janee logs --date 2026-02-03
```

## Security

- Keys encrypted at rest with AES-256-GCM
- Config files locked to user-only (chmod 0600)
- All API calls audited with timestamps and reasons
- Kill switch: `rm ~/.janee/config.json` disables all access

## Future Features (Phase 2)

- **LLM adjudication**: Janee can call an LLM to approve/deny sensitive operations
- **Rate limiting**: Prevent runaway API usage
- **Allowlists/blocklists**: Restrict which endpoints agents can access
- **Multi-user**: Support team deployments with shared policies

## Troubleshooting

**Plugin can't find janee:**
- Make sure `janee` is installed globally: `npm install -g janee`
- Check `which janee` returns a path

**Connection errors:**
- Try running `janee serve --mcp` manually to test
- Check `~/.janee/config.json` exists and has services configured

**Permission errors:**
- Config should be readable only by you: `ls -l ~/.janee/config.json`
- Should show `-rw-------` (0600 permissions)

## License

MIT — see [LICENSE](../../LICENSE) in the root repo.
