---
name: jadwal-sholat
version: 1.0.0
description: Ambil jadwal sholat (imsak, subuh, dzuhur, ashar, maghrib, isya) untuk kota/kabupaten di Indonesia dari API Muslim api.myquran.com (sumber Kemenag Bimas Islam). Gunakan saat user minta jadwal sholat hari ini / tanggal tertentu / 1 bulan untuk lokasi tertentu, atau butuh mencari ID kab/kota.
---

# Jadwal Sholat (api.myquran.com)

API base: `https://api.myquran.com/v3`

Script helper (rekomendasi): `scripts/myquran_sholat.py`

## Quick start

Cari lokasi (kab/kota):

```bash
python3 scripts/myquran_sholat.py cari "tangerang"
```

Jadwal sholat hari ini (Asia/Jakarta) untuk lokasi berdasarkan keyword:

```bash
python3 scripts/myquran_sholat.py hari-ini "kota tangerang"
```

Jadwal sholat tanggal tertentu (format `YYYY-MM-DD`):

```bash
python3 scripts/myquran_sholat.py tanggal "kota tangerang" 2026-02-03
```

Jadwal sholat 1 bulan (format `YYYY-MM`):

```bash
python3 scripts/myquran_sholat.py bulan "kota tangerang" 2026-02
```

## Catatan pemilihan lokasi

Endpoint pencarian mengembalikan beberapa kandidat. Script akan:
- mencoba match exact (case-insensitive) ke kolom `lokasi` bila memungkinkan
- kalau tidak, pakai hasil pertama

Kalau hasilnya kurang tepat, gunakan keyword yang lebih spesifik (mis. `KOTA TANGERANG` vs `TANGERANG`), atau ambil `id` lokasi lalu panggil mode `id`.

## Pemanggilan langsung via curl (tanpa script)

Cari kab/kota:

```bash
curl -s "https://api.myquran.com/v3/sholat/kabkota/cari/tangerang"
```

Ambil jadwal hari ini:

```bash
curl -s "https://api.myquran.com/v3/sholat/jadwal/<ID>/today?tz=Asia/Jakarta"
```

Ambil jadwal periode (bulanan / harian):

```bash
# bulanan
curl -s "https://api.myquran.com/v3/sholat/jadwal/<ID>/2026-02?tz=Asia/Jakarta"

# harian
curl -s "https://api.myquran.com/v3/sholat/jadwal/<ID>/2026-02-03?tz=Asia/Jakarta"
```
