# Wine — Italy

Italy produces more wine than any country. 350+ grape varieties, 20 regions, endless possibilities. Here's what you actually need to know.

## The Major Wine Regions

### Tuscany
| Wine | Grapes | Price Range | Notes |
|------|--------|-------------|-------|
| Chianti Classico | Sangiovese | €10-30 | Black rooster (Gallo Nero) label |
| Brunello di Montalcino | Sangiovese | €40-200+ | Age 5+ years, incredible |
| Vino Nobile di Montepulciano | Sangiovese | €15-40 | Between Chianti and Brunello |
| Super Tuscans | Cabernet/Merlot blends | €30-300+ | Sassicaia, Tignanello, Ornellaia |
| Vernaccia di San Gimignano | Vernaccia | €8-20 | Crisp white, drink young |

**Best Wineries to Visit:**
| Winery | Location | Appointment | Notes |
|--------|----------|-------------|-------|
| Antinori nel Chianti Classico | San Casciano | Required | Architecture masterpiece |
| Castello di Ama | Gaiole in Chianti | Required | Art + wine |
| Castello Banfi | Montalcino | Required | Brunello, beautiful estate |
| Avignonesi | Montepulciano | Required | Vino Nobile, vin santo |

### Piedmont
| Wine | Grapes | Price Range | Notes |
|------|--------|-------------|-------|
| Barolo | Nebbiolo | €30-500+ | "King of wines" — needs aging |
| Barbaresco | Nebbiolo | €25-200 | More approachable than Barolo |
| Barbera d'Asti | Barbera | €10-30 | Fruity, everyday drinking |
| Moscato d'Asti | Moscato | €8-15 | Sweet, sparkling, low alcohol |

**Best Wineries to Visit:**
| Winery | Location | Appointment | Notes |
|--------|----------|-------------|-------|
| Ceretto | Castiglione Falletto | Required | Modern architecture |
| Gaja | Barbaresco | Exclusive | If you can get in |
| Marchesi di Barolo | Barolo | Drop-in OK | Historic cellar |

### Veneto
| Wine | Grapes | Price Range | Notes |
|------|--------|-------------|-------|
| Prosecco | Glera | €8-25 | Sparkling, Valdobbiadene best |
| Amarone della Valpolicella | Corvina blend | €40-200+ | Dried grapes, intense |
| Valpolicella Ripasso | Corvina blend | €15-35 | "Baby Amarone" |
| Soave | Garganega | €8-20 | Light white |

**Best Wineries to Visit:**
| Winery | Location | Appointment | Notes |
|--------|----------|-------------|-------|
| Allegrini | Valpolicella | Required | Amarone excellence |
| Villa Sandi | Valdobbiadene | Required | Prosecco, beautiful villa |
| Bertani | Valpolicella | Required | Historic Amarone |

### Southern Italy

| Region | Wine | Notes |
|--------|------|-------|
| Campania | Taurasi (red), Fiano, Greco | Volcanic soils, unique character |
| Puglia | Primitivo, Negroamaro | Bold reds, great value |
| Sicily | Nero d'Avola, Etna Rosso, Marsala | Volcanic Etna wines are hot now |
| Sardinia | Vermentino, Cannonau | Cannonau = high antioxidants |

## Wine Classifications

| Label | Meaning | Quality |
|-------|---------|---------|
| **DOCG** | Denominazione di Origine Controllata e Garantita | Highest level, strict rules |
| **DOC** | Denominazione di Origine Controllata | Second level, regional rules |
| **IGT** | Indicazione Geografica Tipica | Flexible, includes Super Tuscans |
| **Vino** | Table wine | Basic, unregulated |

**Note:** IGT can be excellent — Super Tuscans use it because they break DOC rules (using French grapes).

## Price Expectations

### At Restaurants
| Quality | Price/Glass | Price/Bottle |
|---------|-------------|--------------|
| House wine | €3-5 | €10-18 |
| Good regional | €6-10 | €20-35 |
| Premium | €12-20 | €40-80 |
| Special occasion | €20+ | €80+ |

### At Wine Shops/Supermarkets
| Quality | Price |
|---------|-------|
| Everyday drinker | €5-10 |
| Good quality | €12-25 |
| Excellent | €30-60 |
| Collector | €80+ |

**Supermarket Secret:** Italian supermarkets (Esselunga, Coop, Conad) have EXCELLENT wine selections at fair prices. €8-15 gets you something great.

## Wine Tasting Experiences

### Tuscany

| Experience | Location | Cost | Duration |
|------------|----------|------|----------|
| Chianti bike + wine tour | From Florence | €80-120 | Full day |
| Brunello tasting in Montalcino | Montalcino | €25-50 | 2-3 hours |
| Private estate tour | Various | €50-150 | 2-4 hours |
| Cooking + wine class | Chianti | €100-180 | Half day |

### Piedmont

| Experience | Location | Cost | Duration |
|------------|----------|------|----------|
| Barolo cellar tour | Alba/Barolo | €30-60 | 2-3 hours |
| Truffle hunt + wine | Alba | €150-250 | Half day |
| Multiple winery tour | Langhe | €100-200 | Full day |

## What to Drink Where

| City | Local Wine | Why |
|------|------------|-----|
| Rome | Frascati, Cesanese | Lazio wines, very local |
| Florence | Chianti Classico | Obviously |
| Venice | Prosecco, Valpolicella | Veneto pride |
| Milan | Franciacorta | Italian champagne method |
| Naples | Lacryma Christi, Falanghina | Volcanic wines |
| Palermo | Nero d'Avola, Grillo | Sicilian character |

## Buying Wine to Bring Home

### Customs/Limits
- **EU to EU:** No limits
- **EU to US:** 1 liter duty-free, then taxes
- **Flying:** Pack in checked bag, wrap well

### Best Shops
| City | Shop | Notes |
|------|------|-------|
| Rome | Enoteca Costantini | Historic, huge selection |
| Florence | Enoteca Alessi | Since 1952, expertise |
| Milan | Enoteca Cotti | Premium selection |
| Naples | Enoteca Belledonne | Local focus |

### Shipping Home
- **Legal:** Yes, but expensive (~€30-50/bottle shipping)
- **Better:** Buy from wineries that ship internationally
- **Reality:** Most travelers check a bag with wine wrapped in clothes

## Wine Bar Culture

Enoteche (wine bars) serve by the glass with small plates.

| City | Enoteca | Specialty |
|------|---------|-----------|
| Rome | Il Goccetto | 900+ labels, standing room |
| Rome | Rimessa Roscioli | Attached to famous deli |
| Florence | Le Volpi e l'Uva | Piazza Santa Felicita, natural wines |
| Venice | Vino Vero | Natural wine focus, Fondamenta Misericordia |
| Milan | N'Ombra de Vin | Historic, 3000+ bottles |

## Quick Ordering Guide

| Italian | English |
|---------|---------|
| Vino rosso | Red wine |
| Vino bianco | White wine |
| Vino rosato | Rosé |
| Un bicchiere | A glass |
| Una bottiglia | A bottle |
| Mezzo litro | Half liter (carafe) |
| Vino della casa | House wine |
| Secco | Dry |
| Dolce | Sweet |
