# Venice — Italy

Floating labyrinth of 118 islands, 400 bridges, and zero cars. Expensive, crowded, and absolutely worth it if you escape the main drag.

## Bacari — Venice's Wine Bars

Bacari (bah-CAH-ree) are Venice's answer to Spanish tapas bars. Small plates called cicchetti (chi-KET-tee) + local wine (ombre).

### Top Bacari (Locals' Favorites)

| Bacaro | Address | Must-Order | Price | Notes |
|--------|---------|------------|-------|-------|
| Bar All'Arco | Calle de l'Ochialer, 436 | Baccalà mantecato | €1.50-3/piece | Most famous, opens 08:00 |
| Cantina do Mori | Sestiere San Polo, 429 | Polpette, local wines | €1.50-3/piece | Since 1462, oldest bacaro |
| Cantine del Vino già Schiavi | Fondamenta Nani, 992 | Cicchetti variety | €1.50-3/piece | Dorsoduro, by Squero gondola workshop |
| Osteria Al Squero | Sestiere Dorsoduro, 944 | Spritz + cicchetti | €1-2/piece | Views of gondola squero |
| Al Mercà | Campo Bella Vienna, 213 | Prosecco + snacks | €1-2/piece | Tiny, rialto fish market area |
| Cantina Do Spade | Calle de le Do Spade, 860 | Meatballs, sarde | €2-3/piece | Since 1488, near Rialto |
| Arcicchetti Bakaro | Campo dei Tolentini, 183/A | Gourmet toasts | €3-5 | Modern, student area |

### Cicchetti Vocabulary
| Term | What It Is |
|------|------------|
| Baccalà mantecato | Whipped salt cod spread |
| Sarde in saor | Sweet-sour sardines with onions, pine nuts |
| Polpette | Meatballs (various types) |
| Folpetti | Baby octopus |
| Mozzarella in carrozza | Fried mozzarella sandwich |
| Crostini | Toasted bread with toppings |

### How to Do a Bacari Crawl (Giro d'Ombre)
1. Start 18:00-19:00 at Rialto area
2. Order 1-2 cicchetti + 1 ombre (small wine) per stop
3. Stand at bar (sitting costs more)
4. Pay as you go (€5-8 per stop)
5. Move to next bacaro (4-5 stops = dinner)
6. End near Fondamenta della Misericordia for late drinks

## Beyond Cicchetti — Restaurants

| Restaurant | Address | Specialty | Price | Notes |
|------------|---------|-----------|-------|-------|
| Alle Testiere | Calle del Mondo Novo, 5801 | Seafood, small | €60-90 | 9 tables, reserve 1+ month |
| Antiche Carampane | Rio Terà de le Carampane, 1911 | Traditional Venetian | €40-60 | No pizza, no tourist menu |
| Osteria Bea Vita | Fondamenta Tolentini, 178/B | Local, cheap | €20-30 | University area, honest prices |
| Trattoria da Romano | Piazza Galuppi, 221 (Burano) | Risotto al go | €30-50 | On Burano island |

## Tourist Traps to AVOID 🚩

**RED FLAGS:**
- Any restaurant on Piazza San Marco (€8 for coffee, €25 for basic pasta)
- Menus with photos and "tourist menu" offers
- Waiters standing outside trying to seat you
- Pizza or sushi in Venice (wrong city for both)

**SPECIFIC PLACES TO AVOID:**
- Restaurants facing the Grand Canal near Rialto Bridge
- Most places on Lista di Spagna (train station street)
- "Gondolier's restaurants" near gondola stations

## Islands — The Non-Touristy Ones

### Burano
- **Famous for:** Colorful houses, lace, fish
- **Vaporetto:** #12 from Fondamente Nove, 40min
- **Why go:** Genuinely beautiful, great restaurants
- **When:** Morning (fewer crowds), have lunch there

### Murano
- **Famous for:** Glass-making
- **Vaporetto:** #4.1 or #4.2 from Fondamente Nove, 10min
- **Why go:** Watch glassblowers, buy quality pieces
- **Tip:** Factory tours are free (but sales pitch follows)

### Torcello
- **Famous for:** Ancient church, silence
- **Vaporetto:** #12 (past Burano), 50min total
- **Why go:** Where Venice started, nearly deserted, mystical
- **Must-see:** Santa Maria Assunta cathedral mosaics

### Sant'Erasmo
- **Famous for:** Farms, artichokes, wine
- **Vaporetto:** #13 from Fondamente Nove
- **Why go:** Locals' beach, zero tourists, actual farms
- **Bring:** Picnic supplies, bike, patience

### Lido
- **Famous for:** Beach, Film Festival
- **Vaporetto:** #1, #2, #5.1 from San Marco, 15min
- **Why go:** Actual sandy beach, rent bikes, chill
- **Tip:** August is crazy (locals' vacation). Go May/Sep

## Acqua Alta (High Water)

Venice floods. Usually October-February.

| Level | What Happens | What to Do |
|-------|--------------|------------|
| 80-100cm | Low areas flood (San Marco) | Elevated walkways appear |
| 100-120cm | 15% of city floods | Boots required, plan routes |
| 120cm+ | Serious flooding | Check tide app, stay in |

### Survival Kit
- **App:** Download "Hi!Tide Venice" — shows forecasts and which areas flood
- **Boots:** €10-15 from any souvenir shop (ugly but functional)
- **Timing:** Floods last 3-4 hours, plan activities accordingly
- **San Marco:** Floods first. If forecast >100cm, do it morning/evening

**Local Secret:** Most of Venice DOESN'T flood even at 120cm. Higher areas (Dorsoduro, Santa Croce) stay dry. Acqua alta is inconvenience, not disaster.

## Getting Around

| Method | Cost | Notes |
|--------|------|-------|
| Walking | Free | Only option. Get lost. It's the point. |
| Vaporetto | €9.50 single, €25/24h, €35/48h | Water buses, essential for islands |
| Traghetto | €2 | Gondola ferry across Grand Canal (standing) |
| Water Taxi | €70+ | Expensive but fast |
| Gondola | €80-100/30min | Tourist price, romantic but $$$ |

**Vaporetto Tip:** Buy multi-day pass if staying 2+ days and doing islands. Singles add up FAST.

### Traghetti (Local Secret)
Gondola ferries that cross Grand Canal at 7 points. €2 for 2-minute standing ride. Same as €80 gondola, 1/40th the price. 

**Locations:** Near Rialto Market, Ca' d'Oro, San Tomà, others. Look for "TRAGHETTO" signs.

## Practical

### Avoid
- Visiting on cruise ship days (check schedule online)
- Pigeon feeding (€500 fine)
- Sitting on steps eating (fines in main areas)
- Wheeled luggage on bridges (nightmarish)

### Day-Tripper Fee
- €5 entrance fee for day-trippers (2024+)
- Applies select peak days, 08:30-16:00
- Pre-book online or pay on arrival
- Staying overnight? Exempt (hotel provides code)

### Costs
- Vaporetto: €9.50 single (buy pass!)
- Coffee standing: €1.20-1.80
- Coffee Piazza San Marco: €6-12
- Cicchetti: €1.50-3 each
- Wine (ombre): €1.50-3
- Basic restaurant: €30-50/person
- Good restaurant: €50-90/person

## When to Visit

| Month | Weather | Crowds | Notes |
|-------|---------|--------|-------|
| Feb | 3-10°C | Moderate | CARNEVALE (crazy crowded 2 weeks) |
| Apr-May | 15-22°C | High | Perfect weather, peak prices |
| Jun-Aug | 25-30°C | Peak | Hot, humid, cruise ships |
| Sep-Oct | 18-24°C | Moderate | Best time (Oct has acqua alta risk) |
| Nov-Jan | 5-12°C | Low | Fog, acqua alta, but magical |

**Carnevale:** 2 weeks before Lent. Incredible masks, impossible crowds, triple prices. Worth experiencing once but book 6+ months ahead.

## Top 3 Mistakes Tourists Make

1. **Staying near train station** — Ugly, nothing to do. Stay Dorsoduro or San Polo
2. **Not getting lost** — Put the map away for 2 hours. Discover Venice.
3. **Eating near San Marco** — Walk 10 minutes in ANY direction for 50% lower prices, 200% better food
