# Transport — Italy

Italy has excellent trains, ferries, and public transit. Driving is an option but requires preparation.

## Trains

### High-Speed (Frecce & Italo)

| Route | Time | Price | Notes |
|-------|------|-------|-------|
| Rome-Florence | 1h30 | €25-50 | Frequent, book ahead for best prices |
| Rome-Naples | 1h10 | €20-45 | Fast, convenient |
| Rome-Venice | 3h45 | €45-80 | Direct, comfortable |
| Florence-Venice | 2h | €30-60 | Easy connection |
| Milan-Rome | 2h55 | €40-90 | Main north-south route |
| Milan-Florence | 1h40 | €30-60 | Business travelers |

### Booking Tips

| Tip | Details |
|-----|---------|
| Book early | Best prices 3-7 days ahead |
| Trenitalia vs Italo | Compare both, Italo often cheaper |
| Smart/Economy | Cheapest, non-refundable |
| Base/Comfort | Flexible, slight premium |
| Business/Prima | Wide seats, meals, lounge access |

### Regional Trains

| Use For | Details |
|---------|---------|
| Small towns | Only option to many destinations |
| Short hops | Florence-Siena, Rome-Orvieto |
| Budget | Cheaper than high-speed |
| Tickets | Buy at station, no reservation needed |

**Important:** Regional trains DON'T require reservations. Validate ticket before boarding (green machines on platform).

## ZTL — Zona Traffico Limitato (CRITICAL)

**What:** Historic city centers closed to traffic except residents
**Penalty:** €80-100+ fine per camera pass (you WILL be caught)
**Problem:** Fines arrive months later, rental car companies charge extra

### Which Cities Have ZTL

| City | ZTL Hours | Notes |
|------|-----------|-------|
| Rome | 06:30-18:00 Mon-Fri, 14:00-18:00 Sat | Complex zones |
| Florence | 07:30-20:00 Mon-Sat (summer extended) | Nearly entire center |
| Milan | Area C: 07:30-19:30 weekdays | Daily charge €5 |
| Siena | Always | Shell-shaped center is ZTL |
| Bologna | 07:00-20:00 | Historic center |
| Pisa | 08:00-20:00 | Around tower |

### How to Avoid ZTL Fines

1. **Don't drive into historic centers** — Park outside, walk in
2. **Check with hotel** — Many can register your plate temporarily
3. **Use ZTL maps** — ViaMichelin app shows zones
4. **Look for signs** — White circle with "ZTL" and hours

## Driving in Italy

### When to Drive

| Good For | Bad For |
|----------|---------|
| Tuscany countryside | Cities (any) |
| Sardinia | Amalfi Coast (terrifying roads, no parking) |
| Puglia | Venice (no cars, period) |
| Dolomites | Rome (nightmare) |
| Wine regions | Florence (ZTL + no parking) |

### Rental Tips

| Tip | Details |
|-----|---------|
| Book ahead | At least 1 week |
| Smallest car possible | Streets are NARROW |
| Manual transmission | Default, automatic costs more |
| Insurance | Get full coverage (Italy has high damage rates) |
| Pick up outside cities | Cheaper, easier |
| Gas | "Benzina" (unleaded) or "Gasolio" (diesel) |

### Highway Tolls (Autostrada)

| Route | Approximate Toll |
|-------|------------------|
| Rome-Florence | €18 |
| Milan-Venice | €23 |
| Rome-Naples | €15 |
| Florence-Bologna | €8 |

**Payment:** Cash, credit card, or Telepass (electronic). Keep ticket from entry.

### Speed Limits

| Road Type | Limit |
|-----------|-------|
| Autostrada (highway) | 130 km/h (110 in rain) |
| Main roads | 90 km/h |
| Urban areas | 50 km/h |

**Cameras everywhere.** Italian fines can follow you internationally.

## Ferries

### Main Routes

| Route | Operator | Time | Cost |
|-------|----------|------|------|
| Civitavecchia-Olbia (Sardinia) | Tirrenia, Grimaldi | 6-8h | €40-80 |
| Naples-Palermo (Sicily) | Tirrenia, GNV | 10h overnight | €50-100 |
| Naples-Capri | NLG, SNAV | 50min | €20-25 |
| Positano-Amalfi | Local ferry | 30min | €10 |
| Venice-Croatia | Various | 3-4h | €60-100 |

### Sardinia Ferry Tips

- **Book 2+ months ahead** in summer
- **Night ferry:** Get cabin, arrive refreshed
- **Car:** €80-150 extra each way
- **Compare:** Tirrenia, Moby, Grimaldi, Corsica Ferries

### Amalfi Coast Ferries

| Route | Time | Cost | Notes |
|-------|------|------|-------|
| Salerno-Amalfi | 35min | €8 | Good starting point |
| Amalfi-Positano | 25min | €10 | Avoid bus hairpins |
| Positano-Capri | 45min | €20 | Day trip option |

**Pro tip:** Ferries are often better than SITA buses on Amalfi — less nausea, better views.

## City Public Transit

### Rome

| Method | Cost | Notes |
|--------|------|-------|
| Single ticket | €1.50 | Valid 100 min (bus/metro) |
| 24h pass | €7 | Unlimited |
| 72h pass | €18 | Tourist option |
| Metro | 2 lines (A, B) | Covers main sights |
| Buses | Extensive | Night buses (N lines) |

### Milan

| Method | Cost | Notes |
|--------|------|-------|
| Single ticket | €2.20 | 90 min validity |
| 24h pass | €7.60 | Unlimited |
| Metro | 5 lines | Excellent coverage |

### Florence

| Method | Cost | Notes |
|--------|------|-------|
| Single ticket | €1.50 | 90 min |
| Center | Walk everything | Buses for Piazzale Michelangelo |

### Venice

| Method | Cost | Notes |
|--------|------|-------|
| Single vaporetto | €9.50 | One ride |
| 24h pass | €25 | Unlimited vaporetto |
| 48h pass | €35 | Better value |
| 72h pass | €45 | If doing islands |

**Venice transport is expensive.** Buy multi-day pass if staying 2+ days.

### Naples

| Method | Cost | Notes |
|--------|------|-------|
| Single ticket | €1.30 | 90 min (bus/metro/funicular) |
| Metro | Line 1 has art stations | Toledo is stunning |
| Circumvesuviana | Separate ticket | To Pompeii, Sorrento |

## Airport Transfers

### Rome

| Airport | To Center | Method | Cost |
|---------|-----------|--------|------|
| Fiumicino | Termini | Leonardo Express | €14 |
| Fiumicino | Termini | Bus | €6-8 |
| Fiumicino | Center | Taxi (fixed) | €50 |
| Ciampino | Termini | Bus | €6 |
| Ciampino | Center | Taxi (fixed) | €31 |

### Milan

| Airport | To Center | Method | Cost |
|---------|-----------|--------|------|
| Malpensa | Centrale | Malpensa Express | €13 |
| Malpensa | Centrale | Bus | €10 |
| Malpensa | Center | Taxi (fixed) | €105 |
| Linate | Center | Bus/metro | €5 |
| Bergamo | Centrale | Bus | €10 |

### Venice

| Airport | To Center | Method | Cost |
|---------|-----------|--------|------|
| Marco Polo | Piazzale Roma | Bus (ATVO) | €10 |
| Marco Polo | San Marco | Alilaguna boat | €15 |
| Marco Polo | Hotel | Water taxi | €120+ |

## Inter-City Summary

| Method | Best For | Book Via |
|--------|----------|----------|
| High-speed train | Major cities | Trenitalia, Italo |
| Regional train | Small towns | Buy at station |
| Bus | Where trains don't go | FlixBus |
| Ferry | Islands, coast | Direct ferry sites |
| Rental car | Countryside | AutoEurope, RentalCars |
| Domestic flight | Sicily, Sardinia if short on time | Ryanair, ITA |
