# Telecoms — Italy

How to stay connected: SIM cards, WiFi, and roaming.

## Options Overview

| Option | Best For | Pros | Cons |
|--------|----------|------|------|
| Italian SIM | Longer stays (5+ days) | Cheap data, local number | Requires passport, setup time |
| eSIM | Tech-savvy, quick trips | No physical card, instant | Requires compatible phone |
| Roaming | Short trips, EU visitors | Zero effort | Can be expensive (non-EU) |
| WiFi only | Budget, short stays | Free | Limited connectivity |

## Italian SIM Cards

### Where to Buy

| Provider | Where | Notes |
|----------|-------|-------|
| TIM | TIM stores, tabacchi | Largest network |
| Vodafone | Vodafone stores | Good coverage |
| WindTre | WindTre stores | Combined network |
| Iliad | Iliad corners, online | Cheap, newer |
| PosteMobile | Post offices | Budget option |

**Tabacchi:** Small tobacco shops sell SIM cards but activation may require store visit.

### What You Need

- **Passport** — Required for purchase (ID law)
- **€10-30** — SIM cost + first month
- **Unlocked phone** — Check before leaving home

### Tourist Plans (2024-2025)

| Provider | Plan | Data | Validity | Cost |
|----------|------|------|----------|------|
| TIM Tourist | 200GB | 30 days | €30 |
| Vodafone Holiday | 100GB | 14 days | €20 |
| WindTre Super Tourist | 100GB | 30 days | €20 |
| Iliad | 150GB | 30 days | €10 |

**Iliad:** Best value but smaller retail presence. Buy online or at dedicated corners.

### Setup Process

1. Go to provider store (morning = shorter lines)
2. Bring passport
3. Choose plan, pay
4. Staff will activate (10-20 min)
5. Insert SIM, may need to restart phone

## eSIM Options

### International eSIM Providers

| Provider | Coverage | Data | Cost | Notes |
|----------|----------|------|------|-------|
| Airalo | Italy/Europe | 5GB/30 days | €10 | Easy setup, popular |
| Holafly | Italy/Europe | Unlimited* | €19-47 | *Fair use limits apply |
| Nomad | Italy/Europe | 5GB/30 days | €9 | Good app |
| eSIM.me | Europe | Various | €10+ | Multiple options |

### How eSIM Works

1. **Buy online** — Before or during trip
2. **Scan QR code** — Or install via app
3. **Activate** — Usually instant
4. **Dual SIM** — Keep home number for calls/texts

### Compatible Phones

Most phones from 2020+ support eSIM:
- iPhone XS and later
- Google Pixel 3 and later
- Samsung Galaxy S20 and later
- Many others — check your model

## EU Roaming

### If You Have an EU SIM

**Roam Like at Home** applies — use your home data/minutes in Italy at no extra cost (within limits).

| Country | Status |
|---------|--------|
| All EU countries | Free roaming |
| UK (post-Brexit) | Some carriers charge |
| Switzerland | Not EU, usually charged |

### Non-EU Visitors (US, UK post-Brexit, etc.)

| Option | Typical Cost | Notes |
|--------|--------------|-------|
| AT&T International Day Pass | $10/day | Easy but adds up |
| T-Mobile Magenta | Free slow data | Fast data costs more |
| Verizon TravelPass | $10/day | Similar to AT&T |
| Google Fi | Included | Good international option |

**Recommendation:** Italian SIM or eSIM is usually cheaper for 5+ day trips.

## WiFi Availability

### Where to Find Free WiFi

| Location | Quality | Notes |
|----------|---------|-------|
| Hotels/B&Bs | Usually good | Ask for password |
| Restaurants | Variable | Often requires purchase |
| Cafés | Good in cities | Buy a coffee |
| Train stations | Limited | Trenitalia has some |
| Museums | Rare | Don't count on it |
| Public squares | Some cities | Rome, Florence have zones |

### WiFi Quality by Location

| Area | Quality |
|------|---------|
| Major cities | Good |
| Small towns | Hit or miss |
| Countryside/agriturismos | Often weak |
| Mountains | Very limited |
| Trains | High-speed trains have WiFi |

## Practical Tips

### Phone Setup Before Leaving

1. **Check unlock status** — Contact carrier if locked
2. **Download offline content** — Maps, translation, guides
3. **Enable WiFi calling** — Backup for poor signal
4. **Backup data** — Photos, contacts
5. **Note IMEI** — For insurance/police report if stolen

### Staying Connected

| Need | Solution |
|------|----------|
| Navigation | Download Google Maps offline |
| Translation | Download Italian in Google Translate |
| Reservations | Screenshot confirmations |
| Emergency calls | 112 works without SIM |

### Data Usage Tips

| Action | Typical Data |
|--------|--------------|
| GPS navigation | 5-10 MB/hour |
| Social media scrolling | 50-100 MB/hour |
| Video streaming | 1-3 GB/hour |
| Email/messaging | Minimal |
| VoIP calls | 30-60 MB/hour |

### Battery Life

GPS and data use drain batteries fast. Bring:
- Portable battery pack (10000+ mAh)
- European plug adapter (Type C/L)
- Car charger if driving

## Calling & Messaging

### Country Code

| Calling To | Prefix |
|------------|--------|
| Italy from abroad | +39 |
| Abroad from Italy | +[country code] |
| Local calls | Full number with area code |

**Italian numbers:** Keep the leading 0 when calling locally.

### WhatsApp is Standard

Italians use WhatsApp for everything:
- Personal messaging
- Business communication
- Restaurant reservations sometimes
- Group coordination

**Download it before you go.** SMS is not commonly used.

### Emergency Numbers

| Service | Number |
|---------|--------|
| General emergency | 112 |
| Police (Carabinieri) | 112 |
| Fire | 115 |
| Ambulance | 118 |
| Coast Guard | 1530 |

All work without a SIM card.

## Summary: What to Do

### Short Trip (1-4 days)
- Use roaming (if reasonable) or eSIM
- Download offline maps
- Rely on WiFi where possible

### Longer Trip (5+ days)
- Buy Italian SIM (TIM, Iliad best value)
- Get eSIM if your phone supports it
- €15-30 gets plenty of data

### Remote/Countryside Trip
- Get Italian SIM with good coverage (TIM best)
- Download everything offline
- Don't rely on WiFi
