# Itineraries — Italy

Sample routes for different trip lengths and styles. All can be customized.

## First-Timer: 7 Days — Classic Triangle

The essential Italy intro: Rome, Florence, Venice.

| Day | Location | Highlights |
|-----|----------|------------|
| 1-2 | Rome | Colosseum, Forum, Trastevere dinner |
| 3 | Rome | Vatican AM, Pantheon, Campo de' Fiori |
| 4-5 | Florence | Train AM, Duomo, Uffizi, aperitivo |
| 5 | Florence | San Lorenzo market, Accademia OR day trip |
| 6 | Venice | Train AM, get lost, bacari crawl |
| 7 | Venice | Islands (Burano/Murano) OR more exploration |

**Transport:** High-speed trains (Rome-Florence 1.5h, Florence-Venice 2h)
**Book Ahead:** Colosseum, Vatican, Uffizi tickets

## First-Timer: 10 Days — Classic + Coast

| Day | Location | Highlights |
|-----|----------|------------|
| 1-3 | Rome | Full Rome experience |
| 4 | Naples | Train AM, pizza, Centro Storico |
| 5 | Pompeii/Amalfi | Day trip or move to coast |
| 6 | Amalfi Coast | Positano, Ravello, or Path of Gods |
| 7-8 | Florence | Art, food, wine |
| 9-10 | Venice | Canals, islands, cicchetti |

**Alternative:** Skip Naples, add 2 days in Tuscany countryside

## 14 Days — Northern Italy Deep Dive

For repeat visitors or those who want depth over breadth.

| Day | Location | Highlights |
|-----|----------|------------|
| 1-2 | Milan | Design, Duomo, Navigli |
| 3 | Lake Como | Bellagio or Varenna day trip |
| 4-5 | Verona/Valpolicella | Arena, wine tasting |
| 6-7 | Venice | Full Venice experience |
| 8 | Dolomites | Drive/train to mountains |
| 9-10 | Dolomites | Hiking, rifugi, views |
| 11-12 | Bologna | Food paradise, porticos |
| 13 | Parma | Parmesan, prosciutto, opera house |
| 14 | Milan | Flight home |

**Best For:** Food lovers, mountain seekers, design enthusiasts

## 14 Days — Southern Italy

| Day | Location | Highlights |
|-----|----------|------------|
| 1-2 | Naples | Pizza, chaos, archaeology museum |
| 3 | Pompeii/Herculaneum | Ancient ruins |
| 4-5 | Amalfi Coast | Positano, Ravello, Path of Gods |
| 6-7 | Matera | Cave hotels, sassi |
| 8-10 | Puglia | Alberobello trulli, Lecce baroque, beaches |
| 11-14 | Sicily | Palermo, Catania, Taormina, Etna |

**Transport:** Mix of trains, buses, ferries. Consider car for Puglia.

## Food-Focused: 10 Days

| Day | Location | Food Highlight |
|-----|----------|----------------|
| 1-2 | Bologna | Tortellini, ragù, mortadella, markets |
| 3 | Modena | Balsamic vinegar visit, Osteria Francescana |
| 4 | Parma | Parmigiano factory, prosciutto, lunch |
| 5-6 | Rome | Roman pastas, supplì, markets |
| 7-8 | Naples | Pizza pilgrimage, sfogliatella |
| 9-10 | Amalfi/Sorrento | Seafood, limoncello, cooking class |

**Book:** Osteria Francescana (Modena) 3+ months ahead

## Wine Trip: 7 Days

| Day | Location | Wine Focus |
|-----|----------|------------|
| 1-2 | Piedmont | Barolo, Barbaresco, truffle season |
| 3 | Franciacorta | Italian champagne method |
| 4-5 | Tuscany | Chianti, Brunello, Super Tuscans |
| 6-7 | Umbria | Sagrantino, black truffles |

**Best Time:** September-November (harvest, truffles)
**Transport:** Car essential for winery hopping

## Beach & Relaxation: 10 Days

| Day | Location | Beach Highlight |
|-----|----------|-----------------|
| 1-2 | Rome | Arrival, minimal sightseeing |
| 3-4 | Amalfi | Positano beaches, boat trip |
| 5-6 | Puglia | Salento beaches, trulli |
| 7-10 | Sardinia | Costa Smeralda or south beaches |

**Alternative Route:** 
- Days 1-3: Cinque Terre
- Days 4-6: Elba Island
- Days 7-10: Sardinia

## Romantic: 7 Days

| Day | Location | Romance Factor |
|-----|----------|----------------|
| 1-2 | Venice | Gondola sunset, candlelit dinner |
| 3-4 | Amalfi Coast | Ravello gardens, clifftop hotel |
| 5-6 | Tuscan Villa | Agriturismo, wine, sunrise |
| 7 | Florence | Ponte Vecchio, last dinner |

**Splurge:** Belmond Hotel Caruso (Ravello), Belmond Villa San Michele (Florence)

## Family-Friendly: 10 Days

| Day | Location | Kid-Friendly |
|-----|----------|--------------|
| 1-2 | Rome | Colosseum (gladiator tour), gelato hunt |
| 3 | Pompeii | Ancient ruins, volcano |
| 4-5 | Amalfi/Sorrento | Beaches, boat trips, limoncello farm |
| 6-7 | Florence | Climbing Duomo, Piazzale views, gelato |
| 8-9 | Venice | Gondola, glass blowing, getting lost |
| 10 | Venice | Burano colors, beach day at Lido |

See also: with-kids.md

## Off-the-Beaten-Path: 14 Days

| Day | Location | Why |
|-----|----------|-----|
| 1-2 | Turin | Coffee culture, Egyptian museum, aperitivo |
| 3 | Langhe | Truffle hunt, Barolo |
| 4-5 | Genoa | Underrated, old town, pesto |
| 6-7 | Le Marche | Urbino, Conero beaches |
| 8-9 | Umbria | Orvieto, Spoleto, no crowds |
| 10-11 | Matera | Cave city, UNESCO |
| 12-14 | Calabria | Tropea, wild beaches, 'nduja |

## Practical Tips for Any Itinerary

### Don't Over-Plan
- **2-3 nights minimum** per city
- **Moving daily is exhausting** — Build in rest
- **Less is more** — See fewer places better

### Transport Between Cities

| Route | Best Option | Time | Cost |
|-------|-------------|------|------|
| Rome-Florence | Frecce train | 1.5h | €25-50 |
| Florence-Venice | Frecce train | 2h | €30-60 |
| Rome-Naples | Frecce train | 1h10 | €20-45 |
| Naples-Amalfi | SITA bus or ferry | 1.5-2h | €5-20 |
| Milan-Lake Como | Train | 40min | €5-10 |
| Any-Sardinia | Ferry overnight | 8-12h | €50-120 |

### What to Book Ahead

| Item | How Far Ahead |
|------|---------------|
| Vatican/Colosseum/Uffizi | 2+ weeks |
| High-speed trains | 1-2 weeks (for best prices) |
| Popular restaurants | 2-4 weeks |
| Agriturismos (peak) | 1-2 months |
| Amalfi hotels (summer) | 3+ months |

### Pacing Guide

| Trip Length | Max Cities |
|-------------|------------|
| 7 days | 3 cities |
| 10 days | 4-5 locations |
| 14 days | 5-6 locations |
| 3 weeks | 7-8 locations |

**Golden rule:** If you're packing more than every 2-3 days, you're moving too much.
