# Food Guide — Italy

Regional Italian cuisine varies dramatically. What's authentic in Rome is wrong in Milan. This guide covers what to eat WHERE.

## Regional Specialties — What to Order Where

### Northern Italy

| Region | Signature Dishes | Key Ingredient |
|--------|------------------|----------------|
| **Piedmont** | Vitello tonnato, bagna cauda, tajarin | White truffles (Oct-Dec) |
| **Lombardy** | Risotto alla milanese, cotoletta, ossobuco | Saffron, butter |
| **Veneto** | Risotto al nero, baccalà, fegato | Seafood, polenta |
| **Emilia-Romagna** | Tortellini, tagliatelle al ragù, mortadella | Parmigiano, prosciutto |
| **Liguria** | Pesto genovese, focaccia, trofie | Basil, pine nuts |

### Central Italy

| Region | Signature Dishes | Key Ingredient |
|--------|------------------|----------------|
| **Tuscany** | Bistecca fiorentina, ribollita, pici | Chianina beef, beans |
| **Lazio (Rome)** | Carbonara, cacio e pepe, amatriciana | Pecorino, guanciale |
| **Umbria** | Tartufi neri, strangozzi, porchetta | Black truffles |
| **Le Marche** | Olive ascolane, brodetto, vincisgrassi | Stuffed olives |

### Southern Italy

| Region | Signature Dishes | Key Ingredient |
|--------|------------------|----------------|
| **Campania** | Pizza, sfogliatella, limoncello | San Marzano tomatoes |
| **Puglia** | Orecchiette, burrata, focaccia barese | Olive oil, burrata |
| **Calabria** | 'Nduja, soppressata, fileja | Spicy peppers |
| **Sicily** | Arancini, pasta con le sarde, cannoli | Seafood, almonds |
| **Sardinia** | Culurgiones, porceddu, seadas | Lamb, pecorino sardo |

## The "Big 4" Roman Pastas

All use **guanciale** (cured pork cheek) and **pecorino romano** — NOT pancetta, NOT parmesan.

| Pasta | Ingredients | What to Expect |
|-------|-------------|----------------|
| **Carbonara** | Guanciale, egg, pecorino, black pepper | Creamy (NO cream), silky |
| **Cacio e Pepe** | Pecorino, black pepper, pasta water | Deceptively simple, hard to perfect |
| **Amatriciana** | Guanciale, tomato, pecorino, chili | Slightly spicy, tomato-forward |
| **Gricia** | Guanciale, pecorino | "White amatriciana" — the original |

**Where to Eat Them:**
- **Da Enzo al 29** (Rome, Trastevere) — All four, excellent
- **Felice a Testaccio** (Rome, Testaccio) — Famous cacio e pepe
- **Da Cesare al Casaletto** (Rome, Monteverde) — Best carbonara

## Bistecca alla Fiorentina

Giant T-bone from Chianina cattle. Served bloody rare. Non-negotiable.

| Detail | Standard |
|--------|----------|
| Weight | 1-1.5kg (for 2-3 people) |
| Cooking | Rare to medium-rare ONLY |
| Price | €45-55/kg |
| Sides | White beans, roasted potatoes |
| Wine | Chianti Classico or Brunello |

**Where to Eat:**
| Restaurant | City | Price/kg | Notes |
|------------|------|----------|-------|
| Buca Mario | Florence | €50 | Traditional, since 1886 |
| Trattoria Sostanza | Florence | €55 | Tiny, iconic |
| Perseus | Florence | €45 | Local favorite |
| All'Antico Ristoro di Cambi | Florence | €48 | Oltrarno, authentic |

## Street Food by City

### Naples
| Food | What It Is | Price | Where |
|------|------------|-------|-------|
| Pizza fritta | Deep-fried stuffed pizza | €2-4 | Di Matteo, Via Tribunali |
| Cuoppo | Fried seafood cone | €5-8 | Friggitoria Vomero |
| Sfogliatella | Layered pastry, ricotta | €2-3 | Attanasio (station area) |

### Rome
| Food | What It Is | Price | Where |
|------|------------|-------|-------|
| Supplì | Fried rice ball, mozzarella center | €1.50-2.50 | Supplì Roma, Via San Francesco a Ripa |
| Pizza al taglio | Pizza by weight | €3-8 | Bonci Pizzarium, Via della Meloria |
| Trapizzino | Pizza pocket with fillings | €4-5 | Trapizzino, Trastevere |

### Sicily
| Food | What It Is | Price | Where |
|------|------------|-------|-------|
| Arancini | Fried rice balls | €2-4 | Everywhere, try Ke Palle (Palermo) |
| Granita con brioche | Iced slush + sweet bread | €3-5 | Morning breakfast tradition |
| Cannoli | Fried tube, ricotta filling | €2-4 | Maria Grammatico (Erice) |

### Venice
| Food | What It Is | Price | Where |
|------|------------|-------|-------|
| Cicchetti | Small bites (see Venice guide) | €1.50-3 | Bacari everywhere |
| Tramezzini | Triangular sandwiches | €2-3 | Rosa Salva, various locations |
| Frittelle | Carnival doughnuts (Feb) | €1-2 | Any pasticceria during Carnevale |

## Coffee Culture

### Types
| Order | What You Get |
|-------|--------------|
| Caffè / Espresso | Standard shot |
| Caffè macchiato | Espresso + drop of milk |
| Caffè lungo | Longer, more water |
| Caffè ristretto | Shorter, more intense |
| Cappuccino | Espresso + steamed milk + foam |
| Caffè latte | More milk than cappuccino |
| Caffè corretto | Espresso "corrected" with grappa |

### Rules
- **Cappuccino:** Morning only (before 11:00). After meals = tourist move
- **Standing:** €1-1.50 at bar. **Sitting:** €3-5 at table
- **Ordering:** Say what you want, drink it, pay at register
- **No to-go:** Italians don't understand this concept

### Best Coffee Cities
1. **Naples** — Strongest, sweetest, cheapest
2. **Trieste** — Austrian influence, unique culture
3. **Turin** — Bicerin (espresso + chocolate + cream)

## Aperitivo Culture

Pre-dinner drinks (18:00-21:00) with included snacks/buffet.

### Classic Aperitivo Drinks
| Drink | What It Is | When |
|-------|------------|------|
| Spritz (Aperol) | Aperol + prosecco + soda | Everywhere, always |
| Spritz (Select) | Venice original, more bitter | Venice |
| Negroni | Gin + Campari + vermouth | Sophisticated |
| Negroni Sbagliato | Prosecco instead of gin | Lighter |
| Americano | Campari + vermouth + soda | Classic |

### Where
- **Milan** — Navigli district, best aperitivo scene
- **Rome** — Trastevere (Freni e Frizioni)
- **Venice** — Campo Santa Margherita
- **Turin** — Piazza Vittorio Veneto

## Price Guide

| Meal Type | Budget | Mid-Range | Splurge |
|-----------|--------|-----------|---------|
| Coffee | €1 | €1.50 | €3-4 (seated) |
| Pizza | €6-8 | €10-14 | €15-20 |
| Pasta main | €10-14 | €15-20 | €25+ |
| Meat/fish main | €15-20 | €22-30 | €35+ |
| Full dinner (no wine) | €20-30 | €35-50 | €60-100 |
| Tasting menu | N/A | €50-70 | €100-200+ |

## Mistakes to Avoid

| Mistake | Why It's Wrong | What to Do |
|---------|----------------|------------|
| Ordering chicken with pasta | Doesn't exist in Italy | Chicken is secondo, separate course |
| Asking for Alfredo sauce | American invention | Order cacio e pepe or butter pasta |
| Bread before meal | Italians eat it WITH food | Wait for your plate |
| Parmesan on fish pasta | Culinary sin | Only pecorino on Roman pastas |
| Cappuccino after dinner | Marks you as tourist | Espresso or digestivo |
| Tipping 15-20% | Over-tipping | Round up or €1-2 max |
