# Florence — Italy

Renaissance capital, art overload, and Tuscany's gateway. Compact, walkable, and surprisingly manageable once you know the tricks.

## Best Gelato in Florence

### Top Tier (Artigianale Quality)

| Gelateria | Address | Must-Try Flavor | Price | Notes |
|-----------|---------|-----------------|-------|-------|
| Vivoli | Via Isola delle Stinche, 7r | Crema, Buontalenti | €3-6 | Since 1930, near Santa Croce |
| Gelateria dei Neri | Via dei Neri, 9/11R | Stracciatella, pistachio | €3-5 | 4.7★, also great coffee |
| Gelateria Santa Trinita | Piazza de' Frescobaldi, 11/12R | Black sesame, ricotta fig | €3-6 | Eat on Ponte Santa Trinita |
| Gelateria La Carraia | Piazza Nazario Sauro, 25r | Mousse flavors | €2-4 | Huge portions, cheap |
| Perché No! | Via dei Tavolini, 19r | Crema buontalenti | €3-5 | Historic center, since 1939 |
| Gelateria della Passera | Via Toscanella, 15r | Seasonal flavors | €3-5 | Oltrarno, less touristy |

### How to Spot REAL Gelato
- **Colors:** Natural, muted (grey pistachio, not neon green)
- **Display:** Stored in covered metal tins (pozzetti), not piled high
- **List:** Fewer flavors = more artisanal (they make fresh)
- **Price:** €2.50-6 is normal; super cheap may mean commercial

### RED FLAGS 🚩
- Pistachio that's bright green (should be brownish-grey)
- Fruit flavors that are neon colored
- Gelato piled in huge mountains (air pumped in)
- "Grom" chain — OK but not special

## Uffizi Gallery Strategy

| Hack | Details |
|------|---------|
| Tickets | €25 online (mandatory reservation in peak season) |
| Best Time | 08:15 opening OR 15:00+ (afternoon lull) |
| Best Day | Tuesday-Thursday |
| Duration | 2-3 hours (don't try to see everything) |
| Must-See | Botticelli rooms (10-14), Caravaggio, Leonardo |
| Skip | North corridor (temporary exhibits) unless passionate |
| Audio | €6, not essential — labels are in English |

**Local Secret:** Uffizi is included in Firenze Card (€85/72h) — only worth it if doing 3+ museums. Otherwise, book Uffizi separately.

### Other Major Museums

| Museum | Tickets | Why Visit | Skip If... |
|--------|---------|-----------|------------|
| Accademia | €16 | Michelangelo's David | You've seen it in photos (that's 80% of it) |
| Palazzo Pitti | €16 | Royal apartments, gardens | You're museum-fatigued |
| Bargello | €9 | Donatello, sculpture | Not into sculpture |
| San Marco | €8 | Fra Angelico frescoes, cells | In a hurry |

**David Alternative:** There's a FULL-SIZE replica in Piazza della Signoria. Free. If you're tight on time, honestly it's almost as impressive.

## Where to Eat

### Trattorias & Local Spots

| Restaurant | Address | Specialty | Price | Notes |
|------------|---------|-----------|-------|-------|
| Trattoria Mario | Via Rosina, 2 | Ribollita, shared tables | €12-20 | Cash only, no reservations, go 12:00 |
| Buca Mario | Piazza degli Ottaviani, 16r | Bistecca alla fiorentina | €40-60 | Since 1886, institution |
| Il Latini | Via dei Palchetti, 6r | Tuscan classics | €35-50 | Touristy but actually good |
| Da Nerbone | Mercato Centrale (inside) | Lampredotto sandwich | €4-6 | Market food, standing only |
| Trattoria Sostanza | Via del Porcellana, 25r | Butter artichokes, chicken | €30-45 | Tiny, reserve weeks ahead |

### Mercato Centrale
- **Ground Floor** — Traditional vendors, buy ingredients
- **Upper Floor** — Food hall, €8-15 plates, great variety
- **Best:** Lampredotto at Nerbone, truffle pasta at Lorenzo

### Lampredotto (Local Street Food)
Tripe sandwich. Sounds scary. Actually delicious.
- **Where:** Food trucks (trippaio) around Sant'Ambrogio market, or Nerbone
- **Order:** "Lampredotto con salsa verde"
- **Price:** €4-5
- **Dare:** You'll either love it or have a story

## Artisan Workshops (Still Operating!)

| Workshop | Specialty | Address | Experience |
|----------|-----------|---------|------------|
| Scuola del Cuoio | Leather goods | Santa Croce complex | Watch craftsmen, buy quality leather |
| Officina Profumo-Farmaceutica di Santa Maria Novella | Perfume, skincare | Via della Scala, 16 | Oldest pharmacy in world (1221), stunning interior |
| Alberto Cozzi | Marbled paper | Via del Parione, 35r | Hand-marbled papers, bound books |
| Stefano Bemer | Bespoke shoes | Via San Niccolò, 2 | €2000+ shoes, can watch craftsmen |

**Santa Maria Novella Note:** Go even if not buying — the interior is museum-worthy. Free to enter.

## Beyond the Center

### Oltrarno
- Across Ponte Vecchio, working-class artisan district
- Best: Piazza Santo Spirito (aperitivo), San Frediano (trattorias)
- Evening scene: Bars around Santo Spirito square

### San Lorenzo Market
- **Leather market** — Outdoor stalls. Negotiate 30-40% off starting price
- **Quality:** Mixed. Check stitching, smell (real leather has distinct smell)
- **Skip:** Anything that looks too cheap to be real

### Piazzale Michelangelo
- Best views of Florence, free
- Go at sunset (crowded but worth it)
- Walk up from Ponte alle Grazie (20 min uphill)

## Day Trips from Florence

| Destination | Transport | Time | Why Go |
|-------------|-----------|------|--------|
| Siena | Bus (€8) or train | 1.5h | Medieval center, Palio culture |
| San Gimignano | Bus (€7) | 1.5h | Towers, white vernaccia wine |
| Lucca | Train (€8) | 1.5h | Bike the walls, less crowded |
| Pisa | Train (€9) | 1h | Leaning Tower (worth 2-3h max) |
| Chianti | Car or tour | 30-60min | Wine tasting, countryside |

**Pisa Reality Check:** The tower is amazing for 30 minutes. Then you've seen it. Combine with Lucca for a full day.

## Practical

### Getting Around
- **Walk** — Everything is within 20 minutes
- **No cars** — ZTL covers entire center, massive fines
- **Bikes** — Flat city, rentals available, but cobblestones are rough
- **Buses** — Only needed for Piazzale Michelangelo or outskirts

### Money
- Coffee: €1-1.50 standing
- Gelato: €3-6
- Pasta main: €12-16
- Bistecca (per kg): €45-55
- Glass Chianti: €5-10

### Tourist Tax
- €4-6/night depending on hotel rating
- Paid separately at hotel checkout

## When to Visit

| Month | Weather | Crowds | Notes |
|-------|---------|--------|-------|
| Apr-May | 15-24°C | High | Beautiful but busy |
| Jun-Aug | 28-36°C | Peak | Very hot, very crowded |
| Sep-Oct | 18-26°C | Moderate | Best time overall |
| Nov-Mar | 5-12°C | Low | Cold, rainy but atmospheric |

**Avoid:** Easter week, first 3 weeks of August (unbearably crowded/hot)

## Top 3 Mistakes Tourists Make

1. **Cappuccino after 11:00** — Order espresso, you'll blend in
2. **Sitting down without checking price** — Standing €1, seated €3-4
3. **Skipping Oltrarno** — Best food and artisans, fewest tourists
