# Emergencies — Italy

Emergency numbers, healthcare, pharmacies, and what to do when things go wrong.

## Emergency Numbers

| Service | Number | Notes |
|---------|--------|-------|
| **General Emergency** | **112** | Works for everything, connects to appropriate service |
| Police (Carabinieri) | 112 | Military police, most common |
| Police (Polizia di Stato) | 113 | State police |
| Fire (Vigili del Fuoco) | 115 | Fire and rescue |
| Ambulance | 118 | Medical emergencies |
| Coast Guard | 1530 | Maritime emergencies |
| Road Assistance (ACI) | 116 | Breakdown service |
| Forest/Mountain Rescue | 1515 | Hiking emergencies |

**112 works from any phone, even without a SIM card.**

## Healthcare System

### EHIC/GHIC (EU Citizens)

| Card | Coverage | Notes |
|------|----------|-------|
| EHIC | Emergency/necessary care | Older cards still valid |
| GHIC | UK replacement for EHIC | Same coverage |

**Bring your card.** It doesn't cover repatriation or non-emergency care.

### Travel Insurance (Everyone)

**Essential for non-EU visitors.** Italian healthcare is excellent but expensive without coverage.

| Should Cover | Amount |
|--------------|--------|
| Medical expenses | €500,000+ |
| Repatriation | Included |
| Trip cancellation | Optional |
| Baggage | Optional |

**Good providers:** World Nomads, Allianz, SafetyWing

### Where to Go

| Situation | Go To | Italian Term |
|-----------|-------|--------------|
| Life-threatening | Emergency room | Pronto Soccorso |
| Urgent but not critical | Doctor/Clinic | Guardia Medica (after-hours) |
| Minor issue | Pharmacy | Farmacia |
| Prescription refill | Pharmacy | Farmacia |

### Emergency Room (Pronto Soccorso)

| Reality | Details |
|---------|---------|
| Triage system | Color-coded by severity |
| Wait times | Can be long for non-urgent |
| Cost | Free for emergencies (even non-EU) |
| Language | Major hospitals have English speakers |

**Location tip:** Google "Pronto Soccorso near me" or ask your hotel.

## Pharmacies (Farmacie)

### Finding a Pharmacy

| Sign | Meaning |
|------|---------|
| Green cross | Pharmacy |
| Cross lit up | Open |
| "Farmacia di turno" | Night/weekend pharmacy |

**Every area has rotating 24h pharmacy.** Posted on doors of closed pharmacies.

### What Pharmacists Can Do

Italian pharmacists are highly trained and can:
- Recommend OTC treatments
- Provide basic medical advice
- Give injections
- Dispense some medications without prescription
- Point you to appropriate care

### Common Medications

| English | Italian | Notes |
|---------|---------|-------|
| Paracetamol | Paracetamolo/Tachipirina | Over-the-counter |
| Ibuprofen | Ibuprofene/Moment | Over-the-counter |
| Antihistamine | Antistaminico | May ask for symptoms |
| Antidiarrheal | Antidiarroico/Imodium | Over-the-counter |
| Rehydration salts | Sali reidratanti | For stomach issues |
| Sunscreen | Crema solare | Good quality available |

### Pharmacy Hours

| Type | Hours |
|------|-------|
| Regular | 08:30-12:30, 15:30-19:30 |
| Closed | Sunday, Wednesday afternoon (varies) |
| Farmacia di turno | 24h rotating service |

## Police

### Types of Police

| Type | Role | Recognize By |
|------|------|--------------|
| Carabinieri | National military police | Dark blue/black uniforms |
| Polizia di Stato | State police | Light blue uniforms |
| Polizia Municipale | Local/traffic police | Varies by city |
| Guardia di Finanza | Financial police | Grey uniforms |

**For tourists:** Carabinieri or Polizia di Stato for crimes/emergencies.

### Reporting Crimes

| Step | Details |
|------|---------|
| 1. Go to station | "Questura" (Polizia) or Carabinieri station |
| 2. File report | "Denuncia" — get official copy |
| 3. For insurance | Report number required for claims |
| 4. Lost passport | Report + go to embassy |

**Tourist police offices** exist in major cities with English speakers.

### Theft/Pickpocketing

| Do | Details |
|----|---------|
| File report | Needed for insurance |
| Cancel cards | Call bank immediately |
| Block phone | Contact carrier |
| Contact embassy | If passport stolen |

**Pickpocket hotspots:** Metro, train stations, tourist crowds

## Lost/Stolen Documents

### Passport

1. **File police report** — Get "denuncia"
2. **Contact embassy** — Emergency replacement
3. **Provide:** Photos, report, proof of citizenship
4. **Timeline:** Same day emergency travel document possible

### Embassy Contacts

| Country | Rome Embassy Phone |
|---------|-------------------|
| USA | +39 06 46741 |
| UK | +39 06 4220 0001 |
| Canada | +39 06 85444 2911 |
| Australia | +39 06 852 721 |
| Germany | +39 06 492 131 |
| France | +39 06 686 011 |

### Credit Cards

| Action | Contact |
|--------|---------|
| Visa | +1 303 967 1096 |
| Mastercard | +1 636 722 7111 |
| Amex | +1 336 393 1111 |
| Your bank | Use app or known number |

**Save card numbers separately** from cards (photo of card backs helps).

## Natural Emergencies

### Earthquakes

Italy has seismic activity. If earthquake:
1. **Drop, cover, hold** — Under table if indoors
2. **Stay inside** — Away from windows
3. **After shaking** — Exit carefully, avoid elevators
4. **Outdoors** — Away from buildings, power lines

### Flooding (Acqua Alta - Venice)

| Action | Details |
|--------|---------|
| Check forecast | Hi!Tide Venice app |
| Buy boots | €10-15 at shops |
| Elevated walkways | "Passerelle" appear on major routes |
| Wait it out | Usually 3-4 hours |

### Wildfires (Summer)

Southern Italy and islands have fire risk in summer:
- Follow local alerts
- Don't throw cigarettes
- Report fires to 115

## Heat & Sun

### Heatwaves (July-August)

| Symptom | Action |
|---------|--------|
| Dizziness, nausea | Get to shade, drink water |
| Heat exhaustion | Cool down, rehydrate, rest |
| Heat stroke | Call 112, cool victim, medical emergency |

**Prevention:**
- Stay hydrated (buy water bottles everywhere)
- Rest during hottest hours (13:00-16:00)
- Air-conditioned museums = heat relief
- Wear sunscreen, hat

## Useful Italian Phrases for Emergencies

| English | Italian |
|---------|---------|
| Help! | Aiuto! |
| I need a doctor | Ho bisogno di un medico |
| Call an ambulance | Chiami un'ambulanza |
| Where is the hospital? | Dov'è l'ospedale? |
| I've been robbed | Sono stato/a derubato/a |
| I lost my passport | Ho perso il passaporto |
| I'm allergic to... | Sono allergico/a a... |
| It hurts here | Mi fa male qui |
| I don't feel well | Non mi sento bene |

## Before You Go Checklist

- [ ] Save emergency numbers in phone
- [ ] Photo of passport (separate from passport)
- [ ] Travel insurance documents accessible offline
- [ ] Credit card emergency numbers saved
- [ ] Embassy address/phone for your country
- [ ] Copy of prescriptions (with generic names)
- [ ] Blood type, allergies noted somewhere
