# Culture & Etiquette — Italy

Italians care deeply about fare bella figura (making a good impression). These rules will help you fit in.

## Greetings

### Words
| Time | Greeting |
|------|----------|
| Morning-afternoon (until ~17:00) | Buongiorno |
| Evening (after ~17:00) | Buonasera |
| Informal anytime | Ciao (only with people you know!) |
| Goodbye (formal) | Arrivederci |
| Goodbye (informal) | Ciao |

### Physical
- **One kiss on each cheek** — Start with their right cheek
- **Handshake** — For first meetings, business
- **When in doubt** — Follow their lead

**Common Mistake:** Using "Ciao" with strangers or service staff. Say "Buongiorno" first.

## Dining Etiquette

### At Restaurants

| Do | Don't |
|----|-------|
| Wait to be seated | Seat yourself without asking |
| Ask for the check ("Il conto, per favore") | Expect it to come automatically |
| Linger after eating | Rush out immediately |
| Order courses properly (primi, secondi) | Just order one main dish |
| Eat pasta with fork only | Use spoon for pasta |
| Bread for mopping sauce | Bread before food arrives |

### Course Structure
1. **Antipasto** — Starter (can share)
2. **Primo** — First course (pasta, risotto, soup)
3. **Secondo** — Main (meat or fish)
4. **Contorno** — Side dish (ordered separately!)
5. **Dolce** — Dessert
6. **Caffè** — Espresso
7. **Digestivo** — Amaro, grappa

**You don't have to order all courses.** Primo + secondo or antipasto + primo is normal.

### Coffee Rules

| Rule | Explanation |
|------|-------------|
| Cappuccino = morning only | After 11:00, it marks you as tourist |
| Stand at bar = cheaper | Sitting at table = 2-3x price |
| Espresso is default | Just say "un caffè" |
| No to-go culture | Drink at bar, enjoy moment |
| Latte = milk | If you want coffee with milk, say "latte macchiato" |

### Tipping

| Situation | Tip |
|-----------|-----|
| Restaurants | Round up or €1-2 max. Service included. |
| Bars | Leave coins in tip dish |
| Taxis | Round up to nearest euro |
| Hotels | €1-2/day housekeeping, €1-2 porters |
| Tour guides | €5-10 for half-day, €10-20 full day |

**Important:** Coperto (cover charge, €1-3/person) is NOT a scam. It's standard and legal.

## Dress Code

### Churches
- **Cover shoulders** — No tank tops
- **Cover knees** — No shorts/short skirts
- **Remove hats** — Men especially
- **Enforcement:** Guards will turn you away at major churches

### General

| Situation | Dress |
|-----------|-------|
| City walking | Smart casual, avoid gym clothes |
| Nice dinner | No shorts, smart shoes |
| Clubs | No sneakers, no sportswear |
| Beach towns | More relaxed (but not in restaurants) |

**Italian secret:** They dress well even for errands. You'll stand out in sweatpants.

## Gestures

Italians talk with hands. Some meanings:

| Gesture | Meaning |
|---------|---------|
| Fingertips together, hand moving up and down | "What do you want?" / "What are you saying?" |
| Chin flick | "I don't care" / "Go away" |
| Forearm pump | Insult (like giving the finger) |
| Hand cupping ear | "What?" |
| Finger twisting cheek | "Delicious!" |

**Warning:** Don't use gestures you don't understand. Some are offensive.

## Social Norms

### Time
- **Dinner:** 20:00-21:00 start is normal (not 18:00)
- **Lunch:** 13:00-15:00, often 2+ hours
- **Appointments:** Italians run late. Build in buffer.
- **Riposo:** 13:00-16:00 many shops close (especially south)

### Conversation
| Good Topics | Avoid |
|-------------|-------|
| Food, wine, region | WWII Italy |
| Football (calcio) | Mafia stereotypes |
| Family | Comparing to other countries |
| Art, history | Income, money |
| Their region specifically | Generalizing "all Italians" |

### Personal Space
- **Closer than Americans expect** — Don't back away
- **Eye contact** — Expected and appreciated
- **Volume** — Italians are louder than Nordic/Anglo cultures

## Religion

- **87% Catholic** (cultural if not practicing)
- **Vatican City** — Separate country within Rome
- **Church behavior:** Quiet, respectful, no photos during services
- **Saints' days:** Various holidays, businesses may close
- **Easter:** Huge deal, expect closures/processions

## Business Culture

| Norm | Explanation |
|------|-------------|
| Build relationships first | Don't rush to business |
| Titles matter | Dottore, Ingegnere, Avvocato used liberally |
| Dress formally | Suits expected in business |
| Long lunches | Business lunch can be 2-3 hours |
| August | Don't schedule important meetings |

## What NOT to Do

| Don't | Why |
|-------|-----|
| Ask for parmesan on seafood pasta | Culinary sin |
| Cut spaghetti | Fork twirl only |
| Drink cappuccino with dinner | Morning drink |
| Call all cheese "parmesan" | Many varieties, use correct name |
| Say "expresso" | It's "espresso" |
| Compare Italian pizza to American | Different thing entirely |
| Expect shops open 14:00 Sunday | They won't be |
| Complain about queue-cutting | Accept Italian "flow" |
| Be impatient | La dolce vita means slowing down |

## What Earns Respect

| Do | Why |
|----|-----|
| Speak any Italian | Even attempts appreciated |
| Know their region's specialties | Shows respect for local culture |
| Take time over meals | Rushing = American stereotype |
| Dress well | Bella figura matters |
| Greet shopkeepers entering/leaving | Basic courtesy |
| Accept regional differences | Italy unified only in 1861 |

## Useful Phrases

| Italian | English |
|---------|---------|
| Per favore | Please |
| Grazie / Grazie mille | Thank you / Thank you very much |
| Prego | You're welcome / Go ahead |
| Mi scusi | Excuse me (formal) |
| Scusa | Excuse me (informal) |
| Posso avere...? | May I have...? |
| Il conto, per favore | The check, please |
| Parla inglese? | Do you speak English? |
| Non capisco | I don't understand |
| Dov'è...? | Where is...? |
| Quanto costa? | How much does it cost? |
| Salute! | Cheers! (when toasting) |
