# Beaches — Italy

Italy has 7,600km of coastline. Here are the specific beaches worth your time, from famous to hidden.

## Amalfi Coast

### Beach Guide

| Beach | Location | Type | Access | Notes |
|-------|----------|------|--------|-------|
| Spiaggia Grande | Positano | Pebble | Walk | Main beach, crowded, €20+ for chair |
| Fornillo | Positano | Pebble | Walk (10min from main) | Smaller, slightly cheaper, locals prefer |
| Marina di Praia | Praiano | Pebble | Steps down | Tiny cove, dramatic cliffs, restaurant |
| Fiordo di Furore | Furore | Pebble | 500+ steps | Hidden fjord, iconic, worth the stairs |
| Marina Grande | Amalfi | Pebble | Walk | Town beach, convenient, crowded |
| Atrani | Atrani | Pebble | Walk | Charming village beach, less touristy |
| Maiori | Maiori | Sand | Walk | Longest sandy beach on coast |
| Erchie | Between Amalfi/Cetara | Pebble | Car/boat | Quiet fishing village cove |

### Beach Costs (Amalfi)
| Item | Free Beach | Stabilimento (Beach Club) |
|------|------------|---------------------------|
| Access | Free | €15-40/day |
| Chair + umbrella | Bring your own | Included |
| Facilities | None/basic | Showers, changing, bar |
| Crowd | Less structured | More organized |

### Getting There
- **From Naples:** SITA bus (€5, 2h, winding) or ferry from Molo Beverello
- **From Sorrento:** SITA bus or ferry
- **Driving:** Terrifying but possible. No parking in Positano

## Cinque Terre

| Beach | Village | Type | Notes |
|-------|---------|------|-------|
| Fegina | Monterosso | Sand | Only sandy beach in Cinque Terre |
| Guvano | Near Corniglia | Rocks | Former nudist beach, scenic hike to reach |
| Corniglia | Corniglia | Rocks | At base of 365 steps, bring water shoes |
| Manarola | Manarola | Rocks | Tiny, platform into sea |
| Riomaggiore | Riomaggiore | Rocks | Pebbly cove, small marina |

**Best for Swimming:** Monterosso (actual beach) or boat trips to find quiet spots

## Sardinia

### Northeast (Costa Smeralda & Beyond)

| Beach | Location | Notes |
|-------|----------|-------|
| Spiaggia del Principe | Costa Smeralda | White sand, turquoise water, some free spots |
| Capriccioli | Costa Smeralda | Multiple coves, some free areas |
| La Pelosa | Stintino (northwest) | Iconic, arrives 07:00 in summer (fills by 09:00) |
| Cala Brandinchi | San Teodoro | "Little Tahiti," incredibly clear |
| Porto Istana | Olbia area | Facing Tavolara island, family-friendly |

### South & West

| Beach | Location | Notes |
|-------|----------|-------|
| Chia | South coast | Dunes, pink flamingos, multiple beaches |
| Tuerredda | Teulada | Crystal clear, small paradise |
| Cala Goloritzé | Baunei (east) | UNESCO site, boat access or 2h hike |
| Is Arutas | Oristano | Quartz "rice grain" sand, unique |
| Mari Ermi | Near Is Arutas | Similar quartz sand, less famous |

### Access Notes
- **Car essential** in Sardinia — public transport doesn't reach best beaches
- **Peak season:** July-August, beaches packed by 10:00
- **Off-season:** May-June, September gorgeous and quieter

### Ferry to Sardinia
| From | To | Duration | Price |
|------|-----|----------|-------|
| Civitavecchia (Rome) | Olbia | 6-8h | €40-80 |
| Genoa | Porto Torres | 10-12h | €50-100 |
| Livorno | Olbia | 6-8h | €35-70 |

**Night ferries:** Cabin adds €50-100 but arrives fresh in morning

## Puglia

### Salento Peninsula (South)

| Beach | Location | Notes |
|-------|----------|-------|
| Porto Selvaggio | Nardò | Natural park, rocky coves, pine forest |
| Torre dell'Orso | Melendugno | Twin rock stacks ("Due Sorelle"), sandy |
| Punta Prosciutto | Porto Cesareo | Shallow, clear, family-friendly |
| Baia dei Turchi | Otranto | Historic site, white cliffs, sandy |
| Pescoluse | Salve | "Maldives of Italy," shallow warm water |
| Santa Cesarea Terme | East coast | Thermal waters, dramatic caves |

### Gargano Peninsula (North)

| Beach | Location | Notes |
|-------|----------|-------|
| Baia delle Zagare | Mattinata | Limestone stacks, pebble, stunning |
| Vignanotica | Near Mattinata | White cliffs, remote access |
| Vieste beaches | Vieste | Multiple options, town has facilities |
| Isole Tremiti | Ferry from Vieste | Island archipelago, excellent snorkeling |

## Sicily

| Beach | Location | Notes |
|-------|----------|-------|
| San Vito Lo Capo | Northwest | Famous sandy beach, couscous festival |
| Scala dei Turchi | Agrigento | White cliff "Turkish steps," iconic |
| Isola Bella | Taormina | Pebble beach with island, very touristy |
| Calamosche | Noto | Natural reserve, hike in, pristine |
| Cefalù | North coast | Sandy town beach, Norman cathedral backdrop |
| Mondello | Palermo | Easy access from city, crowded but fun |

### Aeolian Islands
| Island | Beach | Notes |
|--------|-------|-------|
| Lipari | White Beach (Spiaggia Bianca) | Pumice beach, white sand |
| Salina | Pollara | Dramatic crater beach, Il Postino filming location |
| Vulcano | Black sand beaches | Volcanic, mud baths, sulfur smell |
| Panarea | Exclusive | Celeb island, glamorous |

## Lake Beaches

### Lake Garda
| Beach | Town | Notes |
|-------|------|-------|
| Spiaggia Jamaica | Sirmione | Flat rocks, crystal water |
| Riva del Garda | Riva | Mountain backdrop, windsurfing |
| Limone sul Garda | Limone | Pebble, charming town |

### Lake Como
| Beach | Town | Notes |
|-------|------|-------|
| Lido di Lenno | Lenno | Lido with views of Villa Balbianello |
| Lido di Varenna | Varenna | East shore, quieter |

## Practical Tips

### What to Bring
- **Water shoes** — Many Italian beaches are pebble/rocky
- **Cash** — Beach bars often cash-only
- **Shade** — Umbrella if not paying for stabilimento
- **Snorkeling gear** — Mediterranean is worth exploring

### Beach Club (Stabilimento) Culture
- **Booking:** Peak season (Aug), book days ahead
- **Price:** €20-60/day for 2 chairs + umbrella
- **Includes:** Usually access to bar, showers, toilets
- **Free sections:** Often less desirable spots at edges

### Best Time
| Month | Water Temp | Crowds | Notes |
|-------|------------|--------|-------|
| May-June | 20-24°C | Moderate | Best combination |
| July-Aug | 25-28°C | Packed | Italian vacation month |
| September | 24-26°C | Lower | Still warm, fewer crowds |
| October | 20-22°C | Low | Water still swimmable in south |
