# Essential Apps — Italy

Download these before you go. Italian apps often work better than international alternatives.

## Transport

### Trains

| App | Purpose | Notes |
|-----|---------|-------|
| **Trenitalia** | High-speed trains (Frecce), regional | Official app, buy tickets, check delays |
| **Italo Treno** | Private high-speed trains | Often cheaper than Trenitalia, same routes |
| **Trainline** | Compare both + buy | Sometimes better prices, good interface |

**Tip:** Trenitalia app lets you store tickets digitally — screenshot QR code as backup.

### Buses

| App | Purpose | Notes |
|-----|---------|-------|
| **FlixBus** | Long-distance buses | Cheap, connects smaller cities |
| **SITA Sud** | Amalfi Coast buses | Check schedules (no app, use website) |
| **Moovit** | City public transport | Real-time arrivals, route planning |

### Ride Sharing & Taxis

| App | Purpose | Notes |
|-----|---------|-------|
| **FreeNow** | Official taxis | Works in major cities, fixed prices |
| **Uber** | Limited service | Only black cars in Italy, expensive |
| **itTaxi** | Italian taxi app | Good in smaller cities |

**Reality:** Uber barely works in Italy. FreeNow or street hailing are better.

## Maps & Navigation

| App | Purpose | Notes |
|-----|---------|-------|
| **Google Maps** | General navigation | Download offline maps! |
| **Citymapper** | Public transport | Rome, Milan only |
| **Maps.me** | Offline maps | Great for hiking, remote areas |
| **Komoot** | Hiking trails | Detailed trail info |

**Offline maps are critical.** Cell service spotty in rural areas.

## Food & Restaurants

| App | Purpose | Notes |
|-----|---------|-------|
| **TheFork** | Reservations | Owned by TripAdvisor, discounts common |
| **Quandoo** | Reservations | Good in northern Italy |
| **TripAdvisor** | Reviews | Take with grain of salt, but useful |
| **Yelp** | Reviews | Patchy coverage in Italy |
| **Happy Cow** | Vegetarian/vegan | Find veggie options |

**Pro tip:** Many Italian restaurants don't use apps. Call to reserve ("Vorrei prenotare un tavolo per stasera...").

## Tourism & Tickets

| App | Purpose | Notes |
|-----|---------|-------|
| **Tiqets** | Skip-the-line tickets | Major attractions, instant delivery |
| **GetYourGuide** | Tours and tickets | Wide selection |
| **Airbnb Experiences** | Local activities | Cooking classes, tours |
| **Viator** | Tours | Another good option |
| **Musement** | Italian platform | Strong in Italy |

**Book these on apps:** Vatican, Colosseum, Uffizi, Accademia. Skip-the-line is essential.

## Venice Specific

| App | Purpose | Notes |
|-----|---------|-------|
| **Hi!Tide Venice** | Acqua alta alerts | Flood forecasts, essential Oct-Feb |
| **ACTV Venezia** | Vaporetto timetables | Official water bus app |
| **Ciao Venezia** | City info | Events, vaporetto, general info |

## Payment & Money

| App | Purpose | Notes |
|-----|---------|-------|
| **Wise** | Multi-currency card | Best exchange rates |
| **Revolut** | Travel card | Free ATM withdrawals (limits) |
| **XE Currency** | Exchange rates | Offline access |
| **Satispay** | Italian payment app | Works at some local shops |

**Note:** Apple Pay and Google Pay work widely. Contactless is common.

## Language

| App | Purpose | Notes |
|-----|---------|-------|
| **Google Translate** | Translation | Download Italian for offline |
| **Duolingo** | Learn basics | Free, gamified |
| **Babbel** | Learn Italian | Better structure than Duolingo |

**Download offline:** Google Translate Italian language pack before you go.

## Communication

| App | Purpose | Notes |
|-----|---------|-------|
| **WhatsApp** | Messaging | Italians use this, not SMS |
| **FaceTime/WhatsApp** | Calls home | Over WiFi |

**Everyone in Italy uses WhatsApp.** If you don't have it, download it.

## Weather

| App | Purpose | Notes |
|-----|---------|-------|
| **Weather Underground** | Detailed forecasts | Good hourly predictions |
| **3B Meteo** | Italian weather | Locals use this, accurate |
| **ARPAV** | Regional forecasts | Government meteorology |

## Miscellaneous

| App | Purpose | Notes |
|-----|---------|-------|
| **Enel X Way** | EV charging | If renting electric car |
| **ViaMichelin** | Road trips | ZTL alerts, tolls, routes |
| **Telepass Pay** | Highway tolls | Register to skip toll booths |

## Must-Download Before Leaving

**Tier 1 (Essential):**
1. Trenitalia or Trainline
2. Google Maps (offline)
3. FreeNow
4. WhatsApp
5. Your bank's app

**Tier 2 (Helpful):**
1. TheFork
2. Google Translate (offline Italian)
3. Moovit or Citymapper
4. Hi!Tide Venice (if going to Venice)
5. Tiqets or GetYourGuide

## App-Less Alternatives

| Need | Without App |
|------|-------------|
| Train tickets | Ticket machines at stations (English available) |
| Reservations | Call restaurant directly |
| Maps | Paper maps still work, buy at newsstand |
| Translation | Pocket dictionary, pointing |
| Taxis | Hail on street, taxi stands at stations |

**Italian Reality:** Many small businesses, trattorias, and locals don't use apps. Be prepared to communicate the old-fashioned way.

## Phone Setup Tips

1. **Enable international calling** — Just in case
2. **Download offline content** — Maps, translation
3. **Set up contactless payment** — Apple/Google Pay
4. **Screenshot confirmations** — Not all PDFs load offline
5. **Bring backup battery** — Map apps drain fast
