---
name: Italian
description: Write Italian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Italian is technically correct but sounds off. Too formal. Too complete. Too textbook. Natives write with more warmth, expressiveness, and personality. Match that.

## Formality Default

Default register is too high. Casual Italian is warm and direct. Unless explicitly formal: lean casual. "Ciao" not "Buongiorno" with peers. "Sì" not "Certamente". "Ok" not "D'accordo".

## Tu vs Lei

Get this right—it defines everything:
- Lei: strangers, professional, elderly, formal situations
- Tu: friends, family, peers, casual
- Italians switch to tu quickly in social settings
- Overusing Lei = cold, distant, foreign

## Expressiveness Is Expected

Italian amplifies. Use it:
- Superlatives: "bellissimo", "buonissimo", "tantissimo"
- Diminutives: "momentino", "pochino", "carino"
- Augmentatives: "benone", "grandone"
- Missing these = flat, un-Italian

## Fillers & Flow

Real Italian has fillers. Use them:
- "Allora", "quindi", "insomma", "comunque"
- "Cioè", "tipo", "praticamente"
- "Boh", "mah", "beh", "eh"
- "Senti", "guarda", "dai"
- Missing these = textbook Italian

## Sentence Fragments

Don't always complete sentences:
- "Vieni?" "Sì, un attimo."
- "Tutto bene?" "Sì sì, tranquillo."
- "Ti piace?" "Tantissimo!"
- Let context and tone carry weight.

## Common Expressions

Use natural expressions:
- "Non c'è problema", "figurati", "ma va"
- "Che bello!", "mamma mia!", "madonna!"
- "Per carità", "magari!", "ecco"
- "Ci sta", "mi sa che...", "mica male"

## Reactions

React like a human:
- "Davvero?", "Sul serio?", "Ma dai!"
- "Pazzesco!", "Incredibile!", "Assurdo!"
- "Che palle", "che casino", "che figura"
- "Ahaha", "ahahah" in text

## Double Consonants Matter

Spelling precision is identity:
- "Anno" vs "ano" (year vs anus)
- "Penna" vs "pena" (pen vs pain)
- "Cassa" vs "casa" (cash register vs house)
- Getting these wrong = instant foreigner tell

## Gestures in Text

Italian expressiveness translates to text:
- Emphasis through repetition: "bello bello", "piano piano"
- Exclamations: "Ma!", "Eh!", "Ah!"
- Rhetorical questions as reactions

## Regional Awareness

If region known, adapt:
- North: more reserved, "scialla" (Milan)
- Rome: "daje", "aò", "nun" instead of "non"
- Naples: "uè", "jamm", warmer diminutives
- Don't mix. Stay consistent.

## Punctuation

Italian punctuation:
- «Virgolette» for quotes in formal
- Exclamation points more common than English
- Numbers: 1.000,50 (period for thousands, comma for decimals)

## The "Native Test"

Before sending: would an Italian screenshot this as "AI-generated"? If yes—too cold, too proper, too flat. Add warmth.
