# War Room — Domain Adaptation

## Finance / Investment

| Role | Domain Focus | Mandatory Question |
|------|-------------|-------------------|
| Analyst | Returns, Sharpe, volatility, DCA optimization | "Calculate Sharpe ratio and expected return with formulas." |
| Guardian | Drawdown, VaR/CVaR, correlation, kill switches | "If [X] fails, what is the max portfolio loss in dollars?" |
| Treasurer | Capital efficiency, trading costs, tax impact | "Per $1 invested, what is the 12-month expected return?" |
| Builder | Broker selection, automation, execution timeline | "What broker/tools, and what is the setup time/cost?" |
| Strategist | Portfolio fit, diversification, alternative allocations | "How does this fit a long-term wealth strategy?" |

## Product / Feature Decision

| Role | Domain Focus | Mandatory Question |
|------|-------------|-------------------|
| Analyst | Metrics model, conversion funnel, A/B test design | "What is the expected lift in [metric] with confidence interval?" |
| Guardian | Failure modes, user churn risk, technical debt | "If adoption is 50% of forecast, what is the cost of building this?" |
| Treasurer | Unit economics, CAC/LTV, engineering cost | "Per $1 of engineering investment, what is the expected revenue?" |
| Builder | Technical architecture, timeline, staffing needs | "How many engineer-weeks and what are the dependencies?" |
| Strategist | Product vision fit, competitive landscape, cannibalization | "Does this strengthen or dilute our product positioning?" |

## Engineering / Architecture

| Role | Domain Focus | Mandatory Question |
|------|-------------|-------------------|
| Analyst | Performance benchmarks, latency, throughput modeling | "What are the p50/p99 latency targets and how do we measure?" |
| Guardian | Security, reliability, blast radius, rollback plan | "If this system fails at peak load, what is the blast radius?" |
| Treasurer | Build vs buy, infrastructure cost, maintenance burden | "What is the 3-year TCO including maintenance?" |
| Builder | Implementation plan, migration path, testing strategy | "What is the migration plan and estimated downtime?" |
| Strategist | Tech strategy fit, vendor lock-in, future scalability | "Does this create technical debt or reduce it?" |

## Hiring / Team Decision

| Role | Domain Focus | Mandatory Question |
|------|-------------|-------------------|
| Analyst | Compensation benchmarking, market data, offer modeling | "What is the market rate and our percentile positioning?" |
| Guardian | Attrition risk, single-point-of-failure, culture fit risk | "If this hire leaves in 6 months, what is the total cost?" |
| Treasurer | Total cost of hire, ramp time, productivity timeline | "Per $1 of total compensation, what is the expected output?" |
| Builder | Interview process, onboarding plan, tooling needs | "What is the time-to-productivity and onboarding plan?" |
| Strategist | Team strategy, org structure, succession planning | "How does this hire fit our 2-year team roadmap?" |
