---
name: personal-brand-story
description: Generate compelling personal brand stories following the proven "5-Step Story Structure" framework. Use this skill when users request: (1) Creating personal brand stories or introductions, (2) Writing entrepreneur/creator biographies, (3) Crafting personal origin stories, (4) Building "about me" pages for personal websites, (5) Writing personal narratives for marketing or social media. The framework includes: Pain Point Resonance → Key Turning Point → Conflict Depiction → Strong Philosophy Output → Highlight Results.
---

# Personal Brand Story Generator

Generate compelling personal brand stories using the proven 5-step framework.

## The 5-Step Story Structure

Every effective personal brand story follows this structure:

| Step | Purpose | Key Elements |
|------|---------|--------------|
| **1. Pain/Event Resonance** | Connect with reader through shared experience | Describe a relatable struggle, Paint a vivid picture, Use sensory details |
| **2. Key Turning Point** | The "Why Change?" moment | What triggered the change, Use contrast (before/after), Use parallel sentences, Strong philosophy + belief output |
| **3. Conflict Depiction** | Show the struggle during change | External obstacles (doubt, opposition, failure), Internal emotional struggle, Strong philosophy reinforcement |
| **4. Strong Philosophy Output** | Elevate to universal truth | Counter-intuitive insights, Parallel sentences for impact, Memorable quotes/golden lines |
| **5. Highlight Results** | Prove with data and social proof | Effort invested, Data/results/case studies, Before/after comparison, User testimonials |

## Writing Principles

### Tone & Style
- **Authentic vulnerability**: Share real struggles, not curated perfection
- **Specific over generic**: Use concrete numbers, dates, names
- **Emotional resonance**: Connect to universal human experiences (family, fear, loss, ambition)
- **Professional credibility**: Balance personal story with expertise proof

### Data Requirements
For each story, gather:
- **Origin story**: Where you started (specific salary, position, situation)
- **Turning point**: Exact moment or event that triggered change
- **Obstacles**: Specific challenges faced (internal and external)
- **Proof points**: Hard numbers, timelines, recognizable names
- **Philosophy**: Core beliefs that guide your work

### Common Patterns

**Pattern A: Corporate Escape**
- Starts: Stable job, unfulfilled
- Turning Point: Health scare, family event, burnout realization
- Conflict: Leaving security, others' doubts, early failures
- Result: Built successful business on own terms

**Pattern B: Expert to Entrepreneur**
- Starts: High achiever in corporate/field
- Turning Point: Realized income ceiling, wanted impact + freedom
- Conflict: Imposter syndrome, pricing fears, scaling challenges
- Result: Multiple income streams, recognized authority

**Pattern C: Phoenix Rising**
- Starts: Hit rock bottom (loss, failure, setback)
- Turning Point: Decision to rebuild differently
- Conflict: Rebuilding from nothing, proving worth
- Result: Stronger than before, helping others avoid same fate

## Quick Start Template

```
# Title: [Your Story Hook]

[Hook paragraph - capture attention with a provocative statement]

## Part 1: The Before (Pain Point Resonance)
- Describe your starting situation with specific details
- Show, don't tell - use sensory language
- Make it relatable to your target audience

## Part 2: The Awakening (Key Turning Point)
- The exact moment everything changed
- Why it mattered - connect to deeper meaning
- Use a quote or philosophy statement

## Part 3: The Struggle (Conflict Depiction)
- External obstacles you faced
- Internal doubts and fears
- Show vulnerability

## Part 4: The Breakthrough (Strong Philosophy)
- Core insight or realization
- Counter-intuitive truth you discovered
- Memorable line readers will quote

## Part 5: The Transformation (Highlight Results)
- Specific achievements with numbers
- Timeline of progress
- Social proof and testimonials
- How this helps your audience now

[Closing - Call to action or connection invitation]
```

## Workflow

1. **Gather input**: Interview the user for their story elements using the 5-step framework
2. **Structure content**: Organize into the 5-step structure
3. **Enhance with techniques**: Apply rhetorical devices (parallelism, contrast, golden lines)
4. **Add credibility**: Insert specific numbers, names, dates throughout
5. **Review against framework**: Ensure each of the 5 steps is present and compelling

## References

For detailed examples and advanced patterns, see:
- [reference.md](references/reference.md) - The original "Wanying" story as reference
- [templates.md](references/templates.md) - Ready-to-use story templates by industry
