---
name: Invoices
description: Capture, extract, and organize received invoices with automatic OCR, provider detection, and searchable archive.
---

## Trigger

Use when user receives invoices (email, photo, PDF) and wants them organized automatically.

**Key difference:** This skill MANAGES received invoices. The `invoice` skill CREATES invoices to send.

---

## Storage

```
~/invoices/
├── inbox/                    # Unprocessed files awaiting extraction
├── archive/                  # Organized by year/month
│   └── 2026/
│       └── 02/
│           └── 2026-02-13_Hetzner_INV-12345_89.50.pdf
├── providers/                # Provider metadata
│   └── index.json
├── entries.json              # All invoice metadata (searchable)
└── state.json                # Processing state
```

---

## Quick Reference

| Topic | File |
|-------|------|
| Capture and extraction workflow | `process.md` |
| Fields to extract | `extraction.md` |
| Search queries and reports | `search.md` |
| Legal requirements by country | `legal.md` |

---

## Process Summary

1. **Capture** — Receive invoice (email attachment, photo, direct PDF). Copy to `inbox/`.
2. **Extract** — OCR if needed, parse fields (provider, date, amounts, tax).
3. **Validate** — Check required fields, detect duplicates.
4. **Organize** — Rename, move to `archive/YYYY/MM/`, update `entries.json`.
5. **Confirm** — Show extracted data, allow corrections.

See `process.md` for detailed workflow.

---

## Critical Rules

- **Never delete originals** — Keep PDFs permanently. Legal requirement (4-6 years depending on country).
- **Detect duplicates** — Same invoice number + provider = duplicate. Alert, don't overwrite.
- **Validate tax math** — Base + tax should equal total. Flag discrepancies.
- **Provider normalization** — "HETZNER ONLINE GMBH" = "Hetzner". Maintain provider aliases.

---

## Alerts

- Invoice pending >48h in inbox
- Payment due in <7 days
- Unusual amount (>50% higher than same provider average)
- Missing expected recurring invoice
